<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

/**
 * Elementor whmcs_product_price Widget.
 *
 * Elementor widget that uses the whmcs_product_price control.
 *
 * @since 1.0.0
 */
class Elementor_Whmcs_Product_Price_Widget extends \Elementor\Widget_Base {

	/**
	 * Get widget name.
	 *
	 * Retrieve whmcs whmcs_product_price widget name.
	 *
	 * @since 1.0.0
	 * @access public
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'whmcs_product_price';
	}

	/**
	 * Get widget title.
	 *
	 * Retrieve whmcs whmcs_product_price widget title.
	 *
	 * @since 1.0.0
	 * @access public
	 * @return string Widget title.
	 */
	public function get_title() {
		return esc_html__( 'WHMCS Price Only', 'elementor-whmcs_product_price-control' );
	}

	/**
	 * Get widget icon.
	 *
	 * Retrieve whmcs whmcs_product_price_widget icon.
	 *
	 * @since 1.0.0
	 * @access public
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'eicon-price-list';
	}

	/**
	 * Register whmcs whmcs_product_price widget controls.
	 *
	 * Add input fields to allow the user to customize the widget settings.
	 *
	 * @since 1.0.0
	 * @access protected
	 */
	protected function register_controls() {

		$this->start_controls_section(
			'content_section',
			[
				'label' => esc_html__( 'Content', 'elementor-whmcs_product_price-control' ),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);
		$this->add_control(
            'selected_value_name',
            [
                'label' => 'Select Product Name',
                'type' => \Elementor\Controls_Manager::SELECT,
                'options' => [
                    '' => 'Select an option', // Placeholder
                ],
            ]
        );
		
		$this->add_control(
            'selected_value_price',
            [
                'label' => 'Select Product Currency',
                'type' => \Elementor\Controls_Manager::SELECT,
                'options' => [
                    '' => 'Select an option', // Placeholder
                ],
            ]
        );

		$this->add_control(
            'warning_text',
            [
                'type' => 'raw_html',
                'label' => ' Please Sync your WHMCS from dashboard <strong>hostiko > WHMCS </strong> and then Select WHMCS Product Name and currency',
                'content' => '<input type="text" value="This is a warning message" disabled>',
            ]
        );
		$this->add_control(
			'show_price',
			[
				'label' => esc_html__( 'Show Price', 'elementor-whmcs_product_price-control' ),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'label_on' => esc_html__( 'Show', 'elementor-whmcs_product_price-control' ),
				'label_off' => esc_html__( 'Hide', 'elementor-whmcs_product_price-control' ),
				'return_value' => 'yes',
				'default' => 'yes',
			]
		);
        $this->end_controls_section();

		/////////////////////////////////////////////////////////////////////////////////////////////////////
		// Select Box Widget Controls Start
        $this->start_controls_section(
            'select_box_section',
            [
                'label' => esc_html__( 'Select Box', 'elementor-whmcs_product_price-control' ),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );
		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name' => 'whmcs_product_price_typography',
				'label' => __( 'Typography', 'elementor-whmcs_product_price-control' ),
				'selector' => '{{WRAPPER}} .hostiko-select-field span',
				'global' => [
					'default' => \Elementor\Core\Kits\Documents\Tabs\Global_Typography::TYPOGRAPHY_PRIMARY,
				],
			]
		);
		// Style Tabs Normal Start
		$this->start_controls_tabs(
			'style_tabs'
		);

		$this->start_controls_tab(
			'style_normal_tab',
			[
				'label' => esc_html__( 'Normal', 'elementor-whmcs_product_price-control' ),
			]
		);
		$this->add_control(
            'whmcs_product_price_normal_color',
            [
                'label' => esc_html__('Dropdown List Color', 'elementor-whmcs_product_price-control'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .hostiko-select-field.nice-select .option' => 'color: {{VALUE}}',
                ],
				'global' => [
					'default' => \Elementor\Core\Kits\Documents\Tabs\Global_Colors::COLOR_PRIMARY,
				],
            ]
        );
		$this->end_controls_tab();
		// Style Tabs Normal End
		// Style Tabs Hover Start
		$this->start_controls_tab(
			'style_hover_tab',
			[
				'label' => esc_html__( 'Hover', 'elementor-whmcs_product_price-control' ),
			]
		);
		$this->add_control(
            'whmcs_product_price_hover_color',
            [
                'label' => esc_html__('Dropdown List Color', 'elementor-whmcs_product_price-control'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .hostiko-select-field.nice-select .option:hover' => 'color: {{VALUE}}',
                ],
				'global' => [
					'default' => \Elementor\Core\Kits\Documents\Tabs\Global_Colors::COLOR_PRIMARY,
				],
            ]
        );
		$this->add_control(
            'whmcs_product_price_hover_background_color',
            [
                'label' => esc_html__('Dropdown List Background', 'elementor-whmcs_product_price-control'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .hostiko-select-field.nice-select .option:hover' => 'background: {{VALUE}}',
                ],
            ]
        );
		$this->add_control(
            'whmcs_product_price_border_hover_color',
            [
                'label' => esc_html__('Dropdown Border Bar Color', 'elementor-whmcs_product_price-control'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}}  .hostiko-select-field.nice-select .option:hover::before' => 'background: {{VALUE}}',
                ],
            ]
        );
		$this->end_controls_tab();
		// Style Tabs Hover End
		// Style Tabs Active Start
		$this->start_controls_tab(
			'style_active_tab',
			[
				'label' => esc_html__( 'Active', 'elementor-whmcs_product_price-control' ),
			]
		);
		$this->add_control(
            'whmcs_product_price_active_color',
            [
                'label' => esc_html__('Dropdown List Color', 'elementor-whmcs_product_price-control'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .hostiko-select-field.nice-select .option.selected.focus' => 'color: {{VALUE}}',
                ],
				'global' => [
					'default' => \Elementor\Core\Kits\Documents\Tabs\Global_Colors::COLOR_PRIMARY,
				],
            ]
        );
		$this->add_control(
            'whmcs_product_price_active_background_color',
            [
                'label' => esc_html__('Dropdown List Background', 'elementor-whmcs_product_price-control'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .hostiko-select-field.nice-select .option.selected.focus' => 'background: {{VALUE}}',
                ],
            ]
        );
		$this->add_control(
            'whmcs_product_price_border_active_color',
            [
                'label' => esc_html__('Dropdown Border Bar Color', 'elementor-whmcs_product_price-control'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .hostiko-select-field.nice-select .option.selected::before' => 'background: {{VALUE}}',
                ],
            ]
        );
		$this->end_controls_tabs();
		// Style Tabs Active End
		$this->add_control(
            'whmcs_product_price_background_color',
            [
                'label' => esc_html__('Dropdown Item Background', 'elementor-whmcs_product_price-control'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .hostiko-select-field.nice-select .list' => 'background: {{VALUE}}',
                ],
            ]
        );
		$this->add_responsive_control(
			'whmcs_product_select_color',
			[
				'label' => esc_html__('Dropdown Text Color', 'elementor-whmcs_product_price-control'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .hostiko-select-field .current' => 'color: {{VALUE}}',
                ],
			]
		); 
        $this->add_responsive_control(
			'whmcs_product_select_padding',
			[
				'label' => __( 'Dropdown Padding', 'elementor-whmcs_product_price-control' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'selectors' => [
					'{{WRAPPER}} .hostiko-select-field' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		); 
		$this->add_responsive_control(
			'whmcs_product_dropdown_padding',
			[
				'label' => __( 'Dropdown List Padding', 'elementor-whmcs_product_price-control' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'selectors' => [
					'{{WRAPPER}} .hostiko-select-field.nice-select .option' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		); 
		$this->add_control(
            'whmcs_product_price_alignment',
            [
                'label' => esc_html__('Alignment', 'elementor-whmcs_product_price-control'),
                'type' => \Elementor\Controls_Manager::CHOOSE,
                'options' => [
                    'left' => [
                        'title' => esc_html__('Left', 'elementor-whmcs_product_price-control'),
                        'icon' => 'eicon-text-align-left',
                    ],
                    'center' => [
                        'title' => esc_html__('Center', 'elementor-whmcs_product_price-control'),
                        'icon' => 'eicon-text-align-center',
                    ],
                    'right' => [
                        'title' => esc_html__('Right', 'elementor-whmcs_product_price-control'),
                        'icon' => 'eicon-text-align-right',
                    ],
                ],
                'default' => 'left',
                'selectors' => [
                    '{{WRAPPER}} .hostiko-select-field' => 'text-align: {{VALUE}};',
                ],
            ]
        );
		$this->end_controls_section();
		// Select Box Widget Controls End
		// Price Widget Controls Start
		$this->start_controls_section(
            'price_widget_setting',
            [
                'label' => esc_html__( 'Price Widget', 'elementor-whmcs_product_price-control' ),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
				'condition' => [
					'show_price' => 'yes',
				],
            ]
        );
		$this->add_responsive_control(
			'price_widget_padding',
			[
				'label' => esc_html__( 'Padding', 'elementor-whmcs_product_price-control' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
				'selectors' => [
					'{{WRAPPER}} .hostiko-price-outer' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
				'condition' => [
					'show_price' => 'yes',
				],
			]
		);
        $this->add_responsive_control(
            'price_widget_align',
            [
                'label' => esc_html__( 'Price Widget Alignment', 'elementor-whmcs_product_price-control' ),
                'type' => \Elementor\Controls_Manager::CHOOSE,
                'options' => [
                    'left' => [
                        'title' => esc_html__( 'Left', 'elementor-whmcs_product_price-control' ),
                        'icon' => 'eicon-text-align-left',
                    ],
                    'center' => [
                        'title' => esc_html__( 'Center', 'elementor-whmcs_product_price-control' ),
                        'icon' => 'eicon-text-align-center',
                    ],
                    'right' => [
                        'title' => esc_html__( 'Right', 'elementor-whmcs_product_price-control' ),
                        'icon' => 'eicon-text-align-right',
                    ],
                ],
                'default' => 'left',
                'toggle' => true,
                'selectors' => [
                    '{{WRAPPER}} .hostiko-price-outer'   => 'text-align: {{VALUE}};',
                ],
				'condition' => [
					'show_price' => 'yes',
				],
            ]
        );
        $this->end_controls_section();
		// Price Widget Controls End
		// Currency Controls Start
		$this->start_controls_section(
            'currency_setting',
            [
                'label' => esc_html__( 'Currency', 'elementor-whmcs_product_price-control' ),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
				'condition' => [
					'show_price' => 'yes',
				],
            ]
        );
        $this->add_control(
			'currency_space',
			[
				'label' => esc_html__( 'Space', 'elementor-whmcs_product_price-control' ),
				'type' => \Elementor\Controls_Manager::SLIDER,
				'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
				'range' => [
					'px' => [
						'min' => -100,
						'max' => 100,
						'step' => 1,
					],
					'%' => [
						'min' => 0,
						'max' => 100,
					],
				],
				'default' => [
					'unit' => 'px',
				],
				'selectors' => [
					'{{WRAPPER}} .hostiko-price-outer .currency' => 'top: {{SIZE}}{{UNIT}};',
				],
			]
		);
		$this->add_control(
            'currency_color',
            [
                'label' => esc_html__( 'Currency Color', 'elementor-whmcs_product_price-control' ),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .hostiko-price-outer .currency' => 'color: {{VALUE}}',
                ],
                'global' => [
                    'default' => \Elementor\Core\Kits\Documents\Tabs\Global_Colors::COLOR_PRIMARY,
                ],
            ]
        );
        $this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name' => 'currency_typography',
				'selector' => '{{WRAPPER}} .hostiko-price-outer .currency',
			]
		);
        $this->end_controls_section();
		// Currency Controls End
		
		// Price Controls Start
        $this->start_controls_section(
            'price_setting',
            [
                'label' => esc_html__( 'Price', 'elementor-whmcs_product_price-control' ),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
				'condition' => [
					'show_price' => 'yes',
				],
            ]
        );
        $this->add_responsive_control(
			'price_padding',
			[
				'label' => esc_html__( 'Padding', 'elementor-whmcs_product_price-control' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
				'selectors' => [
					'{{WRAPPER}} .hostiko-price-outer .price' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);
		$this->add_control(
            'price_color',
            [
                'label' => esc_html__( 'Price Color', 'elementor-whmcs_product_price-control' ),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .hostiko-price-outer .price' => 'color: {{VALUE}}',
                ],
                'global' => [
                    'default' => \Elementor\Core\Kits\Documents\Tabs\Global_Colors::COLOR_PRIMARY,
                ],
            ]
        );
        $this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name' => 'price_typography',
				'selector' => '{{WRAPPER}} .hostiko-price-outer .price',
			]
		);
        $this->end_controls_section();
		// Price Controls End

		// Decimal Controls Start
		$this->start_controls_section(
            'decimal_setting',
            [
                'label' => esc_html__( 'Decimal', 'elementor-whmcs_product_price-control' ),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
				'condition' => [
					'show_price' => 'yes',
				],
            ]
        );
        $this->add_responsive_control(
			'decimal_padding',
			[
				'label' => esc_html__( 'Padding', 'elementor-whmcs_product_price-control' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
				'selectors' => [
					'{{WRAPPER}} .hostiko-price-outer .decimal-outer .decimal' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);
		$this->add_control(
            'decimal_color',
            [
                'label' => esc_html__( 'Decimal Color', 'elementor-whmcs_product_price-control' ),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .hostiko-price-outer .decimal-outer .decimal' => 'color: {{VALUE}}',
                ],
                'global' => [
                    'default' => \Elementor\Core\Kits\Documents\Tabs\Global_Colors::COLOR_PRIMARY,
                ],
            ]
        );
        $this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name' => 'decimal_typography',
				'selector' => '{{WRAPPER}} .hostiko-price-outer .decimal-outer .decimal',
			]
		);
        $this->add_responsive_control(
            'decimal_position',
            [
                'label' => esc_html__( 'Decimal Position', 'elementor-whmcs_product_price-control' ),
                'type' => \Elementor\Controls_Manager::CHOOSE,
                'options' => [
                    'inline-block' => [
                        'title' => esc_html__( 'Left', 'elementor-whmcs_product_price-control' ),
                        'icon' => 'eicon-h-align-left',
                    ],
                    'block' => [
                        'title' => esc_html__( 'Top', 'elementor-whmcs_product_price-control' ),
                        'icon' => 'eicon-v-align-top',
                    ],
                ],
                'default' => 'block',
                'toggle' => true,
                'selectors' => [
                    '{{WRAPPER}} .hostiko-price-outer .decimal-outer .decimal'   => 'display: {{VALUE}};',
                ],
            ]
        );
        $this->end_controls_section();
		// Decimal Controls End   

        // Duration Controls Start
		$this->start_controls_section(
            'duration_setting',
            [
                'label' => esc_html__( 'Duration', 'elementor-whmcs_product_price-control' ),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
				'condition' => [
					'show_price' => 'yes',
				],
            ]
        );
        $this->add_responsive_control(
			'duration_padding',
			[
				'label' => esc_html__( 'Padding', 'elementor-whmcs_product_price-control' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
				'selectors' => [
					'{{WRAPPER}} .hostiko-price-outer .decimal-outer .duration' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);
		$this->add_control(
            'duration_color',
            [
                'label' => esc_html__( 'Duration Color', 'elementor-whmcs_product_price-control' ),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .hostiko-price-outer .decimal-outer .duration' => 'color: {{VALUE}}',
                ],
                'global' => [
                    'default' => \Elementor\Core\Kits\Documents\Tabs\Global_Colors::COLOR_TEXT,
                ],
            ]
        );
        $this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name' => 'duration_typography',
				'selector' => '{{WRAPPER}} .hostiko-price-outer .decimal-outer .duration',
			]
		);
        $this->end_controls_section();
		// Duration Controls End

	}


	/**
	 * Render whmcs whmcs_product_price widget output on the frontend.
	 *
	 * Written in PHP and used to generate the final HTML.
	 *
	 * @since 1.0.0
	 * @access protected
	 */
	protected function render() {
		$settings = $this->get_settings_for_display();
        if ( 'yes' === $settings['show_price'] ) {
			?>
			<div class="hostiko-price-outer hostiko-whmcs-price-outer">
				<span class="currency"></span>
				<span class="price"></span>
				<div class="decimal-outer">
					<span class="decimal"></span>
					<span class="duration"></span>
				</div>
			</div>
			<?php
		}

        $option_value = json_decode (get_option('whmcs_products_data'));
		$all_whmcs_product_price= $option_value-> products -> product;
        
        
        //Get Product Name
		$dynamic_options = [];
		foreach ($all_whmcs_product_price as $item) {
			$dynamic_options[esc_attr($item-> pid)] = esc_html($item-> name);
		}

		// Retrieve the existing control and update its options.
		$control['options'] = $dynamic_options;
		$this->update_control('selected_value_name', $control);


        //get Product Currency
		$dynamic_options_pricing = [];
        $all_currencies = [];
		foreach ($all_whmcs_product_price as $item) {
            foreach($item->pricing as $currency => $pricing){
                $all_currencies[]= $currency;
            }
		}
        $all_currencies = array_unique($all_currencies);
        foreach($all_currencies as $currency_item){
            $dynamic_options_pricing[esc_attr($currency_item)] = esc_html($currency_item);
        }
      
		// Retrieve the existing control and update its options.
		$control['options'] = $dynamic_options_pricing;
		$this->update_control('selected_value_price', $control);

        $pid = $settings['selected_value_name'];
        $currency = $settings['selected_value_price'];
        echo '<select class="hostiko-select-field">';
        foreach ($all_whmcs_product_price as $item) {
            if ($item->pid == $pid && isset($item->pricing->$currency)) {
                $pricing = $item->pricing->$currency;
				$product_url = $item->product_url; 
                echo $this->getPricingDropDown($pricing,$product_url);
                ?>
				
                <?php
            }
        }
        echo '</select>';
	
	}

    private function getPricingDropDown($pricing,$product_url){
        $option = "";
        $prefix = "";
        $suffix = "";
        $cycles= ['monthly', 'quarterly', 'semiannually', 'annually', 'biennially', 'triennially'];
        foreach($pricing as $biling_cycle => $price){
            if($biling_cycle =='prefix' && !empty($price)){
                $prefix= $price;
            }elseif($biling_cycle =='suffix' && !empty($price)){
                $suffix= $price;
            }
             if((int) $price >= 0 && in_array($biling_cycle , $cycles)){
                $option .= '<option data-product="'.$product_url.'" value="'.$biling_cycle.'" data-prefix="'.$prefix.'" data-postfix="'.$suffix.'" data-price="'.$price.'" data-cycle="'.$biling_cycle.'">'. $biling_cycle.''.$prefix .$price. ''. $suffix.'</option>';
             }
        }
        return $option;
    }

}