<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

/**
 * Elementor whmcs_price_plan_01 Widget.
 *
 * Elementor widget that uses the whmcs_price_plan_01 control.
 *
 * @since 1.0.0
 */
class Elementor_Whmcs_Price_Plan_01_Widget extends \Elementor\Widget_Base {

	/**
	 * Get widget name.
	 *
	 * Retrieve whmcs whmcs_price_plan_01 widget name.
	 *
	 * @since 1.0.0
	 * @access public
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'whmcs_price_plan_01';
	}

	/**
	 * Get widget title.
	 *
	 * Retrieve whmcs whmcs_price_plan_01 widget title.
	 *
	 * @since 1.0.0
	 * @access public
	 * @return string Widget title.
	 */
	public function get_title() {
		return esc_html__( 'WHMCS Price Plan 01', 'elementor-whmcs_price_plan_01-control' );
	}

	/**
	 * Get widget icon.
	 *
	 * Retrieve whmcs whmcs_price_plan_01_widget icon.
	 *
	 * @since 1.0.0
	 * @access public
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'eicon-price-table';
	}

	/**
	 * Register whmcs whmcs_price_plan_01 widget controls.
	 *
	 * Add input fields to allow the user to customize the widget settings.
	 *
	 * @since 1.0.0
	 * @access protected
	 */
	protected function register_controls() {

		$this->start_controls_section(
			'content_section',
			[
				'label' => esc_html__( 'Content', 'elementor-whmcs_price_plan_01-control' ),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);
		$this->add_control(
            'selected_group_ids',
            [
                'label' => 'Select Group Name',
                'type' => \Elementor\Controls_Manager::SELECT,
                'options' => [
                    '' => 'Select an option', // Placeholder
                ],
            ]
        );

		$this->add_control(
            'warning_text',
            [
                'type' => 'raw_html',
                'label' => ' Please Sync your WHMCS from dashboard <strong>Hostiko > WHMCS </strong> and then Select WHMCS Product Group',
                'content' => '<input type="text" value="This is a warning message" disabled>',
            ]
        );

        $this->add_control(
            'selected_value_price',
            [
                'label' => 'Select Product Currency',
                'type' => \Elementor\Controls_Manager::SELECT,
                'options' => [
                    '' => 'Select an option', // Placeholder
                ],
            ]
        );
        $this->add_control(
			'show_price',
			[
				'label' => esc_html__( 'Show Price', 'elementor-whmcs_price_plan_01-control' ),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'label_on' => esc_html__( 'Show', 'elementor-whmcs_price_plan_01-control' ),
				'label_off' => esc_html__( 'Hide', 'elementor-whmcs_price_plan_01-control' ),
				'return_value' => 'yes',
				'default' => 'yes',
			]
		);
        $this->add_control(
			'order_btn_icon',
			[
				'label' => esc_html__( 'Button Icon', 'elementor' ),
				'type' => \Elementor\Controls_Manager::ICONS,
				'fa4compatibility' => 'Button Icon',
				'default' => [
					'value' => 'fas fa-chevron-right',
					'library' => 'fa-solid',
				],
			]
		);
		$this->add_control(
			'order_btn_text',
			[
				'label' => esc_html__( 'Button Text', 'elementor-merraki-button-control' ),
				'label_block' => true,
				'placeholder' => __( 'Order Now', 'elementor-merraki-button-control' ),
				'default' => __( 'Order Now' , 'elementor-merraki-button-control' ),
				'type' => 'text',
			]
		);
		
		
		
        $this->end_controls_section();

		/////////////////////////////////////////////////////////////////////////////////////////////////////
        $this->start_controls_section(
            'box_controls',
            [
                'label' => esc_html__( 'Box Styles', 'elementor-whmcs_price_plan_01-control' ),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_responsive_control(
            'custom_box_width',
            [
                'label' => __('Box Width', 'elementor-whmcs_price_plan_01-control'),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'default' => [
                    'size' => 31.5,
                    'unit' => '%', // Default unit (pixels)
                ],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 500,
                    ],
                    'em' => [
                        'min' => 0,
                        'max' => 50,
                    ],
                    '%' => [
                        'min' => 0,
                        'max' => 100,
                    ],
                ],
                'size_units' => ['px', 'em', '%'], 
                'selectors' => [
                    '{{WRAPPER}} .whmcs-cards .whmcs_price_plan' => 'width: {{SIZE}}{{UNIT}};', 
                ],
            ]
        );
        
        $this->add_responsive_control(
            'custom_box_height',
            [
                'label' => __('Box Height', 'elementor-whmcs_price_plan_01-control'),
                'type' => \Elementor\Controls_Manager::SLIDER,
                // 'default' => [
                //     'size' => 490,
                //     'unit' => 'px', // Default unit (pixels)
                // ],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 1000,
                    ],
                    'em' => [
                        'min' => 0,
                        'max' => 50,
                    ],
                    
                ],
                'size_units' => ['px', 'em'], 
                'selectors' => [
                    '{{WRAPPER}} .whmcs-cards .whmcs_price_plan' => 'height: {{SIZE}}{{UNIT}};', 
                ],
            ]
        );
        
        
        $this->add_responsive_control(
            'whmcs_product_box_padding',
            [
                'label' => __( 'Padding', 'elementor-whmcs_price_plan_01-control' ),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%', 'em' ],
                'default' => [
                    'top' => '10',     
                    'right' => '10',       
                    'bottom' => '10', 
                    'left' => '10',      
                ],
                'selectors' => [
                    '{{WRAPPER}} .whmcs-cards .whmcs_price_plan' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        ); 
        $this->add_responsive_control(
            'whmcs_product_box_margin',
            [
                'label' => __( 'Space Between', 'elementor-whmcs_price_plan_01-control' ),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%', 'em' ],
                'default' => [
                    'top' => '10',     
                    'right' => '10',       
                    'bottom' => '10', 
                    'left' => '10',      
                ],
                'selectors' => [
                    '{{WRAPPER}} .whmcs-cards .whmcs_price_plan' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        ); 

        $this->add_group_control(
            \Elementor\Group_Control_Border::get_type(),
            [
                'name' => 'whmcs_price_plan_01_border',
                'label' => __( 'Border', 'elementor-whmcs_price_plan_01-control' ),
                'fields_options' => [
                    'border' => [
                        'default' => 'solid',
                    ],
                    'width' => [
                        'default' => [
                            'top' => '1',
                            'right' => '1',
                            'bottom' => '1',
                            'left' => '1',
                            'isLinked' => false,
                        ],
                    ],
                    'color' => [
                        'default' => \Elementor\Core\Kits\Documents\Tabs\Global_Colors::COLOR_ACCENT,
                    ],
                ],
                'selector' => '{{WRAPPER}} .whmcs_price_plan',
            ]
        );
        $this->add_responsive_control(
			'whmcs_price_plan_01_border_radius',
			[
				'label' => __( 'Border Radius', 'elementor-whmcs_price_plan_01-control' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'selectors' => [
					'{{WRAPPER}} .whmcs_price_plan' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    
				],
                
			]
		);

        $this->add_group_control(
            \Elementor\Group_Control_Background::get_type(),
            [
                'name' => 'whmcs_price_plan_01_background',
				'label' => __( 'Background', 'elementor-whmcs_price_plan_01-control' ),
                'types' => [ 'classic', 'gradient', 'video' ],
                'selector' => '{{WRAPPER}} .whmcs_price_plan',
            ]
        );  

        $this->add_group_control(
			\Elementor\Group_Control_Box_Shadow::get_type(),
			[
				'name' => 'continer_box_shadow',
				'selector' => '{{WRAPPER}} .whmcs_price_plan',
			]
		);

        $this->end_controls_section();

		/////////////////////////////////////////////////////////////////////////////////////////////////////

        $this->start_controls_section(
            'name_controls',
            [
                'label' => esc_html__( 'Name Styles', 'elementor-whmcs_price_plan_01-control' ),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name' => 'whmcs_price_plan_01_name_typography',
				'label' => __( 'Typography', 'elementor-whmcs_price_plan_01-control' ),
				'selector' => '{{WRAPPER}} .whmcs_price_plan .whmcs_product_title',
				'global' => [
					'default' => \Elementor\Core\Kits\Documents\Tabs\Global_Typography::TYPOGRAPHY_PRIMARY,
				],
			]
		);
        $this->add_control(
            'whmcs_price_plan_01_name_color',
            [
                'label' => esc_html__('Color', 'elementor-whmcs_price_plan_01-control'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .whmcs_price_plan .whmcs_product_title' => 'color: {{VALUE}}',
                ],
				'global' => [
					'default' => \Elementor\Core\Kits\Documents\Tabs\Global_Colors::COLOR_PRIMARY,
				],
            ]
        );
        
        $this->add_responsive_control(
			'whmcs_price_plan_01_name_padding',
			[
				'label' => __( 'Padding', 'elementor-whmcs_price_plan_01-control' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
                'default' => [
                    'top' => '10',     
                    'right' => '10',       
                    'bottom' => '10', 
                    'left' => '10',      
                ],
				'selectors' => [
					'{{WRAPPER}} .whmcs_price_plan .whmcs_product_title' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
                
			]
		); 
		$this->add_responsive_control(
			'whmcs_price_plan_01_name_margin',
			[
				'label' => __( 'Margin', 'elementor-whmcs_price_plan_01-control' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
                'default' => [
                    'top' => '10',     
                    'right' => '10',       
                    'bottom' => '10', 
                    'left' => '10',      
                ],
				'selectors' => [
					'{{WRAPPER}} .whmcs_price_plan .whmcs_product_title' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);
		$this->add_control(
            'whmcs_price_plan_01_name_alignment',
            [
                'label' => esc_html__('Alignment', 'elementor-whmcs_price_plan_01-control'),
                'type' => \Elementor\Controls_Manager::CHOOSE,
                'options' => [
                    'left' => [
                        'title' => esc_html__('Left', 'elementor-whmcs_price_plan_01-control'),
                        'icon' => 'eicon-text-align-left',
                    ],
                    'center' => [
                        'title' => esc_html__('Center', 'elementor-whmcs_price_plan_01-control'),
                        'icon' => 'eicon-text-align-center',
                    ],
                    'right' => [
                        'title' => esc_html__('Right', 'elementor-whmcs_price_plan_01-control'),
                        'icon' => 'eicon-text-align-right',
                    ],
                ],
                'default' => 'left',
                'selectors' => [
                    '{{WRAPPER}} .whmcs_price_plan .whmcs_product_title' => 'text-align: {{VALUE}};',
                ],
            ]
        );
		
        $this->add_group_control(
            \Elementor\Group_Control_Background::get_type(),
            [
                'name' => 'whmcs_price_plan_01_name_background',
				'label' => __( 'Background', 'elementor-whmcs_price_plan_01-control' ),
                'types' => [ 'classic', 'gradient', 'video' ],
                'selector' => '{{WRAPPER}} .whmcs_price_plan .whmcs_product_title',
            ]
        );  
		$this->add_group_control(
            \Elementor\Group_Control_Border::get_type(),
            [
                'name' => 'whmcs_price_plan_01_name_border',
                'label' => __( 'Border', 'elementor-whmcs_price_plan_01-control' ),
                'selector' => '{{WRAPPER}} .whmcs_price_plan .whmcs_product_title',
            ]
        );
        $this->add_responsive_control(
			'whmcs_price_plan_01_name_border_radius',
			[
				'label' => __( 'Border Radius', 'elementor-whmcs_price_plan_01-control' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'selectors' => [
					'{{WRAPPER}} .whmcs_price_plan .whmcs_product_title' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);
        $this->end_controls_section();
        /////////////////////////////////////////////////////////////////////////////////////////////////////
       
        $this->start_controls_section(
			'description_controls',
			[
				'label' => esc_html__( 'Description Styles', 'elementor-whmcs_price_plan_01-control' ),
				'tab' => \Elementor\Controls_Manager::TAB_STYLE,
			]
       	 );
            $this->add_group_control(
                \Elementor\Group_Control_Typography::get_type(),
                [
                    'name' => 'whmcs_product_name_typography',
                    'label' => __( 'Typography', 'elementor-whmcs_price_plan_01-control' ),
                    'selector' => '{{WRAPPER}} whmcs_price_plan .whmcs_product_desc, .whmcs_price_plan .whmcs_product_desc ul li',
                    'global' => [
                        'default' => \Elementor\Core\Kits\Documents\Tabs\Global_Typography::TYPOGRAPHY_TEXT,
                    ],
                ]
            );
            $this->add_control(
                'whmcs_product_description_color',
                [
                    'label' => esc_html__('Color', 'elementor-whmcs_price_plan_01-control'),
                    'type' => \Elementor\Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .whmcs_price_plan .whmcs_product_desc, .whmcs_price_plan .whmcs_product_desc ul li' => 'color: {{VALUE}}',
                    ],
                    'global' => [
                        'default' => \Elementor\Core\Kits\Documents\Tabs\Global_Colors::COLOR_TEXT,
                    ],
                ]
            );
    
            $this->add_control(
                'list_description_style',
                [
                    'label' => 'Select List Style',
                    'type' => \Elementor\Controls_Manager::SELECT,
                    'options' => [
                        '' => 'Default', // Placeholder
                        'circle' => 'circle', // Placeholder
                        'disc' => 'disc', // Placeholder
                        'square' => 'square', // Placeholder
                        'decimal' => 'decimal', // Placeholder
                        'none' => 'none', // Placeholder
                    ],
                    'selectors' => [
                        '{{WRAPPER}} .whmcs_price_plan .whmcs_product_desc ul li' => 'list-style-type: {{VALUE}};',
                    ],
                ]
            );
            
            $this->add_responsive_control(
                'whmcs_product_description_padding',
                [
                    'label' => __( 'Padding', 'elementor-whmcs_price_plan_01-control' ),
                    'type' => \Elementor\Controls_Manager::DIMENSIONS,
                    'size_units' => [ 'px', '%', 'em' ],
                    'default' => [
                        'top' => '8',     
                        'right' => '10',       
                        'bottom' => '8', 
                        'left' => '2',      
                    ],
                    'selectors' => [
                        '{{WRAPPER}} .whmcs_price_plan .whmcs_product_desc, .whmcs_price_plan .whmcs_product_desc ul li' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    ],
                ]
            ); 
            $this->add_responsive_control(
                'whmcs_product_description_margin',
                [
                    'label' => __( 'Margin', 'elementor-whmcs_price_plan_01-control' ),
                    'type' => \Elementor\Controls_Manager::DIMENSIONS,
                    'size_units' => [ 'px', '%', 'em' ],
                    'default' => [
                        'top' => '0',     
                        'right' => '0',       
                        'bottom' => '0', 
                        'left' => '0',      
                    ],
                    'selectors' => [
                        '{{WRAPPER}} .whmcs_price_plan .whmcs_product_desc, .whmcs_price_plan .whmcs_product_desc ul li' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    ],
                ]
            );
            $this->add_control(
                'whmcs_product_description_alignment',
                [
                    'label' => esc_html__('Alignment', 'elementor-whmcs_price_plan_01-control'),
                    'type' => \Elementor\Controls_Manager::CHOOSE,
                    'options' => [
                        'left' => [
                            'title' => esc_html__('Left', 'elementor-whmcs_price_plan_01-control'),
                            'icon' => 'eicon-text-align-left',
                        ],
                        'center' => [
                            'title' => esc_html__('Center', 'elementor-whmcs_price_plan_01-control'),
                            'icon' => 'eicon-text-align-center',
                        ],
                        'right' => [
                            'title' => esc_html__('Right', 'elementor-whmcs_price_plan_01-control'),
                            'icon' => 'eicon-text-align-right',
                        ],
                    ],
                    'default' => 'left',
                    'selectors' => [
                        '{{WRAPPER}} .whmcs_price_plan .whmcs_product_desc, .whmcs_price_plan .whmcs_product_desc ul li' => 'text-align: {{VALUE}};',
                    ],
                ]
            );
            
            $this->add_group_control(
                \Elementor\Group_Control_Background::get_type(),
                [
                    'name' => 'whmcs_product_description_background',
                    'label' => __( 'Background', 'elementor-whmcs_price_plan_01-control' ),
                    'types' => [ 'classic', 'gradient', 'video' ],
                    'selector' => '{{WRAPPER}} .whmcs_price_plan .whmcs_product_desc ul li',
                ]
            );  
            $this->add_group_control(
                \Elementor\Group_Control_Border::get_type(),
                [
                    'name' => 'whmcs_product_description_border',
                    'label' => __( 'Border', 'elementor-whmcs_price_plan_01-control' ),
                    'selector' => '{{WRAPPER}} .whmcs_price_plan .whmcs_product_desc ul li',
                ]
            );
            $this->add_responsive_control(
                'whmcs_product_description_border_radius',
                [
                    'label' => __( 'Border Radius', 'elementor-whmcs_price_plan_01-control' ),
                    'type' => \Elementor\Controls_Manager::DIMENSIONS,
                    'size_units' => [ 'px', '%', 'em' ],
                    'selectors' => [
                        '{{WRAPPER}} .whmcs_price_plan .whmcs_product_desc ul li' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    ],
                ]
            );

        $this->end_controls_section();

        /////////////////////////////////////////////////////////////////////////////////////////////////////

        // Select Box Widget Controls Start
        $this->start_controls_section(
            'select_box_section',
            [
                'label' => esc_html__( 'Select Box', 'elementor-whmcs_price_plan_01-control' ),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );
		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name' => 'whmcs_product_price_typography',
				'label' => __( 'Typography', 'elementor-whmcs_price_plan_01-control' ),
				'selector' => '{{WRAPPER}} .hostiko-select-field span',
				'global' => [
					'default' => \Elementor\Core\Kits\Documents\Tabs\Global_Typography::TYPOGRAPHY_PRIMARY,
				],
			]
		);
		// Style Tabs Normal Start
		$this->start_controls_tabs(
			'style_tabs_plan01'
		);

		$this->start_controls_tab(
			'style_normal_tab_plan01',
			[
				'label' => esc_html__( 'Normal', 'elementor-whmcs_price_plan_01-control' ),
			]
		);
		$this->add_control(
            'whmcs_product_price_normal_color',
            [
                'label' => esc_html__('Dropdown List Color', 'elementor-whmcs_price_plan_01-control'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .hostiko-select-field.nice-select .option' => 'color: {{VALUE}}',
                ],
				'global' => [
					'default' => \Elementor\Core\Kits\Documents\Tabs\Global_Colors::COLOR_PRIMARY,
				],
            ]
        );
		$this->end_controls_tab();
		// Style Tabs Normal End
		// Style Tabs Hover Start
		$this->start_controls_tab(
			'style_hover_tab_plan01',
			[
				'label' => esc_html__( 'Hover', 'elementor-whmcs_price_plan_01-control' ),
			]
		);
		$this->add_control(
            'whmcs_product_price_hover_color',
            [
                'label' => esc_html__('Dropdown List Color', 'elementor-whmcs_price_plan_01-control'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .hostiko-select-field.nice-select .option:hover' => 'color: {{VALUE}}',
                ],
				'global' => [
					'default' => \Elementor\Core\Kits\Documents\Tabs\Global_Colors::COLOR_PRIMARY,
				],
            ]
        );
		$this->add_control(
            'whmcs_product_price_hover_background_color',
            [
                'label' => esc_html__('Dropdown List Background', 'elementor-whmcs_price_plan_01-control'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .hostiko-select-field.nice-select .option:hover' => 'background: {{VALUE}}',
                ],
            ]
        );
		$this->add_control(
            'whmcs_product_price_border_hover_color',
            [
                'label' => esc_html__('Dropdown Border Bar Color', 'elementor-whmcs_price_plan_01-control'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}}  .hostiko-select-field.nice-select .option:hover::before' => 'background: {{VALUE}}',
                ],
            ]
        );
		$this->end_controls_tab();
		// Style Tabs Hover End
		// Style Tabs Active Start
		$this->start_controls_tab(
			'style_active_tab',
			[
				'label' => esc_html__( 'Active', 'elementor-whmcs_price_plan_01-control' ),
			]
		);
		$this->add_control(
            'whmcs_product_price_active_color',
            [
                'label' => esc_html__('Dropdown List Color', 'elementor-whmcs_price_plan_01-control'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .hostiko-select-field.nice-select .option.selected.focus' => 'color: {{VALUE}}',
                ],
				'global' => [
					'default' => \Elementor\Core\Kits\Documents\Tabs\Global_Colors::COLOR_PRIMARY,
				],
            ]
        );
		$this->add_control(
            'whmcs_product_price_active_background_color',
            [
                'label' => esc_html__('Dropdown List Background', 'elementor-whmcs_price_plan_01-control'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .hostiko-select-field.nice-select .option.selected.focus' => 'background: {{VALUE}}',
                ],
            ]
        );
		$this->add_control(
            'whmcs_product_price_border_active_color',
            [
                'label' => esc_html__('Dropdown Border Bar Color', 'elementor-whmcs_price_plan_01-control'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .hostiko-select-field.nice-select .option.selected::before' => 'background: {{VALUE}}',
                ],
            ]
        );
		$this->end_controls_tabs();
		// Style Tabs Active End
		$this->add_control(
            'whmcs_product_price_background_color',
            [
                'label' => esc_html__('Dropdown Item Background', 'elementor-whmcs_price_plan_01-control'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .hostiko-select-field.nice-select .list' => 'background: {{VALUE}}',
                ],
            ]
        );
		$this->add_responsive_control(
			'whmcs_product_select_color',
			[
				'label' => esc_html__('Dropdown Text Color', 'elementor-whmcs_price_plan_01-control'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .hostiko-select-field .current' => 'color: {{VALUE}}',
                ],
			]
		); 
        $this->add_responsive_control(
			'whmcs_product_select_padding',
			[
				'label' => __( 'Dropdown Padding', 'elementor-whmcs_price_plan_01-control' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'selectors' => [
					'{{WRAPPER}} .hostiko-select-field' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		); 
		$this->add_responsive_control(
			'whmcs_product_dropdown_padding',
			[
				'label' => __( 'Dropdown List Padding', 'elementor-whmcs_price_plan_01-control' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'selectors' => [
					'{{WRAPPER}} .hostiko-select-field.nice-select .option' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		); 
        $this->add_responsive_control(
			'whmcs_product_dropdown_margin',
			[
				'label' => __( 'Dropdown Margin', 'elementor-whmcs_price_plan_01-control' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'selectors' => [
					'{{WRAPPER}} .hostiko-select-field.nice-select' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		); 
		$this->add_control(
            'whmcs_product_price_alignment',
            [
                'label' => esc_html__('Alignment', 'elementor-whmcs_price_plan_01-control'),
                'type' => \Elementor\Controls_Manager::CHOOSE,
                'options' => [
                    'left' => [
                        'title' => esc_html__('Left', 'elementor-whmcs_price_plan_01-control'),
                        'icon' => 'eicon-text-align-left',
                    ],
                    'center' => [
                        'title' => esc_html__('Center', 'elementor-whmcs_price_plan_01-control'),
                        'icon' => 'eicon-text-align-center',
                    ],
                    'right' => [
                        'title' => esc_html__('Right', 'elementor-whmcs_price_plan_01-control'),
                        'icon' => 'eicon-text-align-right',
                    ],
                ],
                'default' => 'left',
                'selectors' => [
                    '{{WRAPPER}} .hostiko-select-field' => 'text-align: {{VALUE}};',
                ],
            ]
        );
		$this->end_controls_section();
		// Select Box Widget Controls End
		// Price Widget Controls Start
		$this->start_controls_section(
            'price_widget_setting',
            [
                'label' => esc_html__( 'Price Widget', 'elementor-whmcs_price_plan_01-control' ),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
				'condition' => [
					'show_price' => 'yes',
				],
            ]
        );
		$this->add_responsive_control(
			'price_widget_padding',
			[
				'label' => esc_html__( 'Padding', 'elementor-whmcs_price_plan_01-control' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
				'selectors' => [
					'{{WRAPPER}} .hostiko-price-outer' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
				'condition' => [
					'show_price' => 'yes',
				],
			]
		);
        $this->add_responsive_control(
            'price_widget_align',
            [
                'label' => esc_html__( 'Price Widget Alignment', 'elementor-whmcs_price_plan_01-control' ),
                'type' => \Elementor\Controls_Manager::CHOOSE,
                'options' => [
                    'left' => [
                        'title' => esc_html__( 'Left', 'elementor-whmcs_price_plan_01-control' ),
                        'icon' => 'eicon-text-align-left',
                    ],
                    'center' => [
                        'title' => esc_html__( 'Center', 'elementor-whmcs_price_plan_01-control' ),
                        'icon' => 'eicon-text-align-center',
                    ],
                    'right' => [
                        'title' => esc_html__( 'Right', 'elementor-whmcs_price_plan_01-control' ),
                        'icon' => 'eicon-text-align-right',
                    ],
                ],
                'default' => 'left',
                'toggle' => true,
                'selectors' => [
                    '{{WRAPPER}} .hostiko-price-outer'   => 'text-align: {{VALUE}};',
                ],
				'condition' => [
					'show_price' => 'yes',
				],
            ]
        );
        $this->end_controls_section();
		// Price Widget Controls End
		// Currency Controls Start
		$this->start_controls_section(
            'currency_setting',
            [
                'label' => esc_html__( 'Currency', 'elementor-whmcs_price_plan_01-control' ),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
				'condition' => [
					'show_price' => 'yes',
				],
            ]
        );
        $this->add_control(
			'currency_space',
			[
				'label' => esc_html__( 'Space', 'elementor-whmcs_price_plan_01-control' ),
				'type' => \Elementor\Controls_Manager::SLIDER,
				'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
				'range' => [
					'px' => [
						'min' => -100,
						'max' => 100,
						'step' => 1,
					],
					'%' => [
						'min' => 0,
						'max' => 100,
					],
				],
				'default' => [
					'unit' => 'px',
				],
				'selectors' => [
					'{{WRAPPER}} .hostiko-price-outer .currency' => 'top: {{SIZE}}{{UNIT}};',
				],
			]
		);
		$this->add_control(
            'currency_color',
            [
                'label' => esc_html__( 'Currency Color', 'elementor-whmcs_price_plan_01-control' ),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .hostiko-price-outer .currency' => 'color: {{VALUE}}',
                ],
                'global' => [
                    'default' => \Elementor\Core\Kits\Documents\Tabs\Global_Colors::COLOR_PRIMARY,
                ],
            ]
        );
        $this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name' => 'currency_typography',
				'selector' => '{{WRAPPER}} .hostiko-price-outer .currency',
			]
		);
        $this->end_controls_section();
		// Currency Controls End
		
		// Price Controls Start
        $this->start_controls_section(
            'price_setting',
            [
                'label' => esc_html__( 'Price', 'elementor-whmcs_price_plan_01-control' ),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
				'condition' => [
					'show_price' => 'yes',
				],
            ]
        );
        $this->add_responsive_control(
			'price_padding',
			[
				'label' => esc_html__( 'Padding', 'elementor-whmcs_price_plan_01-control' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
				'selectors' => [
					'{{WRAPPER}} .hostiko-price-outer .price' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);
		$this->add_control(
            'price_color',
            [
                'label' => esc_html__( 'Price Color', 'elementor-whmcs_price_plan_01-control' ),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .hostiko-price-outer .price' => 'color: {{VALUE}}',
                ],
                'global' => [
                    'default' => \Elementor\Core\Kits\Documents\Tabs\Global_Colors::COLOR_PRIMARY,
                ],
            ]
        );
        $this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name' => 'price_typography',
				'selector' => '{{WRAPPER}} .hostiko-price-outer .price',
			]
		);
        $this->end_controls_section();
		// Price Controls End

		// Decimal Controls Start
		$this->start_controls_section(
            'decimal_setting',
            [
                'label' => esc_html__( 'Decimal', 'elementor-whmcs_price_plan_01-control' ),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
				'condition' => [
					'show_price' => 'yes',
				],
            ]
        );
        $this->add_responsive_control(
			'decimal_padding',
			[
				'label' => esc_html__( 'Padding', 'elementor-whmcs_price_plan_01-control' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
				'selectors' => [
					'{{WRAPPER}} .hostiko-price-outer .decimal-outer .decimal' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);
		$this->add_control(
            'decimal_color',
            [
                'label' => esc_html__( 'Decimal Color', 'elementor-whmcs_price_plan_01-control' ),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .hostiko-price-outer .decimal-outer .decimal' => 'color: {{VALUE}}',
                ],
                'global' => [
                    'default' => \Elementor\Core\Kits\Documents\Tabs\Global_Colors::COLOR_PRIMARY,
                ],
            ]
        );
        $this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name' => 'decimal_typography',
				'selector' => '{{WRAPPER}} .hostiko-price-outer .decimal-outer .decimal',
			]
		);
        $this->add_responsive_control(
            'decimal_position',
            [
                'label' => esc_html__( 'Decimal Position', 'elementor-whmcs_price_plan_01-control' ),
                'type' => \Elementor\Controls_Manager::CHOOSE,
                'options' => [
                    'inline-block' => [
                        'title' => esc_html__( 'Left', 'elementor-whmcs_price_plan_01-control' ),
                        'icon' => 'eicon-h-align-left',
                    ],
                    'block' => [
                        'title' => esc_html__( 'Top', 'elementor-whmcs_price_plan_01-control' ),
                        'icon' => 'eicon-v-align-top',
                    ],
                ],
                'default' => 'block',
                'toggle' => true,
                'selectors' => [
                    '{{WRAPPER}} .hostiko-price-outer .decimal-outer .decimal'   => 'display: {{VALUE}};',
                ],
            ]
        );
        $this->end_controls_section();
		// Decimal Controls End   

        // Duration Controls Start
		$this->start_controls_section(
            'duration_setting',
            [
                'label' => esc_html__( 'Duration', 'elementor-whmcs_price_plan_01-control' ),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
				'condition' => [
					'show_price' => 'yes',
				],
            ]
        );
        $this->add_responsive_control(
			'duration_padding',
			[
				'label' => esc_html__( 'Padding', 'elementor-whmcs_price_plan_01-control' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
				'selectors' => [
					'{{WRAPPER}} .hostiko-price-outer .decimal-outer .duration' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);
		$this->add_control(
            'duration_color',
            [
                'label' => esc_html__( 'Duration Color', 'elementor-whmcs_price_plan_01-control' ),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .hostiko-price-outer .decimal-outer .duration' => 'color: {{VALUE}}',
                ],
                'global' => [
                    'default' => \Elementor\Core\Kits\Documents\Tabs\Global_Colors::COLOR_TEXT,
                ],
            ]
        );
        $this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name' => 'duration_typography',
				'selector' => '{{WRAPPER}} .hostiko-price-outer .decimal-outer .duration',
			]
		);
        $this->end_controls_section();
		// Duration Controls End
        /////////////////////////////////////////////////////////////////////////////////////////////////////
        $this->start_controls_section(
			'order_now_btn_controls',
			[
				'label' => esc_html__( 'Button Styles', 'elementor-whmcs_price_plan_01-control' ),
				'tab' => \Elementor\Controls_Manager::TAB_STYLE,
			]
       	 );
		
        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'name' => 'whmcs_product_plan_btn_typography',
                'label' => __( 'Typography', 'elementor-whmcs_price_plan_01-control' ),
                'selector' => '{{WRAPPER}} .whmcs_price_plan .whmcs_order_now',
                'global' => [
                    'default' => \Elementor\Core\Kits\Documents\Tabs\Global_Typography::TYPOGRAPHY_TEXT,
                ],
            ]
        );

        $this->add_responsive_control(
            'button_padding',
            [
                'label' => esc_html__( 'Button Padding', 'elementor-whmcs_price_plan_01-control' ),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
                'default' => [
                    'top' => '10',     
                    'right' => '10',       
                    'bottom' => '10', 
                    'left' => '10',      
                ],
                'selectors' => [
                    '{{WRAPPER}} .whmcs_price_plan .whmcs_order_now' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'button_margin',
            [
                'label' => esc_html__( 'Margin', 'elementor-whmcs_price_plan_01-control' ),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
                'default' => [
                    'top' => '10',     
                    'right' => '10',       
                    'bottom' => '10', 
                    'left' => '10',      
                ],
                'selectors' => [
                    '{{WRAPPER}} .whmcs_price_plan .whmcs_order_now' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
			'order_btn_alignment',
			[
			'label' => esc_html__( 'Alignment', 'elementor-merraki-button-control' ),
			'type' => \Elementor\Controls_Manager::CHOOSE,
			'options' => [
				'left' => [
					'title' => esc_html__( 'Left', 'elementor-merraki-button-control' ),
					'icon' => 'eicon-text-align-left',
				],
				'center' => [
					'title' => esc_html__( 'Center', 'elementor-merraki-button-control' ),
					'icon' => 'eicon-text-align-center',
				],
				'right' => [
					'title' => esc_html__( 'Right', 'elementor-merraki-button-control' ),
					'icon' => 'eicon-text-align-right',
				],
			],
			'default' => 'center',
			'toggle' => true,
			'selectors' => [
			'{{WRAPPER}} .whmcs_price_plan' => 'text-align: {{VALUE}};',
			],
			]
		);
        
        $this->start_controls_tabs(
			'style_tabs'
		);
        
		$this->start_controls_tab(
			'style_normal_tab',
			[
				'label' => esc_html__( 'Normal', 'elementor-whmcs_price_plan_01-control' ),
			]
		);
		$this->add_control(
            'button_text',
            [
                'label' => esc_html__( 'Button Text', 'elementor-whmcs_price_plan_01-control' ),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .whmcs_price_plan .whmcs_order_now' => 'color: {{VALUE}}',
                ],
                'global' => [
                    'default' => \Elementor\Core\Kits\Documents\Tabs\Global_Colors::COLOR_TEXT,
                ],
            ]
        );
		$this->add_control(
			'button_background_color',
			[
				'label' => esc_html__( 'Button Background', 'elementor' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'default' => '',
				'selectors' => [
					'{{WRAPPER}} .whmcs_price_plan .whmcs_order_now' => 'background-color: {{VALUE}};',
				],
                'global' => [
                    'default' => \Elementor\Core\Kits\Documents\Tabs\Global_Colors::COLOR_ACCENT,
                ],
			]
		);
		
		$this->add_responsive_control(
			'button_radius',
			[
				'label' => esc_html__( 'Button Radius', 'elementor' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
				'selectors' => [
					'{{WRAPPER}} .whmcs_price_plan .whmcs_order_now' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);
		$this->add_control(
            'icon_color',
            [
                'label' => esc_html__( 'Icon Color', 'elementor-whmcs_price_plan_01-control' ),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .whmcs_price_plan .whmcs_order_now i' => 'color: {{VALUE}}',
                ],
                'global' => [
                    'default' => \Elementor\Core\Kits\Documents\Tabs\Global_Colors::COLOR_TEXT,
                ],
            ]
        );
		$this->add_control(
			'icon_background_color',
			[
				'label' => esc_html__( 'Icon background', 'elementor' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'default' => '',
				'selectors' => [
					'{{WRAPPER}} .whmcs_price_plan .whmcs_order_now i' => 'background-color: {{VALUE}};',
				],
			]
		);
		$this->add_responsive_control(
            'icon_padding',
            [
                'label' => esc_html__( 'Icon Padding', 'elementor-whmcs_price_plan_01-control' ),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
                'default' => [
                    'top' => '10',     
                    'right' => '10',       
                    'bottom' => '10', 
                    'left' => '10',      
                ],
                'selectors' => [
                    '{{WRAPPER}} .whmcs_price_plan .whmcs_order_now i' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
		$this->add_responsive_control(
			'icon_spacing',
			[
				'label' => esc_html__( 'Icon Spacing', 'elementor' ),
				'type' => \Elementor\Controls_Manager::SLIDER,
                'default' => [
                    'left' => '10',      
                ],
				'selectors' => [
					'{{WRAPPER}} .whmcs_price_plan .whmcs_order_now i' => 'margin-left: {{SIZE}}{{UNIT}};',
				],
				'range' => [
					'em' => [
						'min' => 0,
						'max' => 5,
					],
				],
			]
		);

		$this->add_responsive_control(
			'rotate',
			[
				'label' => esc_html__( 'Icon Rotate', 'elementor' ),
				'type' => \Elementor\Controls_Manager::SLIDER,
				'size_units' => [ 'deg', 'grad', 'rad', 'turn', 'custom' ],
				'default' => [
					'unit' => 'deg',
				],
				'tablet_default' => [
					'unit' => 'deg',
				],
				'mobile_default' => [
					'unit' => 'deg',
				],
				'selectors' => [
					'{{WRAPPER}} .whmcs_price_plan .whmcs_order_now i, {{WRAPPER}} .elementor-icon svg' => 'transform: rotate({{SIZE}}{{UNIT}});',
				],
			]
		);

		$this->add_group_control(
			\Elementor\Group_Control_Border::get_type(),
			[
				'name' => 'icon_border',
				'selector' => '{{WRAPPER}} .whmcs_price_plan .whmcs_order_now i',
			]
		);

		$this->add_responsive_control(
			'icon_radius',
			[
				'label' => esc_html__( 'Icon Radius', 'elementor' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
				'selectors' => [
					'{{WRAPPER}} .whmcs_price_plan .whmcs_order_now i' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);
			
		$this->end_controls_tab();
			
		$this->start_controls_tab(
			'style_hover_tab',
			[
				'label' => esc_html__( 'Hover', 'elementor-whmcs_price_plan_01-control' ),
			]
		);
		$this->add_control(
            'button_text_hover',
            [
                'label' => esc_html__( 'Button Text', 'elementor-whmcs_price_plan_01-control' ),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .whmcs_price_plan .whmcs_order_now:hover' => 'color: {{VALUE}}',
                ],
                
            ]
        );
		$this->add_control(
			'button_background_color_hover',
			[
				'label' => esc_html__( 'Button Background', 'elementor' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'default' => '',
				'selectors' => [
					'{{WRAPPER}} .whmcs_price_plan .whmcs_order_now:hover' => 'background-color: {{VALUE}};',
				],
			]
		);
		$this->add_control(
            'icon_color_hover',
            [
                'label' => esc_html__( 'Icon Color', 'elementor-whmcs_price_plan_01-control' ),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .whmcs_price_plan .whmcs_order_now:hover i' => 'color: {{VALUE}}',
                ],
            ]
        );
		$this->add_control(
			'icon_background_color_hover',
			[
				'label' => esc_html__( 'Icon background', 'elementor' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'default' => '',
				'selectors' => [
					'{{WRAPPER}} .whmcs_price_plan .whmcs_order_now:hover i' => 'background-color: {{VALUE}};',
				],
			]
		);
		$this->end_controls_tab();
			
		$this->end_controls_tabs();
        $this->end_controls_section();
		
	}


	/**
	 * Render whmcs whmcs_price_plan_01 widget output on the frontend.
	 *
	 * Written in PHP and used to generate the final HTML.
	 *
	 * @since 1.0.0
	 * @access protected
	 */
	protected function render() {
		$settings = $this->get_settings_for_display();

        $option_value = json_decode (get_option('whmcs_products_data'));
        $groupsArr= [];
		$all_whmcs_product= $option_value-> products -> product;
        foreach($all_whmcs_product as $key => $val){
            $groupsArr[] = $val->gid;
        }
        $unique_groups = array_unique($groupsArr);
        //Displaying Data into Select Controler
        $dynamic_group_ids = [];
		foreach ($unique_groups as $item) {
			$dynamic_group_ids[esc_attr($item)] = esc_html('Group# '.$item);
		}
		// Retrieve the existing control and update its options.
		$control['options'] = $dynamic_group_ids;
		$this->update_control('selected_group_ids', $control);

        //Get Product Currency
		$dynamic_options_pricing = [];
        $all_currencies = [];
		foreach ($all_whmcs_product as $item) {
            foreach($item->pricing as $currency => $pricing){
                $all_currencies[]= $currency;
            }
		}
        $all_currencies = array_unique($all_currencies);
        foreach($all_currencies as $currency_item){
            $dynamic_options_pricing[esc_attr($currency_item)] = esc_html($currency_item);
        }

        // Retrieve the existing control and update its options.
		$control['options'] = $dynamic_options_pricing;
		$this->update_control('selected_value_price', $control);


        $html ="";
		if(isset($settings['selected_group_ids']) || !empty($settings['selected_group_ids'])){
			$group_Id = $settings['selected_group_ids'];
            $currency = $settings['selected_value_price'];
            
            $html .='<div class="whmcs-cards">';

            foreach($all_whmcs_product as $pkey => $pvalue){
                if (isset($item->pricing->$currency)) {
                    $pricing = $pvalue->pricing->$currency;
                }
                if($group_Id == $pvalue -> gid){
                    $html .= '<div class="whmcs_price_plan" data-pid="'.$pvalue -> pid.'">
                        <h3 class="whmcs_product_title">'.$pvalue -> name.'</h3>
                        <div class="whmcs_pricing_outter">';
                            if ( 'yes' === $settings['show_price'] ) {
                                $html .= '<div class="hostiko-price-outer hostiko-whmcs-price-outer">
                                    <span class="currency"></span>
                                    <span class="price"></span>
                                    <div class="decimal-outer">
                                        <span class="decimal"></span>
                                        <span class="duration"></span>
                                    </div>
                                </div>';
                            }
                            $html .= '<select class="hostiko-select-field">'.$this->getPricingDropDown($pricing).'</select>
                        </div>
                        <div class="whmcs_product_desc">'.$pvalue -> description.'</div>
                        <div class="whmcs_order_now_outter">
                            <a class="whmcs_order_now" href="'.$pvalue -> product_url.'">'.$settings['order_btn_text'].'<i class="'.$settings['order_btn_icon']['value'].'"></i></a>
                        </div>
                    </div>';
                }
            }
           
            $html .='</div>';
            echo $html;
           
		}else{
			?>
			    <p class= "whmcs_prodcts_group_ids">Please Choose any Group ID</p>
			<?php
		}
    
			
    

	}

    private function getPricingDropDown($pricing){
        $option = "";
        $prefix = "";
        $suffix = "";
        $cycles= ['monthly', 'quarterly', 'semiannually', 'annually', 'biennially', 'triennially'];
        foreach($pricing as $biling_cycle => $price){
            if($biling_cycle =='prefix' && !empty($price)){
                $prefix= $price;
            }elseif($biling_cycle =='suffix' && !empty($price)){
                $suffix= $price;
            }
             if((int) $price >= 0 && in_array($biling_cycle , $cycles)){
                $option .= '<option value="'.$biling_cycle.'" data-prefix="'.$prefix.'" data-postfix="'.$suffix.'" data-price="'.$price.'" data-cycle="'.$biling_cycle.'">'. $biling_cycle.''.$prefix .$price. ''. $suffix.'</option>';
             }
        }
        return $option;
    }


}