<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

/**
 * Elementor whmcs_domain_search Widget.
 *
 * Elementor widget that uses the whmcs_domain_search control.
 *
 * @since 1.0.0
 */
class Elementor_Whmcs_Domain_Search_Widget extends \Elementor\Widget_Base {

	/**
	 * Get widget name.
	 *
	 * Retrieve whmcs whmcs_domain_search widget name.
	 *
	 * @since 1.0.0
	 * @access public
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'whmcs_domain_search';
	}

	/**
	 * Get widget title.
	 *
	 * Retrieve whmcs whmcs_domain_search widget title.
	 *
	 * @since 1.0.0
	 * @access public
	 * @return string Widget title.
	 */
	public function get_title() {
		return esc_html__( 'WHMCS Domain Search', 'elementor-whmcs_domain_search-control' );
	}

	/**
	 * Get widget icon.
	 *
	 * Retrieve whmcs whmcs_domain_search_widget icon.
	 *
	 * @since 1.0.0
	 * @access public
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'eicon-editor-code';
	}

	/**
	 * Register whmcs whmcs_domain_search widget controls.
	 *
	 * Add input fields to allow the user to customize the widget settings.
	 *
	 * @since 1.0.0
	 * @access protected
	 */
	protected function register_controls() {

		$this->start_controls_section(
			'content_section',
			[
				'label' => esc_html__( 'Content', 'elementor-whmcs_domain_search-control' ),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);
		
		

		$this->add_control(
			'whmcs_link',
			[
				'label' => esc_html__( 'Whmcs Link', 'textdomain' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => esc_html__( 'https://linktowhmcs.com', 'textdomain' ),
				'placeholder' => esc_html__( 'Type your title here', 'textdomain' ),
			]
		);
		
		$this->add_control(
			'whmcs_tlds',
			[
				'label' => esc_html__( 'TLDs', 'textdomain' ),
				'type' => \Elementor\Controls_Manager::TEXTAREA,
				'rows' => 10,
				'default' => esc_html__( 'com,net,org', 'textdomain' ),
				'placeholder' => esc_html__( 'com,net,org', 'textdomain' ),
			]
		);
		$this->add_control(
            'warning_text',
            [
                'type' => 'raw_html',
                'label' => ' Please Sync your WHMCS from dashboard <strong>hostiko > WHMCS </strong> and add your whmcs link then search for domain',
                'content' => '<input type="text" value="This is a warning message" disabled>',
            ]
        );
		$this->add_control(
			'choose_domain_hostiko_template',
			[
				'label' => esc_html__( 'Choose Custom Hostiko Template', 'textdomain' ),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'label_on' => esc_html__( 'Yes', 'textdomain' ),
				'label_off' => esc_html__( 'No', 'textdomain' ),
				'return_value' => 'yes',
				'default' => 'no',
			]
		);
		$this->add_control(
			'layout_domain_no',
			[
				'label' => esc_html__( 'Template Number', 'textdomain' ),
				'type' => \Elementor\Controls_Manager::NUMBER,
				'min' => 1,
				'max' => 200,
				'step' => 1,
				'default' => 85,
				'condition' => [
					'choose_domain_hostiko_template' => 'yes',
				],
			]
		);
		$this->add_control(
            'warning_text_domain',
            [
                'type' => 'raw_html',
                'label' => '<strong>Note:</strong> We recommend you always use <strong>No</strong> if you are not a developer; the <strong>Yes</strong> option is for Hostiko developers only ',
                'content' => '<input type="text" value="This is a warning message" disabled>',
            ]
        );
		
        $this->end_controls_section();

		/////////////////////////////////////////////////////////////////////////////////////////////////////

        $this->start_controls_section(
            'content_style_section',
            [
                'label' => esc_html__( 'Content', 'elementor-whmcs_domain_search-control' ),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name' => 'whmcs_domain_search_name_typography',
				'label' => __( 'Typography', 'textdomain' ),
				'selector' => '{{WRAPPER}} #domain_search_outter #searchtdomain',
				'global' => [
					'default' => \Elementor\Core\Kits\Documents\Tabs\Global_Typography::TYPOGRAPHY_ACCENT,
				],
			]
		);
        $this->add_control(
            'whmcs_domain_search_name_color',
            [
                'label' => esc_html__('Color', 'textdomain'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} #domain_search_outter #searchtdomain' => 'color: {{VALUE}}',
                ],
				'global' => [
					'default' => \Elementor\Core\Kits\Documents\Tabs\Global_Colors::COLOR_ACCENT,
				],
            ]
        );
        
        $this->add_responsive_control(
			'whmcs_domain_search_name_padding',
			[
				'label' => __( 'Padding', 'textdomain' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'selectors' => [
					'{{WRAPPER}} #domain_search_outter #searchtdomain' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		); 
		$this->add_responsive_control(
			'whmcs_domain_search_name_margin',
			[
				'label' => __( 'Margin', 'textdomain' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'selectors' => [
					'{{WRAPPER}} #domain_search_outter #searchtdomain' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);
		
		$this->add_group_control(
			\Elementor\Group_Control_Border::get_type(),
			[
				'name' => 'whmcs_domain_search_name_border',
				'label' => __( 'Border', 'textdomain' ),
				'selector' => '{{WRAPPER}} #domain_search_outter #searchtdomain',
			]
		);
		
		$this->add_responsive_control(
			'whmcs_domain_search_name_border_radius',
			[
				'label' => __( 'Border Radius', 'textdomain' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'selectors' => [
					'{{WRAPPER}} #domain_search_outter #searchtdomain' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		// $this->add_responsive_control(
        //     'search_field_width',
        //     [
        //         'label' => __('Field Width', 'elementor-whmcs_price_plan_01-control'),
        //         'type' => \Elementor\Controls_Manager::SLIDER,
        //         'default' => [
        //             'size' => 60,
        //             'unit' => '%', // Default unit (pixels)
        //         ],
        //         'range' => [
        //             'px' => [
        //                 'min' => 0,
        //                 'max' => 2000,
        //             ],
        //             'em' => [
        //                 'min' => 0,
        //                 'max' => 50,
        //             ],
        //             '%' => [
        //                 'min' => 0,
        //                 'max' => 100,
        //             ],
        //         ],
        //         'size_units' => ['px', 'em', '%'], 
        //         'selectors' => [
        //             '{{WRAPPER}} #domain_search_outter #searchtdomain' => 'width: {{SIZE}}{{UNIT}};', 
        //         ],
        //     ]
        // );
       
		$this->end_controls_section();

		////////////////////////////////////////////////////////////////////////////////////////


		$this->start_controls_section(
            'btn_style_section',
            [
                'label' => esc_html__( 'Search Button', 'elementor-whmcs_domain_search-control' ),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
				]
			);
			
		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name' => 'whmcs_domain_search_btn_typography',
				'label' => __( 'Typography', 'textdomain' ),
				'selector' => '{{WRAPPER}} #domain_search_outter #search_btn',
				]
		);
		
       

        $this->add_responsive_control(
			'whmcs_domain_search_btn_padding',
			[
				'label' => __( 'Padding', 'textdomain' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'selectors' => [
					'{{WRAPPER}} #domain_search_outter #search_btn' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		); 
		$this->add_responsive_control(
			'whmcs_domain_search_btn_margin',
			[
				'label' => __( 'Margin', 'textdomain' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'selectors' => [
					'{{WRAPPER}} #domain_search_outter #search_btn' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);
		
		

		$this->start_controls_tabs(
			'search_style_normal_tabs'
		);
		
			$this->start_controls_tab(
				'style_normal_btn_normal_tab',
					[
						'label' => esc_html__( 'Normal', 'textdomain' ),
					]
				);
				$this->add_control(
					'whmcs_domain_search_btn_color',
					[
						'label' => esc_html__('Color', 'textdomain'),
						'type' => \Elementor\Controls_Manager::COLOR,
						'selectors' => [
							'{{WRAPPER}} #domain_search_outter #search_btn, #domain_search_outter #search_btn i' => 'color: {{VALUE}}',
						],
						'global' => [
							'default' => \Elementor\Core\Kits\Documents\Tabs\Global_Colors::COLOR_ACCENT,
						],
						]
					);
					
				$this->add_group_control(
					\Elementor\Group_Control_Background::get_type(),
					[
						'name' => 'whmcs_domain_search_btn_background',
						'label' => __( 'Background', 'textdomain' ),
						'types' => [ 'classic', 'gradient', 'video' ],
						'selector' => '{{WRAPPER}} #domain_search_outter #search_btn',
					]
				);  
				$this->add_group_control(
					\Elementor\Group_Control_Border::get_type(),
					[
						'name' => 'whmcs_domain_search_btn_border',
						'label' => __( 'Border', 'textdomain' ),
						'selector' => '{{WRAPPER}} #domain_search_outter #search_btn',
					]
				);
				
				$this->add_responsive_control(
					'whmcs_domain_search_btn_border_radius',
					[
						'label' => __( 'Border Radius', 'textdomain' ),
						'type' => \Elementor\Controls_Manager::DIMENSIONS,
						'size_units' => [ 'px', '%', 'em' ],
						'selectors' => [
							'{{WRAPPER}} #domain_search_outter #search_btn' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
						],
					]
				);
		
			$this->end_controls_tab();
			$this->start_controls_tab(
				'style_search_btn_hover_tab',
				[
					'label' => esc_html__( 'Hover', 'textdomain' ),
				]
			);
			$this->add_control(
				'whmcs_domain_search_btn_color_hover',
				[
					'label' => esc_html__('Color', 'textdomain'),
					'type' => \Elementor\Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} #domain_search_outter #search_btn:hover, #domain_search_outter #search_btn:hover i' => 'color: {{VALUE}}',
					],
					'global' => [
						'default' => \Elementor\Core\Kits\Documents\Tabs\Global_Colors::COLOR_ACCENT,
					],
					]
				);
				
			$this->add_group_control(
				\Elementor\Group_Control_Background::get_type(),
				[
					'name' => 'whmcs_domain_search_btn_background_hover',
					'label' => __( 'Background', 'textdomain' ),
					'types' => [ 'classic', 'gradient', 'video' ],
					'selector' => '{{WRAPPER}} #domain_search_outter #search_btn:hover',
				]
			);  
			$this->add_group_control(
				\Elementor\Group_Control_Border::get_type(),
				[
					'name' => 'whmcs_domain_search_btn_border_hover',
					'label' => __( 'Border', 'textdomain' ),
					'selector' => '{{WRAPPER}} #domain_search_outter #search_btn:hover',
				]
			);
			
			$this->add_responsive_control(
				'whmcs_domain_search_btn_border_radius_hover',
				[
					'label' => __( 'Border Radius', 'textdomain' ),
					'type' => \Elementor\Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%', 'em' ],
					'selectors' => [
						'{{WRAPPER}} #domain_search_outter #search_btn:hover' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);
			$this->end_controls_tab();
		$this->end_controls_tabs();

		$this->end_controls_section();

		////////////////////////////////////////////////////////////////////////////////////////


		$this->start_controls_section(
            'transfer_btn_style_section',
            [
                'label' => esc_html__( 'Transfer Button', 'elementor-whmcs_domain_search-control' ),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
				]
			);
			
		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name' => 'whmcs_domain_transfer_btn_typography',
				'label' => __( 'Typography', 'textdomain' ),
				'selector' => '{{WRAPPER}} #domain_search_outter #transfer_btn',
				]
		);
		
          

        $this->add_responsive_control(
			'whmcs_domain_transfer_btn_padding',
			[
				'label' => __( 'Padding', 'textdomain' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'selectors' => [
					'{{WRAPPER}} #domain_search_outter #transfer_btn' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		); 
		$this->add_responsive_control(
			'whmcs_domain_transfer_btn_margin',
			[
				'label' => __( 'Margin', 'textdomain' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'selectors' => [
					'{{WRAPPER}} #domain_search_outter #transfer_btn' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);
		
		
			$this->start_controls_tabs(
				'style_transfers_tabs'
			);
			
				$this->start_controls_tab(
					'style_transfer_btn_normal_tab',
						[
							'label' => esc_html__( 'Normal', 'textdomain' ),
						]
					);
					$this->add_control(
						'whmcs_domain_transfer_btn_color',
						[
							'label' => esc_html__('Color', 'textdomain'),
							'type' => \Elementor\Controls_Manager::COLOR,
							'selectors' => [
								'{{WRAPPER}} #domain_search_outter #transfer_btn, #domain_search_outter #transfer_btn i' => 'color: {{VALUE}}',
							],
							'global' => [
								'default' => \Elementor\Core\Kits\Documents\Tabs\Global_Colors::COLOR_ACCENT,
							],
							]
						);
						
					$this->add_group_control(
						\Elementor\Group_Control_Background::get_type(),
						[
							'name' => 'whmcs_domain_transfer_btn_background',
							'label' => __( 'Background', 'textdomain' ),
							'types' => [ 'classic', 'gradient', 'video' ],
							'selector' => '{{WRAPPER}} #domain_search_outter #transfer_btn',
						]
					);
					$this->add_group_control(
						\Elementor\Group_Control_Border::get_type(),
						[
							'name' => 'whmcs_domain_transfer_btn_border',
							'label' => __( 'Border', 'textdomain' ),
							'selector' => '{{WRAPPER}} #domain_search_outter #transfer_btn',
						]
					);
					$this->add_responsive_control(
						'whmcs_domain_transfer_btn_border_radius',
						[
							'label' => __( 'Border Radius', 'textdomain' ),
							'type' => \Elementor\Controls_Manager::DIMENSIONS,
							'size_units' => [ 'px', '%', 'em' ],
							'selectors' => [
								'{{WRAPPER}} #domain_search_outter #transfer_btn' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
							],
						]
					);
			
				$this->end_controls_tab();
				$this->start_controls_tab(
					'style_transfer_btn_hover_tab',
					[
						'label' => esc_html__( 'Hover', 'textdomain' ),
					]
				);
				$this->add_control(
					'whmcs_domain_transfer_btn_color_hover',
					[
						'label' => esc_html__('Color', 'textdomain'),
						'type' => \Elementor\Controls_Manager::COLOR,
						'selectors' => [
							'{{WRAPPER}} #domain_search_outter #transfer_btn:hover, #domain_search_outter #transfer_btn:hover i' => 'color: {{VALUE}}',
						],
						'global' => [
							'default' => \Elementor\Core\Kits\Documents\Tabs\Global_Colors::COLOR_ACCENT,
						],
						]
					);
					
				$this->add_group_control(
					\Elementor\Group_Control_Background::get_type(),
					[
						'name' => 'whmcs_domain_transfer_btn_background_hover',
						'label' => __( 'Background', 'textdomain' ),
						'types' => [ 'classic', 'gradient', 'video' ],
						'selector' => '{{WRAPPER}} #domain_search_outter #transfer_btn:hover',
					]
				);
				$this->add_group_control(
					\Elementor\Group_Control_Border::get_type(),
					[
						'name' => 'whmcs_domain_transfer_btn_border_hover',
						'label' => __( 'Border', 'textdomain' ),
						'selector' => '{{WRAPPER}} #domain_search_outter #transfer_btn:hover',
					]
				);
				$this->add_responsive_control(
					'whmcs_domain_transfer_btn_border_radius_hover',
					[
						'label' => __( 'Border Radius', 'textdomain' ),
						'type' => \Elementor\Controls_Manager::DIMENSIONS,
						'size_units' => [ 'px', '%', 'em' ],
						'selectors' => [
							'{{WRAPPER}} #domain_search_outter #transfer_btn:hover' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
						],
					]
				);
				$this->end_controls_tab();
			$this->end_controls_tabs();
		$this->end_controls_section();

	}


	/**
	 * Render whmcs whmcs_domain_search widget output on the frontend.
	 *
	 * Written in PHP and used to generate the final HTML.
	 *
	 * @since 1.0.0
	 * @access protected
	 */
	protected function render() {
		$settings = $this->get_settings_for_display();
		
        ?>
        <div id="domain_search_outter">
            <input type="text" id="searchtdomain" name="domainsearch" placeholder="eg. example.com">
			<Button id="search_btn" class="hostiko_domain_search_btn"><i class="fas fa-search"></i>Search</Button>
            <Button id="transfer_btn" class="hostiko_domain_transfer_btn"><i class="fas fa-random"></i>Transfer</Button>
            <p id="domain_whois_result"></p>
			<div id="domainCartOption">
				<ul></ul>
			</div>

        </div>
		<script>
			var $Whmcs_Link = '<?php echo $settings['whmcs_link'] ?>';
			var $whmcs_tlds = '<?php echo $settings['whmcs_tlds'] ?>';
			var $data_custom ='<?php echo isset($settings['choose_domain_hostiko_template']) ? $settings['choose_domain_hostiko_template'] : 'no'; ?>';
			var $data_layout='<?php echo isset($settings['layout_domain_no']) ? $settings['layout_domain_no'] : ''; ?>';
		</script>
		<?php

	}
	
}

