<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

/**
 * Elementor hostiko-dedicated-server-Widget.
 *
 * Elementor widget that uses thehostiko-dedicated-server control.
 *
 * @since 1.0.0
 */
class Elementor_Hostiko_Dedicated_Server_Widget extends \Elementor\Widget_Base {

	/**
	 * Get widget name.
	 *
	 * Retrieve hostiko-dedicated-server widget name.
	 *
	 * @since 1.0.0
	 * @access public
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'hostiko-dedicated';
	}

	/**
	 * Get widget title.
	 *
	 * Retrieve hostiko-dedicated-server widget title.
	 *
	 * @since 1.0.0
	 * @access public
	 * @return string Widget title.
	 */
	public function get_title() {
		return esc_html__( 'Hostiko Dedicated Plans Table', 'elementor-hostiko-dedicated-server-control' );
	}

	/**
	 * Get widget icon.
	 *
	 * Retrieve hostiko-dedicated-server widget icon.
	 *
	 * @since 1.0.0
	 * @access public
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'eicon-carousel-loop';
	}

	/**
	 * Register hostiko-dedicated-server widget controls.
	 *
	 * Add input fields to allow the user to customize the widget settings.
	 *
	 * @since 1.0.0
	 * @access protected
	 */
	protected function register_controls() {

		$this->start_controls_section(
			'content_section',
			[
				'label' => esc_html__( 'Content', 'elementor-hostiko-dedicated-server-control' ),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);
        $this->add_control(
			'hostiko_cpu_heading', [
				'label' => __( 'CPU Title', 'elementor-hostiko-tld-table-control' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => __( 'CPU' , 'elementor-hostiko-tld-table-control' ),
				'label_block' => true,
			]
		);
       
        $this->add_control(
			'hostiko_speed_heading', [
				'label' => __( 'Speed Title', 'elementor-hostiko-tld-table-control' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => __( 'CPU Speed' , 'elementor-hostiko-tld-table-control' ),
				'label_block' => true,
			]
		);
        $this->add_control(
			'hostiko_memory_heading', [
				'label' => __( 'Memory Title', 'elementor-hostiko-tld-table-control' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => __( 'Memory' , 'elementor-hostiko-tld-table-control' ),
				'label_block' => true,
			]
		);
        $this->add_control(
			'hostiko_storage_heading', [
				'label' => __( 'Storage Title', 'elementor-hostiko-tld-table-control' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => __( 'Storage' , 'elementor-hostiko-tld-table-control' ),
				'label_block' => true,
			]
		);
        $this->add_control(
			'hostiko_bandwidth_heading', [
				'label' => __( 'Bandwidth Title', 'elementor-hostiko-tld-table-control' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => __( 'Bandwidth' , 'elementor-hostiko-tld-table-control' ),
				'label_block' => true,
			]
		);
        $this->add_control(
			'hostiko_pricing_heading', [
				'label' => __( 'Pricing Title', 'elementor-hostiko-tld-table-control' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => __( 'Pricing' , 'elementor-hostiko-tld-table-control' ),
				'label_block' => true,
			]
		);
        $this->add_control(
			'hostiko_button_heading', [
				'label' => __( 'Button Title', 'elementor-hostiko-tld-table-control' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => __( '' , 'elementor-hostiko-tld-table-control' ),
				'label_block' => true,
			]
		);

		$repeater = new \Elementor\Repeater();
    
        $repeater->add_control(
			'hostiko_cpu_name', [
				'label' => __( 'CPU Name', 'elementor-hostiko-tld-table-control' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => __( 'Intel Xeon E3-1230v2' , 'elementor-hostiko-tld-table-control' ),
				'label_block' => true,
			]
		);
        $repeater->add_control(
			'hostiko_tld_currency', [
				'label' => __( 'Currency', 'elementor-hostiko-tld-table-control' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => __( '$' , 'elementor-hostiko-tld-table-control' ),
				'label_block' => true,
			]
		);
        $repeater->add_control(
			'hostiko_speed', [
				'label' => __( 'CPU Speed', 'elementor-hostiko-tld-table-control' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => __( '4 Cores x 3.1 GHz' , 'elementor-hostiko-tld-table-control' ),
				'label_block' => true,
			]
		);
        $repeater->add_control(
			'hostiko_memory', [
				'label' => __( 'Memory', 'elementor-hostiko-tld-table-control' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => __( '8 GB (DDR4)' , 'elementor-hostiko-tld-table-control' ),
				'label_block' => true,
			]
		);
        $repeater->add_control(
			'hostiko_storage', [
				'label' => __( 'Storage', 'elementor-hostiko-tld-table-control' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => __( '2 x 500 GB SATA' , 'elementor-hostiko-tld-table-control' ),
				'label_block' => true,
			]
		);
        $repeater->add_control(
			'hostiko_bandwidth', [
				'label' => __( 'Bandwidth', 'elementor-hostiko-tld-table-control' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => __( 'Unlimited' , 'elementor-hostiko-tld-table-control' ),
				'label_block' => true,
			]
		);
        $repeater->add_control(
			'hostiko_pricing', [
				'label' => __( 'Pricing', 'elementor-hostiko-tld-table-control' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => __( '$19.00' , 'elementor-hostiko-tld-table-control' ),
				'label_block' => true,
			]
		);
        $repeater->add_control(
			'hostiko_button_text', [
				'label' => __( 'Button text', 'elementor-hostiko-tld-table-control' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => __( 'Order now' , 'elementor-hostiko-tld-table-control' ),
				'label_block' => true,
			]
		);
        $repeater->add_control(
			'hostiko_button_link', [
				'label' => __( 'Button link', 'elementor-hostiko-tld-table-control' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => __( '#' , 'elementor-hostiko-tld-table-control' ),
				'label_block' => true,
			]
		);
        
		$this->add_control(
			'list',
			[
				'label' => __( 'Repeater List', 'elementor-hostiko-tld-table-control' ),
				'type' => \Elementor\Controls_Manager::REPEATER,
				'fields' => $repeater->get_controls(),
				'default' => [
					[
						'hostiko_cpu_name' => __( 'Intel Xeon E3-1230v2	', 'elementor-hostiko-tld-table-control' ),
						'hostiko_speed_years' => __( '4 Cores x 3.1 GHz', 'elementor-hostiko-tld-table-control' ),
						'hostiko_memory' => __( '8 GB (DDR4)', 'elementor-hostiko-tld-table-control' ),
						'hostiko_transfer_domain' => __( '2 x 500 GB SATA', 'elementor-hostiko-tld-table-control' ),
						'hostiko_bandwidth' => __( 'Unlimited', 'elementor-hostiko-tld-table-control' ),
                        'hostiko_pricing' => __( '$19.00', 'elementor-hostiko-tld-table-control' ),
                        'hostiko_button_text' => __( 'Button text', 'elementor-hostiko-tld-table-control' ),
                        'hostiko_button_link' => __( '#', 'elementor-hostiko-tld-table-control' ),

					],
					[
						'hostiko_cpu_name' => __( 'Intel Xeon E3-1230v2	', 'elementor-hostiko-tld-table-control' ),
						'hostiko_speed_years' => __( '4 Cores x 3.1 GHz', 'elementor-hostiko-tld-table-control' ),
						'hostiko_memory' => __( '8 GB (DDR4)', 'elementor-hostiko-tld-table-control' ),
						'hostiko_transfer_domain' => __( '2 x 500 GB SATA', 'elementor-hostiko-tld-table-control' ),
						'hostiko_bandwidth' => __( 'Unlimited', 'elementor-hostiko-tld-table-control' ),
                        'hostiko_pricing' => __( '$19.00', 'elementor-hostiko-tld-table-control' ),
                        'hostiko_button_text' => __( 'Button text', 'elementor-hostiko-tld-table-control' ),
                        'hostiko_button_link' => __( '#', 'elementor-hostiko-tld-table-control' ),

					],
				],
				'heading_field' => '{{{ list_heading }}}',
			]
		);
		
        $this->end_controls_section();

		
		
		////////////////////////////////////////////////  Container Style Start /////////////////////////////////////////////////
		$this->start_controls_section(
			'conatiner_tld_style_section',
			[
				'label' => esc_html__( 'Container Style', 'textdomain' ),
				'tab' => \Elementor\Controls_Manager::TAB_STYLE,
			]
		);
       
		
        $this->add_group_control(
            \Elementor\Group_Control_Background::get_type(),
            [
                'name' => 'conatiner_tld_background',
				'label' => __( 'Background', 'textdomain' ),
                'types' => [ 'classic', 'gradient', 'video' ],
                'selector' => '{{WRAPPER}} .hostiko-tld-table-section .hostiko-tld-table',
            ]
        );  
		
		$this->add_responsive_control(
			'conatiner_tld_border_radius',
			[
				'label' => __( 'Conatiner Border Radius', 'textdomain' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'selectors' => [
					'{{WRAPPER}} .hostiko-tld-table-section .hostiko-tld-table' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					
				],
				
			]
		);
		$this->add_group_control(
            \Elementor\Group_Control_Border::get_type(),
            [
                'name' => 'conatiner_tld_border',
                'label' => __( 'Border', 'textdomain' ),
                'selector' => '{{WRAPPER}} .hostiko-tld-table-section .hostiko-tld-table',
            ]
        );
		$this->add_group_control(
			\Elementor\Group_Control_Box_Shadow::get_type(),
			[
				'name' => 'conatiner_tld_box_shadow',
				'selector' => '{{WRAPPER}} .hostiko-tld-table-section .hostiko-tld-table',
			]
		);

        $this->end_controls_section(); 
		////////////////////////////////////////////////  Conatiner Style Ends ///////////////////////////////////////////////
		////////////////////////////////////////////////  Header Style Start /////////////////////////////////////////////////
		$this->start_controls_section(
			'header_style_section',
			[
				'label' => esc_html__( 'Header Style', 'textdomain' ),
				'tab' => \Elementor\Controls_Manager::TAB_STYLE,
			]
		);
        $this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name' => 'header_typography',
				'label' => __( 'Typography', 'textdomain' ),
				'selector' => '{{WRAPPER}} .hostiko-tld-table tr th',
			]
		);
        $this->add_control(
            'header_color',
            [
                'label' => esc_html__('Color', 'textdomain'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .hostiko-tld-table tr th' => 'color: {{VALUE}}',
                ],
            ]
        );
		$this->add_responsive_control(
			'header_padding',
			[
				'label' => __( 'Padding', 'textdomain' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'selectors' => [
					'{{WRAPPER}} .hostiko-tld-table tr th' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		); 
		$this->add_control(
            'header_alignment',
            [
                'label' => esc_html__('Alignment', 'textdomain'),
                'type' => \Elementor\Controls_Manager::CHOOSE,
                'options' => [
                    'left' => [
                        'title' => esc_html__('Left', 'textdomain'),
                        'icon' => 'eicon-text-align-left',
                    ],
                    'center' => [
                        'title' => esc_html__('Center', 'textdomain'),
                        'icon' => 'eicon-text-align-center',
                    ],
                    'right' => [
                        'title' => esc_html__('Right', 'textdomain'),
                        'icon' => 'eicon-text-align-right',
                    ],
                ],
                'default' => 'left',
                'selectors' => [
                    '{{WRAPPER}} .hostiko-tld-table tr th' => 'text-align: {{VALUE}};',
                ],
            ]
        );
		$this->add_group_control(
            \Elementor\Group_Control_Border::get_type(),
            [
                'name' => 'header_border',
                'label' => __( 'Border', 'textdomain' ),
                'selector' => '{{WRAPPER}} .hostiko-tld-table-section .hostiko-tld-table tr th',
            ]
        );
        
		$this->add_responsive_control(
			'header_borderbox_radius',
			[
				'label' => esc_html__( 'Border Radius', 'elementor' ),
				'type' => \Elementor\Controls_Manager::SLIDER,
				'size_units' => [ 'px', '%', 'em', 'rem', 'vw', 'custom' ],
				'default' => [
					'size' => 15,
				],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 100,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .hostiko-tld-table .hostiko-tld-header-row .tld_heading' => 'border-top-left-radius: {{SIZE}}{{UNIT}}',
					'{{WRAPPER}} .hostiko-tld-table .hostiko-tld-header-row th:first-child' => 'border-bottom-left-radius: {{SIZE}}{{UNIT}}',
					'{{WRAPPER}} .hostiko-tld-table .hostiko-tld-header-row .renew_domain_heading' => 'border-bottom-right-radius: {{SIZE}}{{UNIT}}',
					'{{WRAPPER}} .hostiko-tld-table .hostiko-tld-header-row th:last-child' => 'border-top-right-radius: {{SIZE}}{{UNIT}}',
				],
					
			]
		);
			
        $this->add_group_control(
            \Elementor\Group_Control_Background::get_type(),
            [
                'name' => 'header_background',
				'label' => __( 'Background', 'textdomain' ),
                'types' => [ 'classic', 'gradient', 'video' ],
                'selector' => '{{WRAPPER}} .hostiko-tld-table tr th',
            ]
        );  
		
		$this->add_responsive_control(
			'tld_container_border_radius',
			[
				'label' => __( 'Conatiner Border Radius', 'textdomain' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'selectors' => [
					'{{WRAPPER}} .hostiko-tld-table' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					
				],
				
			]
		);
        $this->end_controls_section(); 
		////////////////////////////////////////////////  Header Style Ends /////////////////////////////////////////////////
		////////////////////////////////////////////////  Content Style Starts ///////////////////////////////////////////////// 
        $this->start_controls_section(
			'content_style_section',
			[
				'label' => esc_html__( 'Content Style', 'textdomain' ),
				'tab' => \Elementor\Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name' => 'content_typography',
				'label' => __( 'Typography', 'textdomain' ),
				'selector' => '{{WRAPPER}} .hostiko-tld-table tr td',
			]
		);
        $this->add_control(
            'main_content_color',
            [
                'label' => esc_html__('Label Color', 'textdomain'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .hostiko-tld-table tr td:first-child' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'content_color',
            [
                'label' => esc_html__('Color', 'textdomain'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .hostiko-tld-table tr td' => 'color: {{VALUE}}',
                ],
            ]
        );
        
		$this->add_responsive_control(
			'content_padding',
			[
				'label' => __( 'Padding', 'textdomain' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'selectors' => [
					'{{WRAPPER}} .hostiko-tld-table tr td' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);
        $this->add_group_control(
            \Elementor\Group_Control_Background::get_type(),
            [
                'name' => 'content_background-even',
				'label' => esc_html__( 'Background Even', 'textdomain' ),
                'types' => [ 'classic', 'gradient', 'video' ],
                'selector' => '{{WRAPPER}} .hostiko-tld-table tr:nth-child(even)',
            ]
        );  
        $this->add_group_control(
            \Elementor\Group_Control_Background::get_type(),
            [
                'name' => 'content_background-odd',
				'label' => esc_html__( 'Background Odd', 'textdomain' ),
                'types' => [ 'classic', 'gradient', 'video' ],
                'selector' => '{{WRAPPER}} .hostiko-tld-table tr:nth-child(odd)',
            ]
        );  
		$this->add_control(
            'content_header_alignment',
            [
                'label' => esc_html__('Alignment', 'textdomain'),
                'type' => \Elementor\Controls_Manager::CHOOSE,
                'options' => [
                    'left' => [
                        'title' => esc_html__('Left', 'textdomain'),
                        'icon' => 'eicon-text-align-left',
                    ],
                    'center' => [
                        'title' => esc_html__('Center', 'textdomain'),
                        'icon' => 'eicon-text-align-center',
                    ],
                    'right' => [
                        'title' => esc_html__('Right', 'textdomain'),
                        'icon' => 'eicon-text-align-right',
                    ],
                ],
                'default' => 'left',
                'selectors' => [
                    '{{WRAPPER}} .hostiko-tld-table tr td' => 'text-align: {{VALUE}};',
                ],
            ]
        );
		$this->end_controls_section();
        $this->start_controls_section(
			'button_style_section',
			[
				'label' => esc_html__( 'Button Style', 'textdomain' ),
				'tab' => \Elementor\Controls_Manager::TAB_STYLE,
			]
		);
        $this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name' => 'button_typography',
				'label' => __( 'Typography', 'textdomain' ),
				'selector' => '{{WRAPPER}} .hostiko-tld-body-row td a',
			]
		);
        $this->start_controls_tabs(
			'style_tabs'
		);

		$this->start_controls_tab(
			'style_normal_tab',
			[
				'label' => esc_html__( 'Normal', 'textdomain' ),
			]
		);
        $this->add_control(
            'button__text_color',
            [
                'label' => esc_html__('Color', 'textdomain'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .hostiko-tld-body-row td a' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
			\Elementor\Group_Control_Background::get_type(),
			[
				'name' => 'background',
				'types' => [ 'classic', 'gradient', ],
				'selector' => '{{WRAPPER}} .hostiko-tld-body-row td a',
			]
		);
        $this->add_group_control(
            \Elementor\Group_Control_Border::get_type(),
            [
                'name' => 'button_border',
                'label' => __( 'Border', 'textdomain' ),
                'selector' => '{{WRAPPER}} .hostiko-tld-body-row td a',
            ]
        );
        $this->add_responsive_control(
			'button_border_radius',
			[
				'label' => __( 'Border Radius', 'textdomain' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'selectors' => [
					'{{WRAPPER}} .hostiko-tld-body-row td a' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					
				],
				
			]
		);
		$this->add_group_control(
			\Elementor\Group_Control_Box_Shadow::get_type(),
			[
				'name' => 'button_box_shadow',
				'selector' => '{{WRAPPER}} .hostiko-tld-body-row td a',
			]
		);
        $this->add_responsive_control(
			'button_padding',
			[
				'label' => __( 'Padding', 'textdomain' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'selectors' => [
					'{{WRAPPER}}  .hostiko-tld-body-row td a' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		); 
		$this->add_control(
            'button_alignment',
            [
                'label' => esc_html__('Alignment', 'textdomain'),
                'type' => \Elementor\Controls_Manager::CHOOSE,
                'options' => [
                    'left' => [
                        'title' => esc_html__('Left', 'textdomain'),
                        'icon' => 'eicon-text-align-left',
                    ],
                    'center' => [
                        'title' => esc_html__('Center', 'textdomain'),
                        'icon' => 'eicon-text-align-center',
                    ],
                    'right' => [
                        'title' => esc_html__('Right', 'textdomain'),
                        'icon' => 'eicon-text-align-right',
                    ],
                ],
                'default' => 'left',
                'selectors' => [
                    '{{WRAPPER}}  .hostiko-tld-body-row td a' => 'text-align: {{VALUE}};',
                ],
            ]
        );
		$this->end_controls_tab();

		$this->start_controls_tab(
			'style_hover_tab',
			[
				'label' => esc_html__( 'Hover', 'textdomain' ),
			]
		);
        $this->add_control(
            'button__text_hover_color',
            [
                'label' => esc_html__('Color', 'textdomain'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .hostiko-tld-body-row td a:hover' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
			\Elementor\Group_Control_Background::get_type(),
			[
				'name' => 'Hover background',
				'types' => [ 'classic', 'gradient', ],
				'selector' => '{{WRAPPER}} .hostiko-tld-body-row td a:hover',
			]
		);
        $this->add_group_control(
            \Elementor\Group_Control_Border::get_type(),
            [
                'name' => 'button_border_hover',
                'label' => __( 'Border', 'textdomain' ),
                'selector' => '{{WRAPPER}} .hostiko-tld-body-row td a:hover',
            ]
        );
        $this->add_responsive_control(
			'button_border_radius_hover',
			[
				'label' => __( 'Border Radius Hover', 'textdomain' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'selectors' => [
					'{{WRAPPER}} .hostiko-tld-body-row td a:hover' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					
				],
				
			]
		);
		$this->add_group_control(
			\Elementor\Group_Control_Box_Shadow::get_type(),
			[
				'name' => 'button_box_shadow_hover',
				'selector' => '{{WRAPPER}} .hostiko-tld-body-row td a:hover',
			]
		);
       
        $this->end_controls_tab();

        $this->end_controls_section();
        /////////////////////////////////////////////////////////////////////////////////////////////////////////////////
        

	}


	/**
	 * Render hostiko-dedicated-server widget output on the frontend.
	 *
	 * Written in PHP and used to generate the final HTML.
	 *
	 * @since 1.0.0
	 * @access protected
	 */
	protected function render() {
		$settings = $this->get_settings_for_display();
				?>
				<div class="hostiko-tld-table-section position-relative">
					<div class="position-relative" data-aos="fade-up">
                        <table class="hostiko-tld-table hostiko-dedicated-tld-table">
                            <thead class="hostiko-tld-header bg_gradient">
                                <tr class="hostiko-tld-header-row">
                                    <th class="cpu_heading"><?php echo $settings['hostiko_cpu_heading'] ?></th>
                                    <th class="speed_heading"><?php echo $settings['hostiko_speed_heading'] ?></th>
                                    <th class="memory_heading"><?php echo $settings['hostiko_memory_heading'] ?></th>
                                    <th class="storage_heading"><?php echo $settings['hostiko_storage_heading'] ?></th>
                                    <th class="bandwidth_heading"><?php echo $settings['hostiko_bandwidth_heading'] ?></th>
                                    <th class="pricing_heading"><?php echo $settings['hostiko_pricing_heading'] ?></th>
                                    <th class="button_heading"><?php echo $settings['hostiko_button_heading'] ?></th>
                                </tr>
                            </thead>
                            <tbody> 
                                <?php
                                    $count = 0;
                                    if ( $settings['list'] ) {
                                    foreach ( $settings['list'] as $item ) {	
                                ?>
                                    <tr class="hostiko-tld-body-row">
                                        <td data-label="<? echo $settings['hostiko_cpu_heading'] ?>"><?php echo $item['hostiko_cpu_name'] ?></td>
                                        <td data-label="<? echo $settings['hostiko_speed_heading'] ?>"><?php echo $item['hostiko_speed'] ?></td>
                                        <td data-label="<? echo $settings['hostiko_memory_heading'] ?>"><?php echo $item['hostiko_memory'] ?></td>
                                        <td data-label="<? echo $settings['hostiko_storage_heading'] ?>"><?php echo $item['hostiko_storage'] ?></td>
                                        <td data-label="<? echo $settings['hostiko_bandwidth_heading'] ?>"><?php echo $item['hostiko_bandwidth'] ?></td>
                                        <td data-label="<? echo $settings['hostiko_pricing_heading'] ?>"><?php echo $item['hostiko_pricing'] ?></td>
                                        <td data-label="<? echo $settings['hostiko_button_heading'] ?>"><a href="<?php echo $item['hostiko_button_link'] ?>"><?php echo $item['hostiko_button_text'] ?></a></td>
                                    </tr>
                                    <?php
                                        $count++;
                                    }
                                    }
                                    ?>
                            </tbody>
                        </table>
                        
					</div>
				</div> 
				
				
			<?php
				
	}
	

}
