<?php
/**
 * Plugin Name: Hostiko Toolkit
 * Description: Hostiko Custom Elementor addon.
 * Plugin URI:  http://designingmedia.com
 * Version:     1.0.4
 * Author:      Designing Media
 * Author URI:  http://designingmedia.com
 * Text Domain: hostiko-toolkit 
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}
if ( ! defined( 'PLUGIN_BASE_URI' ) ) {
	define('PLUGIN_BASE_URI', plugin_dir_url( __FILE__ ));
}

function hostiko_toolkit_addon() {

	// Load plugin file
	require_once( __DIR__ . '/includes/Hostiko_Plugin.php' );

	// Run the plugin
	\Hostiko_Toolkit_Addon\Hostiko_Plugin::instance();

}
add_action( 'plugins_loaded', 'hostiko_toolkit_addon' );

// Define a function that enqueues your CSS styles
function css_styles() {
	$plugin_url = plugin_dir_url( __FILE__ );
	wp_enqueue_style( 'hostiko_widget_style',  $plugin_url . "assets/css/hostiko-widget.css");
}
// Hook the function to an appropriate WordPress action
add_action( 'wp_enqueue_scripts', 'css_styles' );


// Define a function that enqueues your JS styles
// function js_styles() {
// 	$plugin_url = plugin_dir_url( __FILE__ );
// 	wp_enqueue_script( 'hostiko_widget_JS',  $plugin_url . "assets/js/hostiko-widget.js", array( 'jquery', 'owl_crousel_min'), '', true );
// 	wp_enqueue_script( 'hostiko_nice_select_JS',  $plugin_url . "assets/js/nice-select.js", array(), '', true );
	
// 	wp_localize_script( 'hostiko_widget_JS', 'redux_widget_ajax_object',
// 	array( 
// 		'ajaxurl' => admin_url( 'admin-ajax.php' ),
// 	)
// );



// }
// // Hook the function to an appropriate WordPress action
// add_action( 'wp_enqueue_scripts', 'js_styles' );



// Define a function that enqueues your front-end scripts
function js_styles() {
    $plugin_url = plugin_dir_url( __FILE__ );
   
	// Enqueue Widget script with jQuery and owl_crousel_min as dependencies
    wp_enqueue_script( 'hostiko_widget_JS',  $plugin_url . "assets/js/hostiko-widget.js", array( 'jquery', 'owl_crousel_min' ), '', true );
    // Enqueue Nice Select script
    wp_enqueue_script( 'hostiko_nice_select_JS',  $plugin_url . "assets/js/nice-select.js", array(), '', true );
    wp_localize_script( 'hostiko_widget_JS', 'redux_widget_ajax_object',
        array( 
            'ajaxurl' => admin_url( 'admin-ajax.php' ),
        )
    );
}

// Enqueue scripts for the front end
add_action( 'wp_enqueue_scripts', 'js_styles' );

// Define a function that enqueues your Elementor editor scripts
function js_styles_editor() {
    $plugin_url = plugin_dir_url( __FILE__ );
    wp_enqueue_script( 'hostiko_widget_JS_editor',  $plugin_url . "assets/js/hostiko-widget.js", array('jquery'), '', true );
    // Enqueue Nice Select script
    wp_enqueue_script( 'hostiko_nice_select_JS_editor',  $plugin_url . "assets/js/nice-select.js", array('jquery'), '', true );

}

// Enqueue scripts for the Elementor editor
add_action( 'elementor/editor/after_enqueue_scripts', 'js_styles_editor' );



function decrypt_data($data, $key) {
	$cipher = "aes-256-cbc";
	$data = base64_decode($data);
	$iv_length = openssl_cipher_iv_length($cipher);
	$iv = substr($data, 0, $iv_length);
	$data = substr($data, $iv_length);
	return openssl_decrypt($data, $cipher, $key, 0, $iv);
}

function domainWhois(){
	if(isset($_POST['action']) && trim($_POST['action']) == 'domainWhoisCheck'){
		$whmcs_url = get_option('whmcs_url');
		$whmcs_secret = decrypt_data(get_option('whmcs_secret'),'a3f9e1b2c5d8e0a7f6b9d2c4a7e9f2b0c5e8a0f5b7e9a3f2b0c5e8a0f5b7e9');
		$whmcs_identifier = decrypt_data(get_option('whmcs_identifier'),'a3f9e1b2c5d8e0a7f6b9d2c4a7e9f2b0c5e8a0f5b7e9a3f2b0c5e8a0f5b7e9');
		
		$ch = curl_init();
		curl_setopt($ch, CURLOPT_URL, $whmcs_url);
		curl_setopt($ch, CURLOPT_POST, 1);
		curl_setopt($ch, CURLOPT_POSTFIELDS,
			http_build_query(
				array(
					'action' => 'DomainWhois',
					'identifier' => $whmcs_identifier,
					'secret' => $whmcs_secret,
					'domain' => $_POST['domain'],
					'responsetype' => 'json',

				)
			)
		);
		curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
		$response = curl_exec($ch);
		echo ($response);
		curl_close($ch);
		die;
	}

	
}

add_action( "wp_ajax_domainWhoisCheck", "domainWhois");
add_action( "wp_ajax_nopriv_domainWhoisCheck" ,"domainWhois");


function getWHMCSlink(){
	if(isset($_POST['action']) && trim($_POST['action']) == 'getWHMCSLink'){
		$whmcs_url = get_option('whmcs_url');
		echo json_encode($whmcs_url);
		die;
	}


}

add_action( "wp_ajax_getWHMCSLink", "getWHMCSlink");
add_action( "wp_ajax_nopriv_getWHMCSLink" ,"getWHMCSlink");






// Woocomerce Cart Short Code
 
add_shortcode ('woo_cart_but', 'woo_cart_but' );

/**
 * Create Shortcode for WooCommerce Cart Menu Item
 */
function woo_cart_but() {
    ob_start();
        if(isset(WC()->cart)){
        $cart_count = WC()->cart->cart_contents_count; // Set variable for cart item count
        $cart_url = wc_get_cart_url();  // Set Cart URL
 
        ?>
        <a class="btn nav-link" href="<?php echo $cart_url; ?>">
			<i class="fas fa-shopping-cart"></i>
            <span class="badge badge-info"></span>
        <?php
        if ( $cart_count > 0 ) {
       ?>
            <span class="cart-contents-count"><?php echo $cart_count; ?></span>
        <?php
        }
        ?>
        </a></li>
        <?php
        }
        else{
            ?>
           <i class="fas fa-shopping-cart"></i>
            <?php
        }
    return ob_get_clean();
 
}

add_filter( 'woocommerce_add_to_cart_fragments', 'woo_cart_but_count', 10, 1 );

/**
 * Add AJAX Shortcode when cart contents update
 */
function woo_cart_but_count( $fragments ) {
 
    ob_start();
   
    $cart_count = WC()->cart->cart_contents_count;
    $cart_url = wc_get_cart_url();
   
    ?>
    <a class="cart-contents menu-item" href="<?php echo $cart_url; ?>" title="<?php _e( 'View your shopping cart' ); ?>">
    <?php
    if ( $cart_count > 0 ) {
        ?>
        <span class="cart-contents-count"><?php echo $cart_count; ?></span>
        <?php            
    }
        ?></a>
    <?php
 
    $fragments['a.cart-contents'] = ob_get_clean();
     
    return $fragments;
}
 
add_filter( 'wp_nav_menu_top-menu_items', 'woo_cart_but_icon', 10, 2 ); // Change menu to suit - example uses 'top-menu'


/**
 * Add WooCommerce Cart Menu Item Shortcode to particular menu
 */
function woo_cart_but_icon ( $items, $args ) {
	$items .=  '[woo_cart_but]'; // Adding the created Icon via the shortcode already created
	return $items;
}

add_action('wp_ajax_cart_count_retriever', 'cart_count_retriever');
add_action('wp_ajax_nopriv_cart_count_retriever', 'cart_count_retriever');




function cart_count_retriever() {
    global $wpdb;
    echo WC()->cart->get_cart_contents_count();
    wp_die();
}