<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

/**
 * Elementor whmcs_product Widget.
 *
 * Elementor widget that uses the whmcs_product control.
 *
 * @since 1.0.0
 */
class Elementor_Whmcs_Product_Widget extends \Elementor\Widget_Base {

	/**
	 * Get widget name.
	 *
	 * Retrieve whmcs whmcs_product widget name.
	 *
	 * @since 1.0.0
	 * @access public
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'whmcs_product';
	}

	/**
	 * Get widget title.
	 *
	 * Retrieve whmcs whmcs_product widget title.
	 *
	 * @since 1.0.0
	 * @access public
	 * @return string Widget title.
	 */
	public function get_title() {
		return esc_html__( 'WHMCS Name Only', 'hostiko-toolkit' );
	}

	/**
	 * Get widget icon.
	 *
	 * Retrieve whmcs whmcs_product_widget icon.
	 *
	 * @since 1.0.0
	 * @access public
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'eicon-editor-code';
	}

	/**
	 * Register whmcs whmcs_product widget controls.
	 *
	 * Add input fields to allow the user to customize the widget settings.
	 *
	 * @since 1.0.0
	 * @access protected
	 */
	protected function register_controls() {

		$this->start_controls_section(
			'content_section',
			[
				'label' => esc_html__( 'Content', 'hostiko-toolkit' ),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);
		$this->add_control(
            'selected_value',
            [
                'label' => 'Select Product Name',
                'type' => \Elementor\Controls_Manager::SELECT,
                'options' => [
                    '' => 'Select an option', // Placeholder
                ],
            ]
        );

		$this->add_control(
            'warning_text',
            [
                'type' => 'raw_html',
                'label' => ' Please Sync your WHMCS from dashboard <strong>hostiko > WHMCS </strong> and then Select WHMCS Product Name',
                'content' => '<input type="text" value="This is a warning message" disabled>',
            ]
        );
        $this->end_controls_section();

		/////////////////////////////////////////////////////////////////////////////////////////////////////

        $this->start_controls_section(
            'style_section',
            [
                'label' => esc_html__( 'Content', 'hostiko-toolkit' ),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name' => 'whmcs_product_name_typography',
				'label' => __( 'Typography', 'hostiko-toolkit' ),
				'selector' => '{{WRAPPER}} .whmcs_prodcts_name',
				'global' => [
					'default' => \Elementor\Core\Kits\Documents\Tabs\Global_Typography::TYPOGRAPHY_PRIMARY,
				],
			]
		);
        $this->add_control(
            'whmcs_product_name_color',
            [
                'label' => esc_html__('Color', 'hostiko-toolkit'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .whmcs_prodcts_name' => 'color: {{VALUE}}',
                ],
				'global' => [
					'default' => \Elementor\Core\Kits\Documents\Tabs\Global_Colors::COLOR_PRIMARY,
				],
            ]
        );
        
        $this->add_responsive_control(
			'whmcs_product_name_padding',
			[
				'label' => __( 'Padding', 'hostiko-toolkit' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'selectors' => [
					'{{WRAPPER}} .whmcs_prodcts_name' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		); 
		$this->add_responsive_control(
			'whmcs_product_name_margin',
			[
				'label' => __( 'Margin', 'hostiko-toolkit' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'selectors' => [
					'{{WRAPPER}} .whmcs_prodcts_name' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);
		$this->add_control(
            'whmcs_product_name_alignment',
            [
                'label' => esc_html__('Alignment', 'hostiko-toolkit'),
                'type' => \Elementor\Controls_Manager::CHOOSE,
                'options' => [
                    'left' => [
                        'title' => esc_html__('Left', 'hostiko-toolkit'),
                        'icon' => 'eicon-text-align-left',
                    ],
                    'center' => [
                        'title' => esc_html__('Center', 'hostiko-toolkit'),
                        'icon' => 'eicon-text-align-center',
                    ],
                    'right' => [
                        'title' => esc_html__('Right', 'hostiko-toolkit'),
                        'icon' => 'eicon-text-align-right',
                    ],
                ],
                'default' => 'left',
                'selectors' => [
                    '{{WRAPPER}} .whmcs_prodcts_name' => 'text-align: {{VALUE}};',
                ],
            ]
        );
		
        $this->add_group_control(
            \Elementor\Group_Control_Background::get_type(),
            [
                'name' => 'whmcs_product_name_background',
				'label' => __( 'Background', 'hostiko-toolkit' ),
                'types' => [ 'classic', 'gradient', 'video' ],
                'selector' => '{{WRAPPER}} .whmcs_prodcts_name',
            ]
        );  
		$this->add_group_control(
            \Elementor\Group_Control_Border::get_type(),
            [
                'name' => 'whmcs_product_name_border',
                'label' => __( 'Border', 'hostiko-toolkit' ),
                'selector' => '{{WRAPPER}} .whmcs_prodcts_name',
            ]
        );
        $this->add_responsive_control(
			'whmcs_product_name_border_radius',
			[
				'label' => __( 'Border Radius', 'hostiko-toolkit' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'selectors' => [
					'{{WRAPPER}} .whmcs_prodcts_name' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);
		$this->end_controls_section();
	}


	/**
	 * Render whmcs whmcs_product widget output on the frontend.
	 *
	 * Written in PHP and used to generate the final HTML.
	 *
	 * @since 1.0.0
	 * @access protected
	 */
	protected function render() {
		$settings = $this->get_settings_for_display();

        $option_value = json_decode (get_option('whmcs_products_data'));
       
		$all_whmcs_product= $option_value-> products -> product;

		$dynamic_options = [];
		foreach ($all_whmcs_product as $item) {
			$dynamic_options[esc_attr($item-> name)] = esc_html($item-> name);
		}
		// Retrieve the existing control and update its options.
		$control['options'] = $dynamic_options;
		$this->update_control('selected_value', $control);

		if(isset($settings['selected_value']) || !empty($settings['selected_value'])){
			?>
				<p class= "whmcs_prodcts_name"><?= $settings['selected_value']; ?></p>

			<?php
		}else{
			?>
				<p class= "whmcs_prodcts_name">Please Choose any product</p>
			<?php
		}
			
	}

}