<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

/**
 * Elementor whmcs_product_description Widget.
 *
 * Elementor widget that uses the whmcs_product_description control.
 *
 * @since 1.0.0
 */
class Elementor_Whmcs_Product_Description_Widget extends \Elementor\Widget_Base {

	/**
	 * Get widget name.
	 *
	 * Retrieve whmcs whmcs_product_description widget name.
	 *
	 * @since 1.0.0
	 * @access public
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'whmcs_product_description';
	}

	/**
	 * Get widget title.
	 *
	 * Retrieve whmcs whmcs_product_description widget title.
	 *
	 * @since 1.0.0
	 * @access public
	 * @return string Widget title.
	 */
	public function get_title() {
		return esc_html__( 'WHMCS Desc Only', 'hostiko-toolkit' );
	}

	/**
	 * Get widget icon.
	 *
	 * Retrieve whmcs whmcs_product_description_widget icon.
	 *
	 * @since 1.0.0
	 * @access public
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'eicon-product-description';
	}

	/**
	 * Register whmcs whmcs_product_description widget controls.
	 *
	 * Add input fields to allow the user to customize the widget settings.
	 *
	 * @since 1.0.0
	 * @access protected
	 */
	protected function register_controls() {

		$this->start_controls_section(
			'content_section',
			[
				'label' => esc_html__( 'Content', 'hostiko-toolkit' ),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);

		$this->add_control(
            'selected_description',
            [
                'label' => 'Select Product Name',
                'type' => \Elementor\Controls_Manager::SELECT,
                'options' => [
                    '' => 'Select an option', // Placeholder
                ],
            ]
        );
		
           
		$this->add_control(
            'warning_text',
            [
                'type' => 'raw_html',
                'label' => ' Please Sync your WHMCS from dashboard <strong>hostiko > WHMCS </strong> and then Select WHMCS Product Description ',
                'content' => '<input type="text" value="This is a warning message" disabled>',
            ]
        );
		
        $this->end_controls_section();

		/////////////////////////////////////////////////////////////////////////////////////////////////////

        $this->start_controls_section(
            'style_section',
            [
                'label' => esc_html__( 'Content', 'hostiko-toolkit' ),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name' => 'whmcs_product_name_typography',
				'label' => __( 'Typography', 'hostiko-toolkit' ),
				'selector' => '{{WRAPPER}} .whmcs_prodcts_description, .whmcs_prodcts_description ul li',
				'global' => [
					'default' => \Elementor\Core\Kits\Documents\Tabs\Global_Typography::TYPOGRAPHY_TEXT,
				],
			]
		);
        $this->add_control(
            'whmcs_product_name_color',
            [
                'label' => esc_html__('Color', 'hostiko-toolkit'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .whmcs_prodcts_description, .whmcs_prodcts_description ul li' => 'color: {{VALUE}}',
                ],
				'global' => [
					'default' => \Elementor\Core\Kits\Documents\Tabs\Global_Colors::COLOR_TEXT,
				],
            ]
        );

		$this->add_control(
            'list_description_style',
            [
                'label' => 'Select List Style',
                'type' => \Elementor\Controls_Manager::SELECT,
                'options' => [
                    '' => 'Default', // Placeholder
                    'circle' => 'circle', // Placeholder
                    'disc' => 'disc', // Placeholder
                    'square' => 'square', // Placeholder
                    'decimal' => 'decimal', // Placeholder
                    'none' => 'none', // Placeholder
                ],
				'selectors' => [
					'{{WRAPPER}} .whmcs_prodcts_description ul li' => 'list-style-type: {{VALUE}};',
				],
            ]
        );
        
        $this->add_responsive_control(
			'whmcs_product_name_padding',
			[
				'label' => __( 'Padding', 'hostiko-toolkit' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'selectors' => [
					'{{WRAPPER}} .whmcs_prodcts_description, .whmcs_prodcts_description ul li' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		); 
		$this->add_responsive_control(
			'whmcs_product_name_margin',
			[
				'label' => __( 'Margin', 'hostiko-toolkit' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'selectors' => [
					'{{WRAPPER}} .whmcs_prodcts_description, .whmcs_prodcts_description ul li' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);
		$this->add_control(
            'whmcs_product_name_alignment',
            [
                'label' => esc_html__('Alignment', 'hostiko-toolkit'),
                'type' => \Elementor\Controls_Manager::CHOOSE,
                'options' => [
                    'left' => [
                        'title' => esc_html__('Left', 'hostiko-toolkit'),
                        'icon' => 'eicon-text-align-left',
                    ],
                    'center' => [
                        'title' => esc_html__('Center', 'hostiko-toolkit'),
                        'icon' => 'eicon-text-align-center',
                    ],
                    'right' => [
                        'title' => esc_html__('Right', 'hostiko-toolkit'),
                        'icon' => 'eicon-text-align-right',
                    ],
                ],
                'default' => 'left',
                'selectors' => [
                    '{{WRAPPER}} .whmcs_prodcts_description, .whmcs_prodcts_description ul li' => 'text-align: {{VALUE}};',
                ],
            ]
        );
		
        $this->add_group_control(
            \Elementor\Group_Control_Background::get_type(),
            [
                'name' => 'whmcs_product_name_background',
				'label' => __( 'Background', 'hostiko-toolkit' ),
                'types' => [ 'classic', 'gradient', 'video' ],
                'selector' => '{{WRAPPER}} .whmcs_prodcts_description ul li',
            ]
        );  
		$this->add_group_control(
            \Elementor\Group_Control_Border::get_type(),
            [
                'name' => 'whmcs_product_name_border',
                'label' => __( 'Border', 'hostiko-toolkit' ),
                'selector' => '{{WRAPPER}} .whmcs_prodcts_description ul li',
            ]
        );
        $this->add_responsive_control(
			'whmcs_product_name_border_radius',
			[
				'label' => __( 'Border Radius', 'hostiko-toolkit' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'selectors' => [
					'{{WRAPPER}} .whmcs_prodcts_description ul li' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);
		$this->end_controls_section();
	}


	/**
	 * Render whmcs whmcs_product_description widget output on the frontend.
	 *
	 * Written in PHP and used to generate the final HTML.
	 *
	 * @since 1.0.0
	 * @access protected
	 */
	protected function render() {
		$settings = $this->get_settings_for_display();
        //echo 'settings: <pre>' . print_r($settings['selected_description_icon']['value'], true) . '</pre>';
		

        $option_value = json_decode (get_option('whmcs_products_data'));
       
		$all_whmcs_product= $option_value-> products -> product;
       
		$dynamic_product_description = [];
		foreach ($all_whmcs_product as $item) {
			$dynamic_product_description[esc_attr($item-> description)] = esc_html($item-> name);
		}
		// Retrieve the existing control and update its options.
		$control['options'] = $dynamic_product_description;
		$this->update_control('selected_description', $control);

		if(isset($settings['selected_description']) || !empty($settings['selected_description'])){
			?>
				<div class= "whmcs_prodcts_description"><?= html_entity_decode($settings['selected_description']); ?></div>

			<?php
		}else{
			?>
				<div class= "whmcs_prodcts_description">Please Choose any product</div>
			<?php
		}
			
	}

}