<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

/**
 * Elementor whmcs_product_button Widget.
 *
 * Elementor widget that uses the whmcs_product_button control.
 *
 * @since 1.0.0
 */
class Elementor_Whmcs_Product_Button_Widget extends \Elementor\Widget_Base {

	/**
	 * Get widget name.
	 *
	 * Retrieve whmcs whmcs_product_button widget name.
	 *
	 * @since 1.0.0
	 * @access public
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'whmcs_product_button';
	}

	/**
	 * Get widget title.
	 *
	 * Retrieve whmcs whmcs_product_button widget title.
	 *
	 * @since 1.0.0
	 * @access public
	 * @return string Widget title.
	 */
	public function get_title() {
		return esc_html__( 'WHMCS Button Only', 'hostiko-toolkit' );
	}

	/**
	 * Get widget icon.
	 *
	 * Retrieve whmcs whmcs_product_button_widget icon.
	 *
	 * @since 1.0.0
	 * @access public
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'eicon-editor-code';
	}

	/**
	 * Register whmcs whmcs_product_button widget controls.
	 *
	 * Add input fields to allow the user to customize the widget settings.
	 *
	 * @since 1.0.0
	 * @access protected
	 */
	protected function register_controls() {

		$this->start_controls_section(
			'content_section',
			[
				'label' => esc_html__( 'Content', 'hostiko-toolkit' ),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);
		$this->add_control(
			'button_title',
			[
				'label' => esc_html__( 'Button Title', 'hostiko-toolkit' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => esc_html__( 'Order Now', 'hostiko-toolkit' ),
				'placeholder' => esc_html__( 'Order Now', 'hostiko-toolkit' ),
			]
		);
		$this->add_control(
			'choose_hostiko_template',
			[
				'label' => esc_html__( 'Choose Custom Hostiko Template', 'hostiko-toolkit' ),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'label_on' => esc_html__( 'Yes', 'hostiko-toolkit' ),
				'label_off' => esc_html__( 'No', 'hostiko-toolkit' ),
				'return_value' => 'yes',
				'default' => 'no',
			]
		);
		$this->add_control(
			'layout_no',
			[
				'label' => esc_html__( 'Template Number', 'hostiko-toolkit' ),
				'type' => \Elementor\Controls_Manager::NUMBER,
				'min' => 1,
				'max' => 200,
				'step' => 1,
				'default' => 85,
				'condition' => [
					'choose_hostiko_template' => 'yes',
				],
			]
		);
		$this->add_control(
            'warning_text',
            [
                'type' => 'raw_html',
                'label' => '<strong>Note:</strong> We recommend you always use <strong>No</strong> if you are not a developer; the <strong>Yes</strong> option is for Hostiko developers only ',
                'content' => '<input type="text" value="This is a warning message" disabled>',
            ]
        );
        $this->end_controls_section();

		/////////////////////////////////////////////////////////////////////////////////////////////////////

        $this->start_controls_section(
            'style_section',
            [
                'label' => esc_html__( 'Style', 'hostiko-toolkit' ),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name' => 'whmcs_product_button_name_typography',
				'label' => __( 'Typography', 'hostiko-toolkit' ),
				'selector' => '{{WRAPPER}} .whmcs-product-btn-outer .whmcs-product-btn',
			]
		);
        $this->add_control(
            'whmcs_product_button_name_color',
            [
                'label' => esc_html__('Color', 'hostiko-toolkit'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .whmcs-product-btn-outer .whmcs-product-btn' => 'color: {{VALUE}}',
                ],
            ]
        );
		$this->add_group_control(
            \Elementor\Group_Control_Background::get_type(),
            [
                'name' => 'whmcs_product_button_name_background',
				'label' => __( 'Background', 'hostiko-toolkit' ),
                'types' => [ 'classic', 'gradient', 'video' ],
                'selector' => '{{WRAPPER}} .whmcs-product-btn-outer .whmcs-product-btn',
            ]
        );  
		$this->add_control(
            'whmcs_product_button_name_color_hover',
            [
                'label' => esc_html__('Color Hover', 'hostiko-toolkit'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .whmcs-product-btn-outer .whmcs-product-btn:hover' => 'color: {{VALUE}}',
                ],
            ]
        );
		$this->add_group_control(
            \Elementor\Group_Control_Background::get_type(),
            [
                'name' => 'whmcs_product_button_name_background_hover',
				'label' => __( 'Background Hover', 'hostiko-toolkit' ),
                'types' => [ 'classic', 'gradient', 'video' ],
                'selector' => '{{WRAPPER}} .whmcs-product-btn-outer .whmcs-product-btn:hover',
            ]
        );  
        $this->add_responsive_control(
			'whmcs_product_button_name_padding',
			[
				'label' => __( 'Padding', 'hostiko-toolkit' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'selectors' => [
					'{{WRAPPER}} .whmcs-product-btn-outer .whmcs-product-btn' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		); 
		$this->add_responsive_control(
			'whmcs_product_button_name_margin',
			[
				'label' => __( 'Margin', 'hostiko-toolkit' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'selectors' => [
					'{{WRAPPER}} .whmcs-product-btn-outer .whmcs-product-btn' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);
		$this->add_control(
            'whmcs_product_button_name_alignment',
            [
                'label' => esc_html__('Alignment', 'hostiko-toolkit'),
                'type' => \Elementor\Controls_Manager::CHOOSE,
                'options' => [
                    'left' => [
                        'title' => esc_html__('Left', 'hostiko-toolkit'),
                        'icon' => 'eicon-text-align-left',
                    ],
                    'center' => [
                        'title' => esc_html__('Center', 'hostiko-toolkit'),
                        'icon' => 'eicon-text-align-center',
                    ],
                    'right' => [
                        'title' => esc_html__('Right', 'hostiko-toolkit'),
                        'icon' => 'eicon-text-align-right',
                    ],
                ],
                'default' => 'left',
                'selectors' => [
                    '{{WRAPPER}} .whmcs-product-btn-outer' => 'text-align: {{VALUE}};',
                ],
            ]
        );
		$this->add_group_control(
            \Elementor\Group_Control_Border::get_type(),
            [
                'name' => 'whmcs_product_button_name_border',
                'label' => __( 'Border', 'hostiko-toolkit' ),
                'selector' => '{{WRAPPER}} .whmcs-product-btn-outer .whmcs-product-btn',
            ]
        );
        $this->add_responsive_control(
			'whmcs_product_button_name_border_radius',
			[
				'label' => __( 'Border Radius', 'hostiko-toolkit' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'selectors' => [
					'{{WRAPPER}} .whmcs-product-btn-outer .whmcs-product-btn' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);
		$this->add_control(
			'whmcs_product_button_name_box_shadow',
			[
				'label' => esc_html__( 'Box Shadow', 'hostiko-toolkit' ),
				'type' => \Elementor\Controls_Manager::BOX_SHADOW,
				'selectors' => [
					'{{SELECTOR}} .whmcs-product-btn-outer .whmcs-product-btn' => 'box-shadow: {{HORIZONTAL}}px {{VERTICAL}}px {{BLUR}}px {{SPREAD}}px {{COLOR}};',
				],
			]
		);
		$this->end_controls_section();
	}


	/**
	 * Render whmcs whmcs_product_button widget output on the frontend.
	 *
	 * Written in PHP and used to generate the final HTML.
	 *
	 * @since 1.0.0
	 * @access protected
	 */
	protected function render() {
		$settings = $this->get_settings_for_display();

		?>
		<div class="whmcs-product-btn-outer">
			<a class="whmcs-product-btn" href="#" data-custom="<?php echo isset($settings['choose_hostiko_template']) ? $settings['choose_hostiko_template'] : 'no'; ?>" data-layout="<?php echo isset($settings['layout_no']) ? $settings['layout_no'] : ''; ?>"><?php echo (!empty($settings['button_title'])) ? $settings['button_title'] : 'Order Now'; ?></a>
		</div>
		<?php
			
	}

}