<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

/**
 * Elementor hostiko-vps Widget.
 *
 * Elementor widget that uses the hostiko-vps control.
 *
 * @since 1.0.0
 */
class Elementor_Hostiko_Vps_Widget extends \Elementor\Widget_Base {

	/**
	 * Get widget name.
	 *
	 * Retrieve hostiko-vps widget name.
	 *
	 * @since 1.0.0
	 * @access public
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'hostiko-vps';
	}
	/**
	 * Get widget title.
	 *
	 * Retrieve hostiko-vps widget title.
	 *
	 * @since 1.0.0
	 * @access public
	 * @return string Widget title.
	 */
	public function get_title() {
		return esc_html__( 'Hostiko Vps Slider', 'hostiko-toolkit' );
	}

	/**
	 * Get widget icon.
	 *
	 * Retrieve master-nav-menu widget icon.
	 *
	 * @since 1.0.0
	 * @access public
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'eicon-code';
	}

	/**
	 * Register hostiko-vps widget controls.
	 *
	 * Add input fields to allow the user to customize the widget settings.
	 *
	 * @since 1.0.0
	 * @access protected
	 */
	protected function register_controls() {
        // Content Tab Controls Start
        $this->start_controls_section(
			'content_section',
			[
				'label' => esc_html__( 'Content', 'hostiko-toolkit' ),
				'type' => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);
		
        $this->add_control(
			'vps_currency',
			[
				'label' => __( 'Enter You Currency', 'hostiko-toolkit' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => __( '$', 'hostiko-toolkit' ),
				'placeholder' => __( 'Enter Your Currency Symbol', 'hostiko-toolkit' ),
			]
		);

        $this->add_control(
            'vps_defualt_position',
            [
                'label' => __( 'Enter You Default Position', 'hostiko-toolkit' ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => __( '2', 'hostiko-toolkit' ),
            ]
        );
		// button text control inside Vps slider content section
        $this->add_control(
			'vps_btn_txt',
			[
				'label' => __( 'Order Button Text', 'hostiko-toolkit' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => __( 'Order Now', 'hostiko-toolkit' ),
				'placeholder' => __( 'Enter Your Custom Order Button Text', 'hostiko-toolkit' ),
			]
		);
		// //price period control inside Vps slider content section
        $this->add_control(
			'vps_period_text',
			[
				'label' => __( 'Enter Your price period', 'hostiko-toolkit' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => __( 'month', 'hostiko-toolkit' ),
				'placeholder' => __( 'Enter Your price period', 'hostiko-toolkit' ),
			]
		);
		$this->add_control(
			'vps_period_separator',
				[
					'label' => __( 'Enter Your price separator', 'hostiko-toolkit' ),
					'type' => \Elementor\Controls_Manager::TEXT,
					'default' => __( '/', 'hostiko-toolkit' ),
					'placeholder' => __( 'Enter Your price period', 'hostiko-toolkit' ),
				]
			);
			$this->add_control(
				'vps_bottom_note',
				[
					'label' => esc_html__( 'Note', 'hostiko-toolkit' ),
					'type' => \Elementor\Controls_Manager::WYSIWYG,
					'default' => esc_html__( 'Need a little boost? You can add additional RAM, CPUs, Storage Space or Dedicated IPs, as you’re checking out.', 'hostiko-toolkit' ),
					'placeholder' => esc_html__( 'Type your description here', 'hostiko-toolkit' ),
				]
			);
		
		
		// //option 1 title control
		$this->add_control(
			'opt1name',
			[
				'label' => __( 'CPU Title', 'hostiko-toolkit' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => __( 'CPU Core', 'hostiko-toolkit' ),
				'placeholder' => __( 'Enter Value', 'hostiko-toolkit' ),
			]
		);
		// //option 1 choose icon control
        $this->add_control(
			'image1url',
			[
				'label' => esc_html__( 'Choose Image', 'hostiko-toolkit' ),
				'type' => \Elementor\Controls_Manager::MEDIA,
				'default' => [
					'url' => plugins_url('../../' ,__FILE__) . 'assets/img/core-image.png',
				],
			]
		);
		// 	//option 2 title control
        $this->add_control(
			'opt2name',
			[
				'label' => __( 'Memory Title', 'hostiko-toolkit' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => __( 'Memory', 'hostiko-toolkit' ),
				'placeholder' => __( 'Enter Value', 'hostiko-toolkit' ),
			]
		);
		// 	//option 2 choose icon control
        $this->add_control(
			'image2url',
			[
				'label' => esc_html__( 'Choose Image', 'hostiko-toolkit' ),
				'type' => \Elementor\Controls_Manager::MEDIA,
				'default' => [
					'url' => plugins_url('../../' ,__FILE__) . 'assets/img/memory-image.png',
				],
			]
		);
		// //option 3 title control
        $this->add_control(
			'opt3name',
			[
				'label' => __( 'Storage Title', 'hostiko-toolkit' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => __( 'Storage', 'hostiko-toolkit' ),
				'placeholder' => __( 'Enter Value', 'hostiko-toolkit' ),
			]
		);
		// 	//option 3 icon control
        $this->add_control(
			'image3url',
			[
				'label' => esc_html__( 'Choose Image', 'hostiko-toolkit' ),
				'type' => \Elementor\Controls_Manager::MEDIA,
				'default' => [
					'url' => plugins_url('../../' ,__FILE__) . 'assets/img/storage-image.png',
				],
			]
		);
        
		// //option 4 title control
        $this->add_control(
			'opt4name',
			[
				'label' => __( 'Bandwidth Title', 'hostiko-toolkit' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => __( 'Bandwidth', 'hostiko-toolkit' ),
				'placeholder' => __( 'Enter Value', 'hostiko-toolkit' ),
			]
		);
		// //option 4 icon control
        $this->add_control(
			'image4url',
			[
				'label' => esc_html__( 'Choose Image', 'hostiko-toolkit' ),
				'type' => \Elementor\Controls_Manager::MEDIA,
				'default' => [
					'url' => plugins_url('../../' ,__FILE__) . 'assets/img/bandwidth-image.png',
				],
			]
		);
        
		// //Padding min (number control)
		$this->add_control(
			'paddingMin',
			[
				'label' => __( 'Padding Min', 'hostiko-toolkit' ),
				'type' => \Elementor\Controls_Manager::NUMBER,
				'min' => 5,
				'max' => 10000,
				'step' => 5,
				'default' => 50,
			]
		);
		// //Max padding control
		$this->add_control(
			'paddingMax',
			[
				'label' => __( 'Padding Max', 'hostiko-toolkit' ),
				'type' => \Elementor\Controls_Manager::NUMBER,
				'min' => 5,
				'max' => 10000,
				'step' => 5,
				'default' => 80,
			]
		);
        $repeater = new \Elementor\Repeater();
        
        $repeater->add_control(
			'plan_name',
			[
				'label' => __( 'VPS Name', 'hostiko-toolkit' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => __( 'VPS 1', 'hostiko-toolkit' ),
				'placeholder' => __( 'Enter VPS Name', 'hostiko-toolkit' ),
			]
		);
		//plan price text control
        $repeater->add_control(
			'plan_price',
			[
				'label' => __( 'VPS Price', 'hostiko-toolkit' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => __( '89', 'hostiko-toolkit' ),
				'placeholder' => __( 'Enter VPS Price', 'hostiko-toolkit' ),
			]
		);
        $repeater->add_control(
			'decimal_price',
			[
				'label' => __( 'Decimal Price', 'hostiko-toolkit' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => __( '00', 'hostiko-toolkit' ),
				'placeholder' => __( 'Enter Post Decimal Price', 'hostiko-toolkit' ),
			]
		);
		
		//option1 value text control
        $repeater->add_control(
			'opt1value',
			[
				'label' => __( 'CPU value', 'hostiko-toolkit' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => __( '$53', 'hostiko-toolkit' ),
				'placeholder' => __( 'Enter Value', 'hostiko-toolkit' ),
			]
		);
		//option2 value text control
        $repeater->add_control(
			'opt2value',
			[
				'label' => __( 'Memory value', 'hostiko-toolkit' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => __( '$44', 'hostiko-toolkit' ),
				'placeholder' => __( 'Enter Value', 'hostiko-toolkit' ),
			]
		);
		//option3 value text control
        $repeater->add_control(
			'opt3value',
			[
				'label' => __( 'Storage value', 'hostiko-toolkit' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => __( '$76', 'hostiko-toolkit' ),
				'placeholder' => __( 'Enter Value', 'hostiko-toolkit' ),
			]
		);
		//option4 value text control
        $repeater->add_control(
			'opt4value',
			[
				'label' => __( 'Bandwidth value', 'hostiko-toolkit' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => __( '4 TB', 'hostiko-toolkit' ),
				'placeholder' => __( 'Enter Value', 'hostiko-toolkit' ),
			]
		);
        //Url control
        $repeater->add_control(
            'plan_order_link',
            [
                'label' => __( 'VPS Order Link', 'hostiko-toolkit' ),
                'type' => \Elementor\Controls_Manager::URL,
                'placeholder' => __( 'https://your-link.com', 'hostiko-toolkit' ),
                'show_external' => true,
                'default' => [
                    'url' => '',
                    'is_external' => true,
                    'nofollow' => true,
                ],
            ]
        );
        $this->add_control(
			'vps_plan_list',
			[
				'label' => __( 'Repeater List', 'hostiko-toolkit' ),
				'type' => \Elementor\Controls_Manager::REPEATER,
				'fields' => $repeater->get_controls(),
				'default' => [
					[
						'plan_name' => __('VPS 1', 'hostiko-toolkit' ),
						'plan_price'=>__('39', 'hostiko-toolkit' ),
						'opt1name'=>__('CPU Cores', 'hostiko-toolkit' ),
						'image1url'=> \Elementor\Utils::get_placeholder_image_src(),
						'opt2name'=>__('Memory', 'hostiko-toolkit' ),
						'image2url'=> \Elementor\Utils::get_placeholder_image_src(),
						'opt3name'=>__('Storage', 'hostiko-toolkit' ),
						'image3url'=> \Elementor\Utils::get_placeholder_image_src(),
						'opt4name'=>__('Bandwidth', 'hostiko-toolkit' ),
						'image4url'=> \Elementor\Utils::get_placeholder_image_src(),
						'opt1value'=>__('2 Cores', 'hostiko-toolkit'),
						'opt2value'=>__('2048 MB', 'hostiko-toolkit'),
						'opt3value'=>__('30 GB', 'hostiko-toolkit'),
						'opt4value'=>__('2 TB', 'hostiko-toolkit'),
						'plan_order_link'=>__('https://your-link.com', 'hostiko-toolkit'),
					],
					[
						'plan_name' => __('VPS 2', 'hostiko-toolkit' ),
						'plan_price'=>__('59', 'hostiko-toolkit' ),
						'opt1name'=>__('CPU Cores', 'hostiko-toolkit' ),
						'image1url'=> \Elementor\Utils::get_placeholder_image_src(),
						'opt2name'=>__('Memory', 'hostiko-toolkit' ),
						'image2url'=> \Elementor\Utils::get_placeholder_image_src(),
						'opt3name'=>__('Storage', 'hostiko-toolkit' ),
						'image3url'=> \Elementor\Utils::get_placeholder_image_src(),
						'opt4name'=>__('Bandwidth', 'hostiko-toolkit' ),
						'image4url'=> \Elementor\Utils::get_placeholder_image_src(),
						'opt1value'=>__('4 Cores', 'hostiko-toolkit'),
						'opt2value'=>__('4096 MB', 'hostiko-toolkit'),
						'opt3value'=>__('40 GB', 'hostiko-toolkit'),
						'opt4value'=>__('4 TB', 'hostiko-toolkit'),
						'plan_order_link'=>__('https://your-link.com', 'hostiko-toolkit'),
					],
					[
						'plan_name' => __('VPS 3', 'hostiko-toolkit' ),
						'plan_price'=>__('69', 'hostiko-toolkit' ),
						'opt1name'=>__('CPU Cores', 'hostiko-toolkit' ),
						'image1url'=> \Elementor\Utils::get_placeholder_image_src(),
						'opt2name'=>__('Memory', 'hostiko-toolkit' ),
						'image2url'=> \Elementor\Utils::get_placeholder_image_src(),
						'opt3name'=>__('Storage', 'hostiko-toolkit' ),
						'image3url'=> \Elementor\Utils::get_placeholder_image_src(),
						'opt4name'=>__('Bandwidth', 'hostiko-toolkit' ),
						'image4url'=> \Elementor\Utils::get_placeholder_image_src(),
						'opt1value'=>__('8 Cores', 'hostiko-toolkit'),
						'opt2value'=>__('1 TB', 'hostiko-toolkit'),
						'opt3value'=>__('50 GB', 'hostiko-toolkit'),
						'opt4value'=>__('6 TB', 'hostiko-toolkit'),
						'plan_order_link'=>__('https://your-link.com', 'hostiko-toolkit'),
					],
					[
						'plan_name' => __('VPS 4', 'hostiko-toolkit' ),
						'plan_price'=>__('79', 'hostiko-toolkit' ),
						'opt1name'=>__('CPU Cores', 'hostiko-toolkit' ),
						'image1url'=> \Elementor\Utils::get_placeholder_image_src(),
						'opt2name'=>__('Memory', 'hostiko-toolkit' ),
						'image2url'=> \Elementor\Utils::get_placeholder_image_src(),
						'opt3name'=>__('Storage', 'hostiko-toolkit' ),
						'image3url'=> \Elementor\Utils::get_placeholder_image_src(),
						'opt4name'=>__('Bandwidth', 'hostiko-toolkit' ),
						'image4url'=> \Elementor\Utils::get_placeholder_image_src(),
						'opt1value'=>__('12 Cores', 'hostiko-toolkit'),
						'opt2value'=>__('2 TB', 'hostiko-toolkit'),
						'opt3value'=>__('60 GB', 'hostiko-toolkit'),
						'opt4value'=>__('8 TB', 'hostiko-toolkit'),
						'plan_order_link'=>__('https://your-link.com', 'hostiko-toolkit'),
					],
					[
						'plan_name' => __('VPS 5', 'hostiko-toolkit' ),
						'plan_price'=>__('89', 'hostiko-toolkit' ),
						'opt1name'=>__('CPU Cores', 'hostiko-toolkit' ),
						'image1url'=> \Elementor\Utils::get_placeholder_image_src(),
						'opt2name'=>__('Memory', 'hostiko-toolkit' ),
						'image2url'=> \Elementor\Utils::get_placeholder_image_src(),
						'opt3name'=>__('Storage', 'hostiko-toolkit' ),
						'image3url'=> \Elementor\Utils::get_placeholder_image_src(),
						'opt4name'=>__('Bandwidth', 'hostiko-toolkit' ),
						'image4url'=> \Elementor\Utils::get_placeholder_image_src(),
						'opt1value'=>__('16 Cores', 'hostiko-toolkit'),
						'opt2value'=>__('4 TB', 'hostiko-toolkit'),
						'opt3value'=>__('80 GB', 'hostiko-toolkit'),
						'opt4value'=>__('10 TB', 'hostiko-toolkit'),
						'plan_order_link'=>__('https://your-link.com', 'hostiko-toolkit'),
					],
				],
				//'heading_field' => '{{{ list_heading }}}',
                'title_field' => '{{{ plan_name }}}',
			]
			
		);
		$this->add_control(
            'warning_text',
            [
                'type' => 'raw_html',
                'label' => ' <strong>Note:</strong> We recomend you to add not more than five VPS plans.',
                'content' => '<input type="text" value="This is a warning message" disabled>',
            ]
        );
        //custom code (code control)
		$this->add_control(
			'custom_css',
			[
				'label' => __( 'Custom Code', 'hostiko-toolkit' ),
				'type' => \Elementor\Controls_Manager::CODE,
				'language' => 'html',
				'rows' => 20,
			]
		);
        $this->end_controls_section();
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
				
			// Style Tab Controls Start
			//Slider controls
			$this->start_controls_section(
				'vps_container_style',
				[
					'label' => __('VPS Container', 'hostiko-toolkit' ),
					'tab' => \Elementor\Controls_Manager::TAB_STYLE,
				]
			);

			$this->add_responsive_control(
				'vps_container_padding',
				[
					'label' => esc_html__( 'Padding', 'hostiko-toolkit' ),
					'type' => \Elementor\Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
					'selectors' => [
						'{{WRAPPER}} .hostiko_vps_section' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);
			$this->add_responsive_control(
				'vps_container_margin',
				[
					'label' => esc_html__( 'Margin', 'hostiko-toolkit' ),
					'type' => \Elementor\Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
					'selectors' => [
						'{{WRAPPER}} .hostiko_vps_section' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);
			
			$this->add_group_control(
				\Elementor\Group_Control_Background::get_type(),
				[
					'name' => 'vps_container_bg',
					'types' => [ 'classic', 'gradient' ],
					'selector' => '{{WRAPPER}} .hostiko_vps_section .vps_content .vps_upper_content',
				]
			);
			

			$this->add_group_control(
				\Elementor\Group_Control_Border::get_type(),
				[
					'name' => 'vps_container_border',
					'selector' => '{{WRAPPER}} .hostiko_vps_section .vps_content .vps_upper_content',
				]
			);

			$this->add_responsive_control(
				'vps_container_border_radius',
				[
					'label' => __( 'Border Radius', 'hostiko-toolkit' ),
					'type' => \Elementor\Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%', 'em' ],
					'selectors' => [
						'{{WRAPPER}} .hostiko_vps_section .vps_content .vps_upper_content' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
						
					],
					
				]
			);

			$this->add_group_control(
				\Elementor\Group_Control_Box_Shadow::get_type(),
				[
					'name' => 'vps_containe_box_shadow',
					'selector' => '{{WRAPPER}} .hostiko_vps_section .vps_content',
				]
			);
			
		$this->end_controls_section();

		//////////////////////////////////////////////////////////////////////////////////////////////////
        /////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		
        // Style Tab Controls Start
		//Slider controls
		$this->start_controls_section(
			'slider_style',
			[
				'label' => __('Slider Style', 'hostiko-toolkit' ),
				'tab' => \Elementor\Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_control(
            'vps_slider_title_color',
            [
                'label' => esc_html__( 'Item Colors', 'hostiko-toolkit' ),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .hostiko_vps_section .vps_content .vps_upper_content .progress_content .progress_box span' => 'color: {{VALUE}}',
                ],
                'global' => [
                    'default' => \Elementor\Core\Kits\Documents\Tabs\Global_Colors::COLOR_PRIMARY,
                ],
            ]
        );
		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name' => 'vps_slider_title_typography',
				'selector' => '{{WRAPPER}} .hostiko_vps_section .vps_content .vps_upper_content .progress_content .progress_box span',
			]
		);
		$this->add_responsive_control(
			'sliderbox_padding',
			[
				'label' => esc_html__( 'Padding', 'hostiko-toolkit' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
				'selectors' => [
					'{{WRAPPER}} .hostiko_vps_section .slider_node_outter' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);
		$this->add_responsive_control(
			'sliderbox_margin',
			[
				'label' => esc_html__( 'Margin', 'hostiko-toolkit' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
				'selectors' => [
					'{{WRAPPER}} .hostiko_vps_section .slider_node_outter' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);
		
		$this->add_group_control(
			\Elementor\Group_Control_Background::get_type(),
			[
				'name' => 'slide_bg',
				'types' => [ 'classic', 'gradient' ],
				'selector' => '{{WRAPPER}} .hostiko_vps_section .slider_node_outter',
			]
		);
		

		$this->add_responsive_control(
			'slider_bar_border_radius',
			[
				'label' => __( 'Border Radius', 'hostiko-toolkit' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'selectors' => [
					'{{WRAPPER}} .hostiko_vps_section .slider_node_outter #slider, .hostiko_vps_section .slider_node_outter #slider .ui-slider-range' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    
				],
                
			]
		);

		$this->add_control(
			'slider_img',
			[
				'label' => esc_html__( 'Slider Handle Icon', 'hostiko-toolkit' ),
				'type' => \Elementor\Controls_Manager::MEDIA,
				'default' => [
					'url' => plugins_url('../../' ,__FILE__) . 'assets/img/progress-circle.png',
				],
			]
		);


		$this->start_controls_tabs(
			'style_tabs'
		);
			$this->start_controls_tab(
				'style_normal_tab',
				[
					'label' => esc_html__( 'Normal', 'hostiko-toolkit' ),
				]
			);

			$this->add_group_control(
				\Elementor\Group_Control_Background::get_type(),
				[
					'name' => 'slide_background',
					'label' => esc_html__( 'Slider Icon', 'hostiko-toolkit' ),
					'types' => [ 'classic', 'gradient' ],
					'selector' => '{{WRAPPER}} .hostiko_vps_section #slider',
				]
			);

			$this->end_controls_tab();

			$this->start_controls_tab(
				'style_active_tab',
				[
					'label' => esc_html__( 'Active', 'hostiko-toolkit' ),
				]
			);
			$this->add_group_control(
				\Elementor\Group_Control_Background::get_type(),
				[
					'name' => 'slide_active_background',
					'types' => [ 'classic', 'gradient' ],
					'selector' => '{{WRAPPER}} .hostiko_vps_section .ui-widget-header',
				]
			);
			$this->end_controls_tab();

		$this->end_controls_tabs();
		
		
	$this->end_controls_section();

	
	/////////////////////////////////////////////////////////////////////
	$this->start_controls_section(
		'options_style',
		[
			'label' => __('Options Style', 'hostiko-toolkit' ),
			'tab' => \Elementor\Controls_Manager::TAB_STYLE,
		]
	);

	$this->add_responsive_control(
		'options_padding',
		[
			'label' => esc_html__( 'Padding', 'hostiko-toolkit' ),
			'type' => \Elementor\Controls_Manager::DIMENSIONS,
			'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
			'selectors' => [
				'{{WRAPPER}} .hostiko_vps_section .vps_content .vps_upper_content .progress_content .content_box' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
			],
		]
	);
	$this->add_responsive_control(
		'options_margin',
		[
			'label' => esc_html__( 'Margin', 'hostiko-toolkit' ),
			'type' => \Elementor\Controls_Manager::DIMENSIONS,
			'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
			'selectors' => [
				'{{WRAPPER}} .hostiko_vps_section .vps_content .vps_upper_content .progress_content .content_box' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
			],
		]
	);
	
	$this->add_group_control(
		\Elementor\Group_Control_Background::get_type(),
		[
			'name' => 'options_bg',
			'types' => [ 'classic', 'gradient' ],
			'selector' => '{{WRAPPER}} .hostiko_vps_section .vps_content .vps_upper_content .progress_content .content_box',
		]
	);
	
	

	$this->add_group_control(
		\Elementor\Group_Control_Border::get_type(),
		[
			'name' => 'options_border',
			'selector' => '{{WRAPPER}} .hostiko_vps_section .vps_content .vps_upper_content .progress_content .content_box',
		]
	);

	$this->add_responsive_control(
		'options_border_radius',
		[
			'label' => __( 'Border Radius', 'hostiko-toolkit' ),
			'type' => \Elementor\Controls_Manager::DIMENSIONS,
			'size_units' => [ 'px', '%', 'em' ],
			'selectors' => [
				'{{WRAPPER}} .hostiko_vps_section .vps_content .vps_upper_content .progress_content .content_box' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				
			],
			
		]
	);
	$this->add_group_control(
		\Elementor\Group_Control_Box_Shadow::get_type(),
		[
			'name' => 'options_Style_box_shadow',
			'selector' => '{{WRAPPER}} .hostiko_vps_section .vps_content .vps_upper_content .progress_content .content_box',
		]
	);
	$this->end_controls_section();
	
	///////////////////////////////////////////////////	
	// Heading Controls Start
		$this->start_controls_section(
            'vps_heading_setting',
            [
                'label' => esc_html__( 'Option Heading', 'hostiko-toolkit' ),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_responsive_control(
			'vps_heading_padding',
			[
				'label' => esc_html__( 'Padding', 'hostiko-toolkit' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
				'selectors' => [
					'{{WRAPPER}} .hostiko_vps_section .vps_content .vps_upper_content .progress_content .content_box span' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);
        $this->add_responsive_control(
			'vps_heading_margin',
			[
				'label' => esc_html__( 'Margin', 'hostiko-toolkit' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
				'selectors' => [
					'{{WRAPPER}} .hostiko_vps_section .vps_content .vps_upper_content .progress_content .content_box span' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);
		$this->add_control(
            'vps_heading_color',
            [
                'label' => esc_html__( ' Color', 'hostiko-toolkit' ),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .hostiko_vps_section .vps_content .vps_upper_content .progress_content .content_box span' => 'color: {{VALUE}}',
                ],
                'global' => [
                    'default' => \Elementor\Core\Kits\Documents\Tabs\Global_Colors::COLOR_TEXT,
                ],
            ]
        );
        $this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name' => 'vps_heading_typography',
				'selector' => '{{WRAPPER}} .hostiko_vps_section .vps_content .vps_upper_content .progress_content .content_box span',
			]
		);
		$this->end_controls_section();
	
		////////////////////////////////////////////////////////////////////////////////////////////

		// Value Controls Start
		$this->start_controls_section(
            'vps_value_setting',
            [
                'label' => esc_html__( 'Option Value', 'hostiko-toolkit' ),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_responsive_control(
			'vps_value_padding',
			[
				'label' => esc_html__( 'Padding', 'hostiko-toolkit' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
				'selectors' => [
					'{{WRAPPER}} .hostiko_vps_section .vps_content .vps_upper_content .featured_price_content h4' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);
        $this->add_responsive_control(
			'vps_value_margin',
			[
				'label' => esc_html__( 'Margin', 'hostiko-toolkit' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
				'selectors' => [
					'{{WRAPPER}} .hostiko_vps_section .vps_content .vps_upper_content .featured_price_content h4' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);
		$this->add_control(
            'vps_value_color',
            [
                'label' => esc_html__( ' Color', 'hostiko-toolkit' ),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .hostiko_vps_section .vps_content .vps_upper_content .featured_price_content h4' => 'color: {{VALUE}}',
                ],
                'global' => [
                    'default' => \Elementor\Core\Kits\Documents\Tabs\Global_Colors::COLOR_TEXT,
                ],
            ]
        );
        $this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name' => 'vps_value_typography',
				'selector' => '{{WRAPPER}} .hostiko_vps_section .vps_content .vps_upper_content .featured_price_content h4',
			]
		);
		$this->end_controls_section();
	
		////////////////////////////////////////////////////////////////////////////////////////////
		
		// Price Controls Start
        $this->start_controls_section(
            'vps_price_setting',
            [
                'label' => esc_html__( 'Price', 'hostiko-toolkit' ),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_responsive_control(
			'vps_price_padding',
			[
				'label' => esc_html__( 'Padding', 'hostiko-toolkit' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
				'selectors' => [
					'{{WRAPPER}} .hostiko_vps_section .vps_content .vps_upper_content .progress_content .button .price_outter .price' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);
		$this->add_control(
            'vps_price_color',
            [
                'label' => esc_html__( 'Price Color', 'hostiko-toolkit' ),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .hostiko_vps_section .vps_content .vps_upper_content .progress_content .button .price_outter .price' => 'color: {{VALUE}}',
                ],
                'global' => [
                    'default' => \Elementor\Core\Kits\Documents\Tabs\Global_Colors::COLOR_PRIMARY,
                ],
            ]
        );
        $this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name' => 'vps_price_typography',
				'selector' => '{{WRAPPER}} .hostiko_vps_section .vps_content .vps_upper_content .progress_content .button .price_outter .price',
			]
		);
		$this->add_control(
            'vps_prefix_color',
            [
                'label' => esc_html__( 'Price Duration Color', 'hostiko-toolkit' ),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .hostiko_vps_section .vps_content .vps_upper_content .progress_content .button .price_outter' => 'color: {{VALUE}}',
                ],
                'global' => [
                    'default' => \Elementor\Core\Kits\Documents\Tabs\Global_Colors::COLOR_PRIMARY,
                ],
            ]
        );
        $this->end_controls_section();
		// Price Controls End

		/////////////////////////////////////////////////////////////////////
		$this->start_controls_section(
			'note_style',
			[
				'label' => __('Note Style', 'hostiko-toolkit' ),
				'tab' => \Elementor\Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_control(
            'vps_note_color',
            [
                'label' => esc_html__( ' Color', 'hostiko-toolkit' ),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .hostiko_vps_section .vps_content .text' => 'color: {{VALUE}}',
                ],
                'global' => [
                    'default' => \Elementor\Core\Kits\Documents\Tabs\Global_Colors::COLOR_TEXT,
                ],
            ]
        );
        $this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name' => 'vps_note_typography',
				'selector' => '{{WRAPPER}} .hostiko_vps_section .vps_content .text',
			]
		);
		$this->add_responsive_control(
			'note_padding',
			[
				'label' => esc_html__( 'Padding', 'hostiko-toolkit' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
				'selectors' => [
					'{{WRAPPER}} .hostiko_vps_section .vps_content' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);
		$this->add_responsive_control(
			'note_margin',
			[
				'label' => esc_html__( 'Margin', 'hostiko-toolkit' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
				'selectors' => [
					'{{WRAPPER}} .hostiko_vps_section .vps_content' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);
		
		$this->add_group_control(
			\Elementor\Group_Control_Background::get_type(),
			[
				'name' => 'note_bg',
				'types' => [ 'classic', 'gradient' ],
				'selector' => '{{WRAPPER}} .hostiko_vps_section .vps_content',
			]
		);
		
		

		$this->add_group_control(
			\Elementor\Group_Control_Border::get_type(),
			[
				'name' => 'note_border',
				'selector' => '{{WRAPPER}} .hostiko_vps_section .vps_content',
			]
		);

		$this->add_responsive_control(
			'note_border_radius',
			[
				'label' => __( 'Border Radius', 'hostiko-toolkit' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'selectors' => [
					'{{WRAPPER}} .hostiko_vps_section .vps_content' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					
				],
				
			]
		);
		
		$this->end_controls_section();
		
        
		/////////////////////////////////////////////////////////////////////////////////////////////
		//Button Style Control

		$this->start_controls_section(
			'button_style',
				[
					'label' => __('Button Style', 'hostiko-toolkit' ),
					'tab' => \Elementor\Controls_Manager::TAB_STYLE,
				]
			);
			$this->add_group_control(
				\Elementor\Group_Control_Typography::get_type(),
				[
					'name' => 'order_button_typography',
					'selector' => '{{WRAPPER}} .hostiko_vps_section .vps_content .vps_upper_content .progress_content .button .buy_now',
				]
			);
			
			$this->add_responsive_control(
				'order_button_padding',
				[
					'label' => esc_html__( 'Padding', 'hostiko-toolkit' ),
					'type' => \Elementor\Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
					'selectors' => [
						'{{WRAPPER}} .hostiko_vps_section .vps_content .vps_upper_content .progress_content .button .buy_now' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);

			$this->add_responsive_control(
				'order_button_margin',
				[
					'label' => esc_html__( 'Margin', 'hostiko-toolkit' ),
					'type' => \Elementor\Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
					'selectors' => [
						'{{WRAPPER}} .hostiko_vps_section .vps_content .vps_upper_content .progress_content .button .buy_now' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);

			$this->start_controls_tabs(
				'style_order_tabs'
			);
				$this->start_controls_tab(
					'style_order_normal_tab',
						[
							'label' => esc_html__( 'Normal', 'hostiko-toolkit' ),
						]
					);

					$this->add_control(
						'vps_button_color',
						[
							'label' => __( 'Color', 'hostiko-toolkit' ),
							'type' => \Elementor\Controls_Manager::COLOR,
							'selectors' => [
								'{{WRAPPER}} .hostiko_vps_section .vps_content .vps_upper_content .progress_content .button .buy_now' => 'color: {{VALUE}}',
							],
						]
					);
			
					$this->add_group_control(
						\Elementor\Group_Control_Background::get_type(),
						[
							'name' => 'vps_btn_background',
							'types' => [ 'classic', 'gradient', 'video' ],
							'selector' => '{{WRAPPER}} .hostiko_vps_section .vps_content .vps_upper_content .progress_content .button .buy_now',
						]
					);

					
					$this->add_group_control(
						\Elementor\Group_Control_Border::get_type(),
						[
							'name' => 'vps_btn_border',
							'selector' => '{{WRAPPER}} .slider_price_box .vps_btn',
						]
					);


					$this->add_responsive_control(
						'vps_btn_border_radius',
						[
							'label' => esc_html__( 'Border Radius', 'elementor' ),
							'type' => \Elementor\Controls_Manager::DIMENSIONS,
							'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
							'selectors' => [
								'{{WRAPPER}} .hostiko_vps_section .vps_content .vps_upper_content .progress_content .button .buy_now' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
							],
						]
					);
				$this->end_controls_tab();

				$this->start_controls_tab(
					'style_order_hover_tab',
					[
						'label' => esc_html__( 'Hover', 'hostiko-toolkit' ),
					]
				);
				$this->add_control(
					'vps_button_color_hover',
					[
						'label' => __( 'Color', 'hostiko-toolkit' ),
						'type' => \Elementor\Controls_Manager::COLOR,
						'selectors' => [
							'{{WRAPPER}} .hostiko_vps_section .vps_content .vps_upper_content .progress_content .button .buy_now:hover' => 'color: {{VALUE}}',
						],
					]
				);
				
				$this->add_group_control(
					\Elementor\Group_Control_Background::get_type(),
					[
						'name' => 'vps_btn_hover_background',
						'types' => [ 'classic', 'gradient'],
						'selector' => '{{WRAPPER}} .hostiko_vps_section .vps_content .vps_upper_content .progress_content .button .buy_now:hover',
					]
				);

				$this->add_group_control(
					\Elementor\Group_Control_Border::get_type(),
					[
						'name' => 'vps_btn_hover_border',
						'selector' => '{{WRAPPER}} .hostiko_vps_section .vps_content .vps_upper_content .progress_content .button .buy_now:hover',
					]
				);


				$this->add_responsive_control(
					'order_button_hover_border_radius',
					[
						'label' => esc_html__( 'Border Radius', 'elementor' ),
						'type' => \Elementor\Controls_Manager::DIMENSIONS,
						'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
						'selectors' => [
							'{{WRAPPER}} .hostiko_vps_section .vps_content .vps_upper_content .progress_content .button .buy_now:hover' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
						],
					]
				);
				$this->end_controls_tab();
			$this->end_controls_tabs();
			

		$this->end_controls_section();

		///////////////////////////////////////////////////////////////////////////////////
	}
	
	/**
	 * Render hostiko-vps widget output on the frontend.
	 *
	 * Written in PHP and used to generate the final HTML.
	 *
	 * @since 1.0.0
	 * @access protected
	 */
	protected function render() {
		$settings = $this->get_settings_for_display();
        //echo 'settings: <pre>' . print_r($settings, true) . '</pre>';
		?>
		<section class="hostiko_vps_section vps_show_coupon">
			
			<div class="vps_content">
				<div class="vps_upper_content">
					<div class="progress_content">
						<div class="slider_node_outter">
							<div class="slider_node progress-image">
								<div class="price-slider-section">
									<div class="sliderbox">
										<div id="slider"></div>
										<!--sliderbox-->
									</div>
									<div class="clear"></div>
								</div>
							</div>
							<ul class="list-unstyled progress_box">
								<?php 
								foreach($settings['vps_plan_list'] as $key=>$item)
								{
									if($key<15)
										{
										?>
										<li id="icon-<?php echo $key?>" class="icon"><span class="vps"><?=$item['plan_name']?></span></li>
										<?php
										$count=$key+1;
										}
								}
								?>
							</ul>
						</div>
				
						<ul class="list-unstyled content_box">
							
								<li id="cpu_val" class="featured_price_content top-content left-content">
									<div class="inner_price_content content">
										<!-- <div class="image_holder"></div> -->
										<figure class="mb-0 content-icon"><img alt="" class="img-fluid" src="<?=$settings['image1url']['url']?>"> </figure>
										<span class="mb-0 text-size-14"><?=$settings['opt1name']?></span>
										<!-- <div class="value_text "><h5 class="option_heading"><?=$settings['opt1name']?></h5> <span class="value"></span>  </div> -->
									</div>
									<h4 class="mb-0 value"></h4>
									<!--smallbox-->
								</li>
								<li id="ram_val" class="featured_price_content top-content right-content">
									<div class="inner_price_content content">
										<!-- <div class="image_holder"></div> -->
										<figure class="mb-0 content-icon"><img alt="" class="img-fluid" src="<?=$settings['image2url']['url']?>"> </figure>
										<span class="mb-0 text-size-14"><?=$settings['opt2name']?></span>
										<!-- <div class="value_text "><h5 class="option_heading">< ?=$settings['opt2name']?></h5> <span class="value"></span></div> -->
									</div>
									<h4 class="mb-0 value"></h4>
									<!--smallbox-->
								</li>
								<li id="hdd_val" class="featured_price_content left-content">
									<div class="inner_price_content content">
										<!-- <div class="image_holder"></div> -->
										<figure class="mb-0 content-icon"><img alt="" class="img-fluid" src="<?=$settings['image3url']['url']?>"> </figure>
										<span class="mb-0 text-size-14"><?=$settings['opt3name']?></span>
										<!-- <div class="value_text vps_show_coupon"><h5 class="option_heading">< ?=$settings['opt3name']?></h5> <span class="value"></span> </div> -->
									</div>
									<h4 class="mb-0 value"></h4>
									<!--smallbox-->
								</li>
								<li id="bandwidth_val" class="featured_price_content right-content">
									<div class="inner_price_content vps_show_coupon content">
										<!-- <div class="image_holder vps_show_coupon"></div> -->
										<figure class="mb-0 content-icon"><img alt="" class="img-fluid" src="<?=$settings['image4url']['url']?>"> </figure>
										<span class="mb-0 text-size-14"><?=$settings['opt4name']?></span>
										<!-- <div class="value_text vps_show_coupon"><h5 class="option_heading">< ?=$settings['opt4name']?></h5> <span class="value"></span> </div> -->
									</div>
									<h4 class="mb-0 value"></h4>
									<!--smallbox-->
								</li>
							</ul>
							<div class="vps_show_coupon slider_price_box">
								
								<div class="button_outter button">
									<div class="price_outter d-inline-block"><?php echo esc_html__('Only', 'hostiko-toolkit')?><div class="price_inner d-inline-block"><span class="price"><?php echo $settings['vps_currency'] ?></span><span id="price_val" class="price numeric1"></span><span id="decimal_val" class="price decimal decimal1"></span></div><span class="period_separator"><?=$settings['vps_period_separator']?></span><span class="duration"><?php echo $settings['vps_period_text'] ?></span></div>
									<div class="d-inline-block"><a href="#" class="buy_now text-decoration-none"><?=$settings['vps_btn_txt']?></a></div>
								</div>
								
							</div>
						
					</div>
					
				</div>
				<div class= "text text-size-14 mb-0"><?=$settings['vps_bottom_note']?></div>
			</div>
					
			
			<?php
			$value1= $value2=  $value3= $value4= $pln_price= $pln_order_link= array();
			$slider_img = $settings['slider_img']['url'];
			foreach($settings['vps_plan_list'] as $items)
			{
				$value1[]=$items['opt1value'];
				$value2[]=$items['opt2value'];
				$value3[]=$items['opt3value'];
				$value4[]=$items['opt4value'];
				$pln_price[]=$items['plan_price'];
				$decimal_price[]=$items['decimal_price'];
				$pln_order_link[]=$items['plan_order_link']['url'];
			}
			
			//echo 'pln_price: <pre>' . print_r($pln_price, true) . '</pre>';
			?>
		</section>
        
		<script >
			var slider_handel_img = "<?= $slider_img ?>";

			var cpu_arr = new Array(<?php echo  "'" . implode ( "', '", $value1 ) . "'";?>);
			var ram_arr = new Array(<?php echo "'" . implode ( "', '", $value2 ) . "'";?>);
			var hdd_arr = new Array(<?php echo "'" . implode ( "', '", $value3 ) . "'";?>);
			var bandwidth_arr = new Array(<?php echo "'" . implode ( "', '", $value4 ) . "'";?>);
			var ip_arr = new Array('3 IPs', '5 IPs', '7 IPs', '9 IPs', 'Unlimited')
			var price_arr = new Array(<?php echo "'" . implode ( "', '", $pln_price ) . "'";?>);
			var decimal_arr = new Array(<?php echo "'" . implode ( "', '", $decimal_price ) . "'";?>);
			var link_arr = new Array('$10', '$25', '$50', '$75', '$100', '$125');
			var b_url = new Array(<?php echo "'" . implode ( "', '", $pln_order_link ) . "'";?>);
			var def_pos = <?= $settings['vps_defualt_position'] ?>;
				jQuery(document).ready(function() {
					
					jQuery("#slider").slider({
					range: 'min',
					animate: true,
					min: 1,
					max: <?php echo $count;?>,
					paddingMin: <?=$settings['paddingMin']?>,
					paddingMax: <?=$settings['paddingMax']?>,
					change: function(event, ui) {
						jQuery('.hostiko_vps_section #cpu_val h4.value').html(cpu_arr[ui.value - 1]);
						jQuery('.hostiko_vps_section #ram_val h4.value').html(ram_arr[ui.value - 1]);
						jQuery('.hostiko_vps_section #hdd_val h4.value').html(hdd_arr[ui.value - 1]);
						jQuery('.hostiko_vps_section #bandwidth_val h4.value').html(bandwidth_arr[ui.value - 1]);
						jQuery('.hostiko_vps_section #ip_val h4.value').html(ip_arr[ui.value - 1]);
						jQuery('.hostiko_vps_section #price_val').html(price_arr[ui.value - 1]);
						jQuery('.hostiko_vps_section #decimal_val').html("."+decimal_arr[ui.value - 1]);
						jQuery('.hostiko_vps_section a.buy_now').attr('href', b_url[ui.value - 1]);
						jQuery('.hostiko_vps_section div.price_rangetxt div#icon-' + (ui.value - 1)).addClass("current");
						jQuery('.hostiko_vps_section #sub-heading-' + (ui.value - 1)).addClass("current1");

					}
				});
				jQuery("#amount").val("$" + jQuery("#slider").slider("value"));
				jQuery('#slider').slider('value', def_pos);
				jQuery('.icon').click(function() {
					ch_value = parseInt(this.id.slice(5)) + 1;
					jQuery(".hostiko_vps_section div.price_rangetxt div").removeClass("current");
					jQuery(".hostiko_vps_section .heading div").removeClass("current1");
					jQuery('#slider').slider('value', ch_value);
				});
				
				if(slider_handel_img != ""){
					jQuery(document).find(".ui-slider-handle").css("background-image", "url(" + slider_handel_img + ")");
				}
				
			});

		</script>

        <?php
	}
}
