<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

/**
 * Elementor hostiko-testimonial Widget.
 *
 * Elementor widget that uses the hostiko-testimonial control.
 *
 * @since 1.0.0
 */
class Elementor_Hostiko_Testimonial_Widget extends \Elementor\Widget_Base {

	/**
	 * Get widget name.
	 *
	 * Retrieve hostiko-testimonial widget name.
	 *
	 * @since 1.0.0
	 * @access public
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'hostiko-testimonial';
	}

	/**
	 * Get widget title.
	 *
	 * Retrieve hostiko-testimonial widget title.
	 *
	 * @since 1.0.0
	 * @access public
	 * @return string Widget title.
	 */
	public function get_title() {
		return esc_html__( 'Hostiko Testimonial', 'hostiko-toolkit' );
	}

	/**
	 * Get widget icon.
	 *
	 * Retrieve hostiko-testimonial widget icon.
	 *
	 * @since 1.0.0
	 * @access public
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'eicon-carousel-loop';
	}

	/**
	 * Register hostiko-testimonial widget controls.
	 *
	 * Add input fields to allow the user to customize the widget settings.
	 *
	 * @since 1.0.0
	 * @access protected
	 */
	protected function register_controls() {

		$this->start_controls_section(
			'content_section',
			[
				'label' => esc_html__( 'Content', 'hostiko-toolkit' ),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);
		$repeater = new \Elementor\Repeater();
		$repeater->add_control(
			'list_content', [
				'label' => __( 'Content', 'hostiko-toolkit' ),
				'type' => \Elementor\Controls_Manager::WYSIWYG,
				'default' => __( 'Beatae vitae dicta sunt explicabo. Nemo enim ipsam voluptatem quia voluptas aspernatur aut odit aut fugit, sed. Beatae vitae dicta ripiscing elit, sed do euismod tempor incidunt. Labore et dolore magna aliqua ut enim ad minim adipiscing elit, sed do euismod tempor incidunt ut labore.' , 'hostiko-toolkit' ),
				'label_block' => true,
				'show_label' => false,
			]
		);
		$repeater->add_control(
			'list_username', [
				'label' => __( 'User Name', 'hostiko-toolkit' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => __( 'User Name' , 'hostiko-toolkit' ),
				'label_block' => true,
			]
		);
		$repeater->add_control(
			'list_designation', [
				'label' => __( 'Designation', 'hostiko-toolkit' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => __( 'Separtment' , 'hostiko-toolkit' ),
				'label_block' => true,
			]
		);
        $repeater->add_control(
			'list_image',
			[
				'label' => esc_html__( 'User Image', 'hostiko-toolkit' ),
				'label_block' => true,
				'type' => \Elementor\Controls_Manager::MEDIA,
				'default' => [
					'url' => PLUGIN_BASE_URI. 'assets/img/testimonial-user-img.png' ,
				],
			]
		);
		$this->add_control(
			'list',
			[
				'label' => __( 'Repeater List', 'hostiko-toolkit' ),
				'type' => \Elementor\Controls_Manager::REPEATER,
				'fields' => $repeater->get_controls(),
				'default' => [
					[
						'list_content' => __( 'Content', 'hostiko-toolkit' ),
						'list_username' => __( 'User Name', 'hostiko-toolkit' ),
						'list_designation' => __( 'Designation Name', 'hostiko-toolkit' ),
						'list_image' => __( 'User Image', 'hostiko-toolkit' ),
					],
					[
						'list_content' => __( 'Content', 'hostiko-toolkit' ),
						'list_username' => __( 'User Name', 'hostiko-toolkit' ),
						'list_designation' => __( 'Designation Name', 'hostiko-toolkit' ),
						'list_image' => __( 'User Image', 'hostiko-toolkit' ),
					],
				],
				'heading_field' => '{{{ list_heading }}}',
			]
		);
		
		
        $this->end_controls_section();
		////////////////////////////////////////////////  Container Style Start /////////////////////////////////////////////////
		$this->start_controls_section(
			'container_style_section',
			[
				'label' => esc_html__( 'Container Style', 'hostiko-toolkit' ),
				'tab' => \Elementor\Controls_Manager::TAB_STYLE,
			]
		);
        $slider_style = array('style 1','style 2', 'style 3');
		$slider_style = array_combine( $slider_style, $slider_style );
		$this->add_control(
			'hostiko_testimonial_style',
			[
				'label' => esc_html__( 'Testimonial Style', 'hostiko-toolkit' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'options' => [
					'' => esc_html__( 'Default', 'hostiko-toolkit' ),
				] + $slider_style,
			]
		);
		$this->add_responsive_control(
			'container_padding',
			[
				'label' => __( 'Padding', 'hostiko-toolkit' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'selectors' => [
					'{{WRAPPER}} .hostiko-testimonial-section .hostiko-testimonial-box' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		); 
		$this->add_responsive_control(
            'container_alignment',
            [
                'label' => esc_html__('Alignment', 'hostiko-toolkit'),
                'type' => \Elementor\Controls_Manager::CHOOSE,
                'options' => [
                    'left' => [
                        'title' => esc_html__('Left', 'hostiko-toolkit'),
                        'icon' => 'eicon-text-align-left',
                    ],
                    'center' => [
                        'title' => esc_html__('Center', 'hostiko-toolkit'),
                        'icon' => 'eicon-text-align-center',
                    ],
                    'right' => [
                        'title' => esc_html__('Right', 'hostiko-toolkit'),
                        'icon' => 'eicon-text-align-right',
                    ],
                ],
                'default' => 'left',
                'selectors' => [
                    '{{WRAPPER}} .hostiko-testimonial-section .hostiko-testimonial-box' => 'text-align: {{VALUE}};',
                ],
            ]
        );
		$this->add_group_control(
            \Elementor\Group_Control_Border::get_type(),
            [
                'name' => 'border',
                'label' => __( 'Border', 'hostiko-toolkit' ),
                'selector' => '{{WRAPPER}} .hostiko-testimonial-section .hostiko-testimonial-box',
            ]
        );
        $this->add_responsive_control(
			'container_borderbox_radius',
			[
				'label' => __( 'Border Radius', 'hostiko-toolkit' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'selectors' => [
					'{{WRAPPER}} .hostiko-testimonial-section .hostiko-testimonial-box' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);
        $this->add_group_control(
            \Elementor\Group_Control_Background::get_type(),
            [
                'name' => 'container_background',
				'label' => __( 'Background', 'hostiko-toolkit' ),
                'types' => [ 'classic', 'gradient', 'video' ],
                'selector' => '{{WRAPPER}} .hostiko-testimonial-section .hostiko-testimonial-box',
            ]
        );  

		$this->add_group_control(
			\Elementor\Group_Control_Box_Shadow::get_type(),
			[
				'name' => 'container_box_shadow',
				'selector' => '{{WRAPPER}} .hostiko-testimonial-section .hostiko-testimonial-box',
			]
		);

		$this->add_responsive_control(
			'hostiko_testimonial_space',
			[
				'label' => esc_html__( 'Spacing Between', 'hostiko-toolkit' ),
				'type' => \Elementor\Controls_Manager::SLIDER,
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 50,
					],
				],
			]
		);

		$slides_to_show = range( 1, 5 );
		$slides_to_show = array_combine( $slides_to_show, $slides_to_show );

		$this->add_responsive_control(
			'container_spacing',
			[
				'label' => __( 'Space Around', 'hostiko-toolkit' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'selectors' => [
					'{{WRAPPER}} .hostiko-testimonial-section .owl-stage-outer .item' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		); 

		$this->add_responsive_control(
			'hostiko_slides_to_show',
			[
				'label' => esc_html__( 'Slides to Show', 'hostiko-toolkit' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'options' => [
					'' => esc_html__( 'Default', 'hostiko-toolkit' ),
				] + $slides_to_show,
				'default' => '2',
				
			]
		);

	

		$this->add_responsive_control(
			'hostiko_show_nav',
			[
				'label' => esc_html__( 'Show Nav', 'hostiko-toolkit' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'options' => [
					'true' => esc_html__( 'Yes', 'hostiko-toolkit' ),
					'false' => esc_html__( 'No', 'hostiko-toolkit' ),
				],
				'default' => 'true',
			]
		);

		$this->add_responsive_control(
            'hostiko_show_dots',
            [
                'label' => esc_html__( 'Show Dots', 'hostiko-toolkit' ),
                'type' => \Elementor\Controls_Manager::SELECT,
                'options' => [
                    'true' => esc_html__( 'Yes', 'hostiko-toolkit' ),
                    'false' => esc_html__( 'No', 'hostiko-toolkit' ),
                ],
                'default' => 'false',
            ]
        );

        $this->end_controls_section(); 
		////////////////////////////////////////////////  Conatiner Style Ends /////////////////////////////////////////////////
		////////////////////////////////////////////////  Description Style Ends ///////////////////////////////////////////////// 
        $this->start_controls_section(
			'desc_style_section',
			[
				'label' => esc_html__( 'Description Style', 'hostiko-toolkit' ),
				'tab' => \Elementor\Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name' => 'desc_typography',
				'label' => __( 'Typography', 'hostiko-toolkit' ),
				'selector' => '{{WRAPPER}} .hostiko-testimonial-section .hostiko-testimonial-box-content p',
			]
		);
        $this->add_control(
            'description_color',
            [
                'label' => esc_html__('Color', 'hostiko-toolkit'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .hostiko-testimonial-section .hostiko-testimonial-box-content p' => 'color: {{VALUE}}',
                ],
            ]
        );
        
        $this->add_responsive_control(
			'desc_margin',
			[
				'label' => __( 'Margin', 'hostiko-toolkit' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'selectors' => [
					'{{WRAPPER}} .hostiko-testimonial-section .hostiko-testimonial-box-content p' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);
	
		$this->add_responsive_control(
			'desc_padding',
			[
				'label' => __( 'Padding', 'hostiko-toolkit' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'selectors' => [
					'{{WRAPPER}} .hostiko-testimonial-section .hostiko-testimonial-box-content p' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);
		$this->end_controls_section();
        $this->start_controls_section(
			'client_style_section',
			[
				'label' => esc_html__( 'Author', 'hostiko-toolkit' ),
				'tab' => \Elementor\Controls_Manager::TAB_STYLE,
			]
		);
        $this->add_control(
            'client_color',
            [
                'label' => esc_html__('Color', 'hostiko-toolkit'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .hostiko-testimonial-section .user-name' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name' => 'client_typography_button',
				'label' => __( 'Typography', 'hostiko-toolkit' ),
				'selector' => '{{WRAPPER}} .hostiko-testimonial-section .user-name',
			]
		);
        $this->add_responsive_control(
			'client_margin',
			[
				'label' => __( 'Margin', 'hostiko-toolkit' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'selectors' => [
					'{{WRAPPER}} .hostiko-testimonial-section .user-name' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);
	
		$this->add_responsive_control(
			'client_padding',
			[
				'label' => __( 'Padding', 'hostiko-toolkit' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'selectors' => [
					'{{WRAPPER}} .hostiko-testimonial-section .user-name' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);
		$this->add_responsive_control(
			'image_borderbox_radius',
			[
				'label' => __( 'Image Radius', 'hostiko-toolkit' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'selectors' => [
					'{{WRAPPER}} .hostiko-testimonial-section .hostiko-testimonial-box .user-content-outer figure img' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);
		$this->end_controls_section();
        $this->start_controls_section(
            'style5_section',
            [
                'label' => esc_html__( 'Designation Style', 'hostiko-toolkit' ),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_control(
            'depart_color',
            [
                'label' => esc_html__('Color', 'hostiko-toolkit'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .hostiko-testimonial-section .designation' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name' => 'designation_typography_button',
				'label' => __( 'Typography', 'hostiko-toolkit' ),
				'selector' => '{{WRAPPER}} .hostiko-testimonial-section .designation',
			]
		);
		$this->add_responsive_control(
			'depart_padding',
			[
				'label' => __( 'Padding', 'hostiko-toolkit' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'selectors' => [
					'{{WRAPPER}} .hostiko-testimonial-section .designation' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);
        $this->end_controls_section();
		////////////////////////////////////////////////  Icon Style Start /////////////////////////////////////////////////
		
        $this->start_controls_section(
			
			'hostiko_icon_style_section',
			[
				'label' => esc_html__( ' Icon Style', 'hostiko-toolkit' ),
				'tab' => \Elementor\Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_responsive_control(
			'hostiko_icon_Size',
			[
				'label' => esc_html__( 'Size', 'hostiko-toolkit' ),
				'type' => \Elementor\Controls_Manager::SLIDER,
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 100,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .hostiko-testimonial-section ul li i' => 'font-size: {{SIZE}}{{UNIT}}',
				],
			]
		);
	
		$this->add_control(
			'hostiko_icon_color',
			[
				'label' => __( ' Icon Color', 'hostiko-toolkit' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .hostiko-testimonial-section ul li i' => 'color: {{VALUE}};',
				],
			]
		);
		$this->add_responsive_control(
			'hostiko_icon_space',
			[
				'label' => esc_html__( 'Icon Spacing', 'elementor' ),
				'type' => \Elementor\Controls_Manager::SLIDER,
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 50,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .hostiko-testimonial-section ul li i' => 'margin-right: {{SIZE}}{{UNIT}}',
				],
			]
		);
		
        $this->add_responsive_control(
			'hostiko_icon_margin',
			[
				'label' => __( 'Margin', 'hostiko-toolkit' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'selectors' => [
					'{{WRAPPER}} .hostiko-testimonial-section ul' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);
		$this->end_controls_section();

		////////////////////////////////////////////////  Icon Style Ends /////////////////////////////////////////////////
		////////////////////////////////////////////////  Dots Style Start /////////////////////////////////////////////////
		
        $this->start_controls_section(
			'hostiko_dots_style_section',
			[
				'label' => esc_html__( ' Dots Style', 'hostiko-toolkit' ),
				'tab' => \Elementor\Controls_Manager::TAB_STYLE,
			]
		);
		
        
        $this->add_control(
            'dots_color',
            [
                'label' => esc_html__('Color', 'hostiko-toolkit'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .hostiko-testimonial-section .owl-carousel .owl-dots .owl-dot span' => 'background: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'dots_active_color',
            [
                'label' => esc_html__('Active Color', 'hostiko-toolkit'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .hostiko-testimonial-section .owl-carousel .owl-dots .owl-dot.active span' => 'background: {{VALUE}}',
                ],
            ]
        );
        $this->add_responsive_control(
            'custom_width1',
            [
                'label' => esc_html__('Normal Dots Width', 'hostiko-toolkit'),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => ['px', '%'],
                'selectors' => [
                    '{{WRAPPER}} .hostiko-testimonial-section .owl-carousel .owl-dots .owl-dot span' => 'width: {{SIZE}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'custom_height1',
            [
                'label' => esc_html__('Normal Dots Height', 'hostiko-toolkit'),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => ['px', '%'],
                'selectors' => [
                    '{{WRAPPER}} .hostiko-testimonial-section .owl-carousel .owl-dots .owl-dot span' => 'height: {{SIZE}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'custom_width',
            [
                'label' => esc_html__('Active Dots Width', 'hostiko-toolkit'),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => ['px', '%'],
                'selectors' => [
                    '{{WRAPPER}} .hostiko-testimonial-section .owl-carousel .owl-dots.active .owl-dot span' => 'width: {{SIZE}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'custom_height',
            [
                'label' => esc_html__('Active Dots height', 'hostiko-toolkit'),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => ['px', '%'],
                'selectors' => [
                    '{{WRAPPER}} .hostiko-testimonial-section .owl-carousel .owl-dots.active .owl-dot span' => 'width: {{SIZE}}{{UNIT}};',
                ],
            ]
        );
		
		$this->add_control(
            'testimonial_dots_alignment',
            [
                'label' => esc_html__('Alignment', 'hostiko-toolkit'),
                'type' => \Elementor\Controls_Manager::CHOOSE,
                'options' => [
                    'left' => [
                        'title' => esc_html__('Left', 'hostiko-toolkit'),
                        'icon' => 'eicon-text-align-left',
                    ],
                    'center' => [
                        'title' => esc_html__('Center', 'hostiko-toolkit'),
                        'icon' => 'eicon-text-align-center',
                    ],
                    'right' => [
                        'title' => esc_html__('Right', 'hostiko-toolkit'),
                        'icon' => 'eicon-text-align-right',
                    ],
                ],
                'default' => 'left',
                'selectors' => [
                    '{{WRAPPER}} .hostiko-testimonial-section .owl-carousel .owl-dots' => 'text-align: {{VALUE}};',
                ],
            ]
        );
		$this->end_controls_section();

		////////////////////////////////////////////////  Dots Style Ends /////////////////////////////////////////////////
		////////////////////////////////////////////////  Nav Style Start /////////////////////////////////////////////////
		
        $this->start_controls_section(
			'hostiko_nav_style_section',
			[
				'label' => esc_html__( 'Nav Style', 'hostiko-toolkit' ),
				'tab' => \Elementor\Controls_Manager::TAB_STYLE,
			]
		);
		
        
        $this->add_control(
            'nav_color',
            [
                'label' => esc_html__('Color', 'hostiko-toolkit'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .hostiko-testimonial-section .owl-carousel .owl-nav button' => 'color: {{VALUE}}',
                ],
            ]
        );
      
        $this->add_responsive_control(
            'nav_item_size',
            [
                'label' => esc_html__('Size', 'hostiko-toolkit'),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => ['px', '%'],
                'selectors' => [
                    '{{WRAPPER}} .hostiko-testimonial-section .owl-carousel .owl-nav .owl-prev span, .hostiko-testimonial-section .owl-carousel .owl-nav .owl-next span' => 'font-size: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
			'hostiko_nav_space',
			[
				'label' => esc_html__( 'Nav Spacing', 'elementor' ),
				'type' => \Elementor\Controls_Manager::SLIDER,
				'range' => [
					'px' => [
						'min' => -80,
						'max' => -25,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .hostiko-testimonial-section .owl-carousel .owl-nav .owl-prev' => 'left: {{SIZE}}{{UNIT}}',
					'{{WRAPPER}} .hostiko-testimonial-section .owl-carousel .owl-nav .owl-next' => 'right: {{SIZE}}{{UNIT}}',
				],
			]
		);
		$this->end_controls_section();
		////////////////////////////////////////////////  Nav Style Ends /////////////////////////////////////////////////
		////////////////////////////////////////////////  Quote Style Start /////////////////////////////////////////////////
		
        $this->start_controls_section(
			'hostiko_quote_style_section',
			[
				'label' => esc_html__( 'Quote Style', 'hostiko-toolkit' ),
				'tab' => \Elementor\Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_control(
			'show_quote_icon',
			[
				'label' => esc_html__( 'Show Quote', 'hostiko-toolkit' ),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'label_on' => esc_html__( 'Show', 'hostiko-toolkit' ),
				'label_off' => esc_html__( 'Hide', 'hostiko-toolkit' ),
				'return_value' => 'yes',
				'default' => 'yes',
			]
		);
		$this->add_control(
            'quote_color',
            [
                'label' => esc_html__('Color', 'hostiko-toolkit'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .hostiko-testimonial-section .hostiko-testimonial-box .quote-icon, .hostiko-testimonial-section .hostiko-testimonial-box .quote-icon-2' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_responsive_control(
            'quote_item_size',
            [
                'label' => esc_html__('Size', 'hostiko-toolkit'),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => ['px', '%'],
                'selectors' => [
                    '{{WRAPPER}} .hostiko-testimonial-section .hostiko-testimonial-box .quote-icon, .hostiko-testimonial-section .hostiko-testimonial-box .quote-icon-2' => 'font-size: {{SIZE}}{{UNIT}};',
                ],
            ]
        );
		$this->add_group_control(
            \Elementor\Group_Control_Border::get_type(),
            [
                'name' => 'quote border',
                'label' => __( 'Border', 'hostiko-toolkit' ),
                'selector' => '{{WRAPPER}} .hostiko-testimonial-section .hostiko-testimonial-box .quote-icon, .hostiko-testimonial-section .hostiko-testimonial-box .quote-icon-2',
            ]
        );
        $this->add_responsive_control(
			'quote_borderbox_radius',
			[
				'label' => __( 'Border Radius', 'hostiko-toolkit' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'selectors' => [
					'{{WRAPPER}} .hostiko-testimonial-section .hostiko-testimonial-box .quote-icon, .hostiko-testimonial-section .hostiko-testimonial-box .quote-icon-2' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);
        $this->add_group_control(
            \Elementor\Group_Control_Background::get_type(),
            [
                'name' => 'quote_background',
				'label' => __( 'Background', 'hostiko-toolkit' ),
                'types' => [ 'classic', 'gradient', 'video' ],
                'selector' => '{{WRAPPER}} .hostiko-testimonial-section .hostiko-testimonial-box .quote-icon, .hostiko-testimonial-section .hostiko-testimonial-box .quote-icon-2',
            ]
        );  

		$this->add_responsive_control(
			'hostiko_quote_padding',
			[
				'label' => __( 'Padding', 'hostiko-toolkit' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'selectors' => [
					'{{WRAPPER}} .hostiko-testimonial-section .hostiko-testimonial-box .quote-icon, .hostiko-testimonial-section .hostiko-testimonial-box .quote-icon-2' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		); 
		$this->add_responsive_control(
			'hostiko_quote_margin',
			[
				'label' => __( 'Margin', 'hostiko-toolkit' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'selectors' => [
					'{{WRAPPER}} .hostiko-testimonial-section .hostiko-testimonial-box .quote-icon, .hostiko-testimonial-section .hostiko-testimonial-box .quote-icon-2' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		); 

		$this->end_controls_section();
		////////////////////////////////////////////////  Quote Style Ends /////////////////////////////////////////////////

	}


	/**
	 * Render hostiko-testimonial widget output on the frontend.
	 *
	 * Written in PHP and used to generate the final HTML.
	 *
	 * @since 1.0.0
	 * @access protected
	 */
	protected function render() {
		$settings = $this->get_settings_for_display();
		
			if($settings['hostiko_testimonial_style'] == "style 1" || $settings['hostiko_testimonial_style'] == "Default" || $settings['hostiko_testimonial_style'] == ""){
				?>
				
				<section class="hostiko-testimonial-section position-relative">
					<div class="position-relative" data-aos="fade-up">
						<div class="owl-carousel owl-theme">
							<?php
								$count = 0;
								if ( $settings['list'] ) {
								foreach ( $settings['list'] as $item ) {	
							?>
							<div class="item">
								<div class="hostiko-testimonial-box">
									<div class="user-content-outer d-flex align-items-center justify-content-between">
										<div class="user-content-outer-inner d-flex align-items-center">
											<figure class="mb-0">
												<?php
													if( isset($item['list_image']['id']) && !empty( $item['list_image']['id'] ) ){
												?>
												<?php echo wp_get_attachment_image( $item['list_image']['id'], 'full' ); ?>
												<?php
												}
												else {
												?>
													<img class="img-fluid" src="<?php echo PLUGIN_BASE_URI. 'assets/img/testimonial-user-img.png'?>" alt="">
												<?php
													}
												?>
											</figure>
											<div class="user-content">
												<h6 class="user-name"><?php echo $item['list_username']; ?></h6>
												<span class="designation"><?php echo $item['list_designation']; ?></span>
											</div>
										</div>	
										<?php if($settings['show_quote_icon'] == 'yes') { ?>
											<div class="quote-icon">
												<figure class="mb-0"><i class="fas fa-quote-right"></i></figure>
											</div>
										<?php } ?>
									</div>	
									<div class="hostiko-testimonial-box-content">
										<p class="content"><?php echo $item['list_content'];?></p>
										<ul class="hostiko-rating list-unstyled mb-0">
											<li><i class="fa-solid fa-star"></i></li>
											<li><i class="fa-solid fa-star"></i></li>
											<li><i class="fa-solid fa-star"></i></li>
											<li><i class="fa-solid fa-star"></i></li>
											<li><i class="fa-solid fa-star"></i></li>
										</ul>
									</div>
								</div>
							</div>
							
								<?php
									$count++;
								}
								}
								?>
						</div>
					</div>
				</section> 
				<?php
			}
			else if($settings['hostiko_testimonial_style'] == "style 2"){
				?>
				
				<section class="hostiko-testimonial-section hostiko-testimonial-section2 position-relative">
					<div class="position-relative" data-aos="fade-up">
						<div class="owl-carousel owl-theme">
							<?php
								$count = 0;
								if ( $settings['list'] ) {
								foreach ( $settings['list'] as $item ) {	
							?>
							<div class="item">
								<div class="hostiko-testimonial-box">
									<?php if($settings['show_quote_icon'] == 'yes') { ?>
										<div class="quote-icon-2">
											<figure class="mb-0"><i class="fas fa-quote-right"></i></figure>
										</div>
									<?php } ?>
									<div class="hostiko-testimonial-box-content">
										<p class="content"><?php echo $item['list_content'];?></p>
									</div>
									<div class="user-content-outer d-flex align-items-center justify-content-between">
										<div class="user-content-outer-inner d-flex align-items-center">
											<figure class="mb-0">
												<?php
													if( isset($item['list_image']['id']) && !empty( $item['list_image']['id'] ) ){
												?>
												<?php echo wp_get_attachment_image( $item['list_image']['id'], 'full' ); ?>
												<?php
												}
												else {
												?>
													<img class="img-fluid" src="<?php echo PLUGIN_BASE_URI. 'assets/img/testimonial-user-img.png'?>" alt="">
												<?php
													}
												?>
											</figure>
											<div class="user-content">
												<h6 class="user-name"><?php echo $item['list_username']; ?></h6>
												<span class="designation"><?php echo $item['list_designation']; ?></span>
												<div>
												<ul class="hostiko-rating2 list-unstyled mb-0">
													<li><i class="fa-solid fa-star"></i></li>
													<li><i class="fa-solid fa-star"></i></li>
													<li><i class="fa-solid fa-star"></i></li>
													<li><i class="fa-solid fa-star"></i></li>
													<li><i class="fa-solid fa-star"></i></li>
												</ul>
												</div>
											</div>
										</div>	
									</div>	
									
								</div>
							</div>
							
								<?php
									$count++;
								}
								}
								?>
						</div>
					</div>
				</section> 
				<?php
			}
			else if($settings['hostiko_testimonial_style'] == "style 3"){
				?>
				
				<section class="hostiko-testimonial-section hostiko-testimonial-section2 position-relative">
					<div class="position-relative" data-aos="fade-up">
						<div class="owl-carousel owl-theme">
							<?php
								$count = 0;
								if ( $settings['list'] ) {
								foreach ( $settings['list'] as $item ) {	
							?>
							<div class="item">
								<div class="hostiko-testimonial-box">
									<div class="hostiko-testimonial-box-content">
										<ul class="hostiko-rating list-unstyled mb-0">
											<li><i class="fa-solid fa-star"></i></li>
											<li><i class="fa-solid fa-star"></i></li>
											<li><i class="fa-solid fa-star"></i></li>
											<li><i class="fa-solid fa-star"></i></li>
											<li><i class="fa-solid fa-star"></i></li>
										</ul>
										<p class="content">"<?php echo $item['list_content'];?>"</p>
											<figure class="mb-0">
												<?php
													if( isset($item['list_image']['id']) && !empty( $item['list_image']['id'] ) ){
												?>
												<?php echo wp_get_attachment_image( $item['list_image']['id'], 'full' ); ?>
												<?php
												}
												else {
												?>
													<img class="img-fluid" src="<?php echo PLUGIN_BASE_URI. 'assets/img/testimonial-user-img.png'?>" alt="">
												<?php
													}
												?>
											</figure>
										<div class="user-content">
											<h6 class="user-name"><?php echo $item['list_username']; ?></h6>
											<span class="designation"><?php echo $item['list_designation']; ?></span>
										</div>
									</div>
								</div>
							</div>
							
							<?php
								$count++;
							}
							}
							?>
						</div>
					</div>
				</section>
				<?php
			}	
			
			?>
				<script>
					var testimonial_settings= <?php echo json_encode($settings); ?>;
				</script>	
			<?php
				
	}
	

}
