<?php
use Elementor\Widget_Base;
use Elementor\Controls_Manager;
 
class Elementor_Hostiko_Tabs_Widget extends Widget_Base {
    /**
     * Get widget name.
     *
     * @return string
     */
    public function get_name() {
        return 'hostiko-tabs';
    }
 
    /**
     * Get widget title.
     *
     * @return string
     */
    public function get_title() {
        return 'Hostiko Tabs';
    }
 
    /**
     * Get widget icon.
     *
     * @return string
     */
    public function get_icon() {
        return 'eicon-tabs';
    }
 
    /**
     * Get widget categories.
     *
     * @return array
     */
    public function get_categories() {
        return ['general'];
    }
 
    /**
     * Register controls and settings.
     */
    protected function _register_controls() {
        // Define your controls for the widget settings here.
        // You'll need to define controls for tab titles and content.
        // You can use repeater controls to allow multiple tabs.
 
        $this->start_controls_section(
            'section_tabs',
            [
                'label' => 'Tabs',
            ]
        );
 
        $repeater = new \Elementor\Repeater();
 
        $repeater->add_control(
            'tab_title',
            [
                'label' => 'Tab Title',
                'type' => Controls_Manager::TEXT,
                'default' => 'Tab Title',
                'label_block' => true,
            ]
        );
		$repeater->add_control(
			'tab_title_image',
			[
				'label' => esc_html__( 'Choose Image', 'hostiko-toolkit' ),
				'type' => \Elementor\Controls_Manager::MEDIA,
				'default' => [
					'url' => \Elementor\Utils::get_placeholder_image_src(),
				],
			]
		);

        $repeater->add_control(
            'tab_heading',
            [
                'label' => 'Heading',
                'type' => Controls_Manager::TEXT,
                'default' => 'Tab Title',
                'label_block' => true,
            ]
        );

		
		$repeater->add_control(
            'hostiko_tab_icon',
            [
                'label' => esc_html__( 'Icon', 'elementor' ),
                'type' => \Elementor\Controls_Manager::ICONS,
                'fa4compatibility' => 'icon',
                'default' => [
                    'value' => 'fas fa-star',
                    'library' => 'fa-solid',
                ],
            ]
        );
 
        $repeater->add_control(
            'tab_content',
            [
                'label' => 'Content',
                'type' => Controls_Manager::WYSIWYG,
                'default' => 'Nam libero tempore, cum soluta nobis est eligendi optio cumque nihil impedit 
				quod maxime placeat facere possimus, omnis voluptas assumenda est, omnis
				Temporibus autem quibusdam et aut officiis debitis aut rerum necessitatibus
				voluptates repudiandae sint et molestiae non recusandae. ',
            ]
        );
		$repeater->add_control(
            'tab_li1',
            [
                'label' => 'List item 1',
                'type' => Controls_Manager::TEXT,
                'default' => 'List 1',
                'label_block' => true,
            ]
        );
		$repeater->add_control(
            'tab_li2',
            [
                'label' => 'List item 2',
                'type' => Controls_Manager::TEXT,
                'default' => 'List 2',
                'label_block' => true,
            ]
        );
		$repeater->add_control(
            'tab_li3',
            [
                'label' => 'List item 3',
                'type' => Controls_Manager::TEXT,
                'default' => 'List 3',
                'label_block' => true,
            ]
        );
		$repeater->add_control(
            'tab_li4',
            [
                'label' => 'List item 4',
                'type' => Controls_Manager::TEXT,
                'default' => 'List 4',
                'label_block' => true,
            ]
        );


		$repeater->add_control(
            'hostiko_btn_icon',
            [
                'label' => esc_html__( 'Icon', 'elementor' ),
                'type' => \Elementor\Controls_Manager::ICONS,
                'fa4compatibility' => 'icon',
                'default' => [
                    'value' => 'fas fa-star',
                    'library' => 'fa-solid',
                ],
            ]
        );
        $repeater->add_control(
            'hostiko_btn_text',
            [
                'label' => esc_html__( 'Button Text', 'hostiko-toolkit' ),
                'label_block' => true,
                'placeholder' => __( 'Read More', 'hostiko-toolkit' ),
                'default' => __( 'Read More' , 'hostiko-toolkit' ),
                'type' => 'text',
            ]
        );
        $repeater->add_control(
            'hostiko_btn_link',
            [
                'label' => esc_html__( 'Button Link', 'hostiko-toolkit' ),
                'label_block' => true,
                'placeholder' => __( '#', 'hostiko-toolkit' ),
                'default' => __( '#' , 'hostiko-toolkit' ),
                'type' => 'text',
            ]
        );

        $this->add_control(
            'tabs',
            [
                'label' => 'Tabs',
                'type' => Controls_Manager::REPEATER,
                'fields' => $repeater->get_controls(),
                'default' => [
                    [
                        'tab_title' => esc_html__( 'Tab 1', 'hostiko-toolkit' ),
                        'tab_heading' => 'Tab Heading 1',
                        'tab_content' => 'Nam libero tempore, cum soluta nobis est eligendi optio cumque nihil impedit 
						quod maxime placeat facere possimus, omnis voluptas assumenda est, omnis
						Temporibus autem quibusdam et aut officiis debitis aut rerum necessitatibus
						voluptates repudiandae sint et molestiae non recusandae.',
                        'tab_li1' => 'Tab List 1',
                        'tab_li2' => 'Tab list 2',
                        'tab_li3' => 'Tab List 3',
                        'tab_li4' => 'Tab List 4',
                        'hostiko_btn_text' => 'Get Started',
						
						
                    ],
                    [
                        'tab_title' => esc_html__( 'Tab 2', 'hostiko-toolkit' ),
                        'tab_heading' => 'Tab Heading 2',
                        'tab_content' => 'Nam libero tempore, cum soluta nobis est eligendi optio cumque nihil impedit 
						quod maxime placeat facere possimus, omnis voluptas assumenda est, omnis
						Temporibus autem quibusdam et aut officiis debitis aut rerum necessitatibus
						voluptates repudiandae sint et molestiae non recusandae.',
						'tab_li1' => 'Tab List 1',
                        'tab_li2' => 'Tab list 2',
                        'tab_li3' => 'Tab List 3',
                        'tab_li4' => 'Tab List 4',
                        'hostiko_btn_text' => 'Get Started',
                    ],
                ],
                'title_field' => '{{{ tab_title }}}',
            ]
        );
 
        $this->end_controls_section();
		$this->start_controls_section(
			'tabs_style',
			[
				'label' => esc_html__( 'Tabs Style', 'hostiko-toolkit' ),
				'tab' => \Elementor\Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_control(
			'text_color',
			[
				'label' => esc_html__( 'Text Color', 'hostiko-toolkit' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} #hostiko_custom_tabs #myTab' => 'color: {{VALUE}}',
				],
			]
		);
		$this->add_control(
			'text_active_color',
			[
				'label' => esc_html__( 'Active Color', 'hostiko-toolkit' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} #hostiko_custom_tabs .nav-pills .nav-link.active' => 'color: {{VALUE}}',
				],
			]
		);
		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name' => 'tabs_typography',
				'label' => __( 'Typography', 'hostiko-toolkit' ),
				'selector' => '{{WRAPPER}} #hostiko_custom_tabs #myTab',
			]
		);
		$this->start_controls_tabs(
			'style_order_tabs'
		);
			$this->start_controls_tab(
				'style_order_normal_tab',
					[
						'label' => esc_html__( 'Normal', 'hostiko-toolkit' ),
					]
				);

				$this->add_group_control(
					\Elementor\Group_Control_Background::get_type(),
					[
						'name' => 'tabs_background',
						'types' => [ 'classic', 'gradient', 'video' ],
						'selector' => '{{WRAPPER}} #hostiko_custom_tabs .nav-item',
					]
				);

			   
				$this->add_group_control(
					\Elementor\Group_Control_Border::get_type(),
					[
						'name' => 'tabs_border',
						'selector' => '{{WRAPPER}} #hostiko_custom_tabs .nav-item',
					]
				);


				$this->add_responsive_control(
					'tabs_border_radius',
					[
						'label' => esc_html__( 'Border Radius', 'elementor' ),
						'type' => \Elementor\Controls_Manager::DIMENSIONS,
						'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
						'selectors' => [
							'{{WRAPPER}} #hostiko_custom_tabs .nav-item' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
						],
					]
				);
			$this->end_controls_tab();

			$this->start_controls_tab(
				'style_order_hover_tab',
				[
					'label' => esc_html__( 'Hover', 'hostiko-toolkit' ),
				]
			);
		   
		   
			$this->add_group_control(
				\Elementor\Group_Control_Background::get_type(),
				[
					'name' => 'tabs_hover_background',
					'types' => [ 'classic', 'gradient', 'video'],
					'selector' => '{{WRAPPER}} #hostiko_custom_tabs .nav-item:hover',
				]
			);

			$this->add_group_control(
				\Elementor\Group_Control_Border::get_type(),
				[
					'name' => 'tabs_hover_border',
					'selector' => '{{WRAPPER}} #hostiko_custom_tabs .nav-item:hover',
				]
			);


			$this->add_responsive_control(
				'tabs_hover_border_radius',
				[
					'label' => esc_html__( 'Border Radius', 'elementor' ),
					'type' => \Elementor\Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
					'selectors' => [
						'{{WRAPPER}} #hostiko_custom_tabs .nav-item:hover' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);
			$this->end_controls_tab();
		$this->end_controls_tabs();
		$this->add_responsive_control(
			'tabs_padding',
			[
				'label' => __( 'Padding', 'hostiko-toolkit' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'selectors' => [
					'{{WRAPPER}} #hostiko_custom_tabs .nav-pills .nav-link' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		); 
		$this->add_responsive_control(
			'tabs_margin',
			[
				'label' => __( 'Margin', 'hostiko-toolkit' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'selectors' => [
					'{{WRAPPER}} #hostiko_custom_tabs .nav-pills .nav-item' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);
		$this->add_control(
			'width',
			[
				'label' => esc_html__( 'Image Width', 'hostiko-toolkit' ),
				'type' => \Elementor\Controls_Manager::SLIDER,
				'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 1000,
						'step' => 5,
					],
					'%' => [
						'min' => 0,
						'max' => 100,
					],
				],
				'default' => [
					'unit' => '%',
					'size' => 50,
				],
				'selectors' => [
					'{{WRAPPER}} #hostiko_custom_tabs ul .nav-item .nav-link .tab_tltle img' => 'width: {{SIZE}}{{UNIT}};',
				],
			]
		);
		$this->add_responsive_control(
			'image_margin',
			[
				'label' => __( 'Margin', 'hostiko-toolkit' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'selectors' => [
					'{{WRAPPER}} #hostiko_custom_tabs ul .nav-item .nav-link .tab_tltle img' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);
		$this->add_group_control(
			\Elementor\Group_Control_Css_Filter::get_type(),
			[
				'name' => 'custom_css_filters',
				'selector' => '{{WRAPPER}} #hostiko_custom_tabs ul .nav-item .nav-link .tab_tltle img',
			]
		);
		$this->add_control(
			'size_control',
			[
				'label' => __('Icon Size', 'hostiko-toolkit'),
				'type' => \Elementor\Controls_Manager::SLIDER,
				'selectors' => [
					'{{WRAPPER}} #hostiko_custom_tabs ul .nav-item .nav-link .tab-title-icon' => 'font-size: {{SIZE}}px !important;',
				],
			]
		);
		$this->add_control(
			'icon_color',
			[
				'label' => esc_html__( 'Icon Color', 'hostiko-toolkit' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} #hostiko_custom_tabs ul .nav-item .nav-link .tab-title-icon' => 'color: {{VALUE}}',
				],
			]
		);
		$this->add_control(
			'active_icon_color',
			[
				'label' => esc_html__( 'Active Color', 'hostiko-toolkit' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} #hostiko_custom_tabs .nav-pills .nav-link.active .tab-title-icon' => 'color: {{VALUE}}',
				],
			]
		);
		$this->end_controls_section();
		$this->start_controls_section(
			'heading_style',
			[
				'label' => esc_html__( 'Heading Style', 'hostiko-toolkit' ),
				'tab' => \Elementor\Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_control(
			'heading_color',
			[
				'label' => esc_html__( 'Heading Color', 'hostiko-toolkit' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}}  .tab-content h2' => 'color: {{VALUE}}',
				],
			]
		);
		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name' => 'heading_typography',
				'label' => __( 'Typography', 'hostiko-toolkit' ),
				'selector' => '{{WRAPPER}} .tab-content h2',
			]
		);
		$this->add_responsive_control(
			'heading_padding',
			[
				'label' => __( 'Padding', 'hostiko-toolkit' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'selectors' => [
					'{{WRAPPER}} .tab-content h2' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		); 
		$this->add_responsive_control(
			'heading_margin',
			[
				'label' => __( 'Margin', 'hostiko-toolkit' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'selectors' => [
					'{{WRAPPER}}  .tab-content h2' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);
		$this->add_responsive_control(
			'heading_align',

			[
				'label' => esc_html__( 'Alignment', 'hostiko-toolkit' ),
				'type' => \Elementor\Controls_Manager::CHOOSE,
				'options' => [
					'left' => [
						'title' => esc_html__( 'Left', 'hostiko-toolkit' ),
						'icon' => 'eicon-text-align-left',
					],
					'center' => [
					'title' => esc_html__( 'Center', 'hostiko-toolkit' ),
						'icon' => 'eicon-text-align-center',
					],
					'right' => [
						'title' => esc_html__( 'Right', 'hostiko-toolkit' ),
						'icon' => 'eicon-text-align-right',
					],
				],
				'default' => 'left',
				'toggle' => true,
				'selectors' => [
				'{{WRAPPER}} .tab-content h2'   => 'text-align: {{VALUE}};',
				],
			]
		);
		$this->end_controls_section();
		$this->start_controls_section(
			'content_style',
			[
				'label' => esc_html__( 'Content Style', 'hostiko-toolkit' ),
				'tab' => \Elementor\Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_control(
			'content_color',
			[
				'label' => esc_html__( 'Content Color', 'hostiko-toolkit' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}}  .tab-content p' => 'color: {{VALUE}}',
				],
			]
		);
		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name' => 'content_typography',
				'label' => __( 'Typography', 'hostiko-toolkit' ),
				'selector' => '{{WRAPPER}} .tab-content p',
			]
		);
		$this->add_responsive_control(
			'content_padding',
			[
				'label' => __( 'Padding', 'hostiko-toolkit' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'selectors' => [
					'{{WRAPPER}} .tab-content p' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		); 
		$this->add_responsive_control(
			'content_margin',
			[
				'label' => __( 'Margin', 'hostiko-toolkit' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'selectors' => [
					'{{WRAPPER}}  .tab-content p' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);
		$this->add_responsive_control(
			'content_align',

			[
				'label' => esc_html__( 'Alignment', 'hostiko-toolkit' ),
				'type' => \Elementor\Controls_Manager::CHOOSE,
				'options' => [
					'left' => [
						'title' => esc_html__( 'Left', 'hostiko-toolkit' ),
						'icon' => 'eicon-text-align-left',
					],
					'center' => [
					'title' => esc_html__( 'Center', 'hostiko-toolkit' ),
						'icon' => 'eicon-text-align-center',
					],
					'right' => [
						'title' => esc_html__( 'Right', 'hostiko-toolkit' ),
						'icon' => 'eicon-text-align-right',
					],
				],
				'default' => 'left',
				'toggle' => true,
				'selectors' => [
				'{{WRAPPER}} .tab-content p'   => 'text-align: {{VALUE}};',
				],
			]
		);
		$this->end_controls_section();
		$this->start_controls_section(
			'list_style',
			[
				'label' => esc_html__( 'List Style', 'hostiko-toolkit' ),
				'tab' => \Elementor\Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_control(
			'list_color',
			[
				'label' => esc_html__( 'List Color', 'hostiko-toolkit' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}}  .tabs-main-list' => 'color: {{VALUE}}',
				],
			]
		);
		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name' => 'list_typography',
				'label' => __( 'Typography', 'hostiko-toolkit' ),
				'selector' => '{{WRAPPER}} #hostiko_custom_tabs .tabs-main-list',
			]
		);
		
		$this->add_responsive_control(
			'list_padding',
			[
				'label' => __( 'Padding', 'hostiko-toolkit' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'selectors' => [
					'{{WRAPPER}} .tabs-main-list li' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		); 
		$this->add_responsive_control(
			'list_margin',
			[
				'label' => __( 'Margin', 'hostiko-toolkit' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'selectors' => [
					'{{WRAPPER}}  .tabs-main-list ' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);
		$this->add_control(
            'list_icon_style',
            [
                'label' => 'Select List Style',
                'type' => \Elementor\Controls_Manager::SELECT,
                'options' => [
                    '' => 'Default', // Placeholder
                    'circle' => 'circle', // Placeholder
                    'disc' => 'disc', // Placeholder
                    'square' => 'square', // Placeholder
                    'decimal' => 'decimal', // Placeholder
                    '"\2714"' => 'check', // Placeholder
                    'none' => 'none', // Placeholder
                ],
				'selectors' => [
					'{{WRAPPER}} #hostiko_custom_tabs .tabs-main-list li' => 'list-style-type: {{VALUE}};',
				],
            ]
        );
        
		$this->end_controls_section();
			$this->start_controls_section(
				'button_style_section',
				[
					'label' => esc_html__( 'Button Styling', 'elementor-portfolio-control' ),
					'tab' => \Elementor\Controls_Manager::TAB_STYLE,
				]
				);
				$this->add_group_control(
				\Elementor\Group_Control_Typography::get_type(),
				[
					'name' => 'content_typography_text',
					'label' => __( 'Text Typography', 'hostiko-toolkit' ),
					'selector' => '{{WRAPPER}} .hostiko-tabs-btn a',
				]
				);
				$this->add_responsive_control(
					'alignment',
					[
					'label' => esc_html__( 'Alignment', 'hostiko-toolkit' ),
					'type' => \Elementor\Controls_Manager::CHOOSE,
					'options' => [
						'left' => [
							'title' => esc_html__( 'Left', 'hostiko-toolkit' ),
							'icon' => 'eicon-text-align-left',
						],
						'center' => [
							'title' => esc_html__( 'Center', 'hostiko-toolkit' ),
							'icon' => 'eicon-text-align-center',
						],
						'right' => [
							'title' => esc_html__( 'Right', 'hostiko-toolkit' ),
							'icon' => 'eicon-text-align-right',
						],
					],
					'default' => 'center',
					'toggle' => true,
					'selectors' => [
					'{{WRAPPER}} .hostiko-tabs-btn' => 'text-align: {{VALUE}};',
					],
					]
				);
				$this->start_controls_tabs(
				'style_tabs'
				);
				$this->start_controls_tab(
				'style_normal_tab',
				[
					'label' => esc_html__( 'Normal', 'hostiko-toolkit' ),
				]
				);
				$this->add_control(
				'button_text',
				[
					'label' => esc_html__( 'Button Text', 'hostiko-toolkit' ),
					'type' => \Elementor\Controls_Manager::COLOR,
					'selectors' => [
					'{{WRAPPER}} .hostiko-tabs-btn a' => 'color: {{VALUE}}',
					],
				]
				);
				$this->add_control(
				'button_background_color',
				[
					'label' => esc_html__( 'Button Background', 'elementor' ),
					'type' => \Elementor\Controls_Manager::COLOR,
					'default' => '',
					'selectors' => [
						'{{WRAPPER}} .hostiko-tabs-btn a' => 'background-color: {{VALUE}};',
					],
				]
				);
				$this->add_responsive_control(
				'button_padding',
				[
					'label' => esc_html__( 'Button Padding', 'hostiko-toolkit' ),
					'type' => \Elementor\Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
					'selectors' => [
						'{{WRAPPER}} .hostiko-tabs-btn a' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
				);
				$this->add_responsive_control(
				'button_radius',
				[
					'label' => esc_html__( 'Button Radius', 'elementor' ),
					'type' => \Elementor\Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
					'selectors' => [
						'{{WRAPPER}} .hostiko-tabs-btn a' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
				);
				$this->add_control(
				'icon_color1',
				[
					'label' => esc_html__( 'Icon Color', 'hostiko-toolkit' ),
					'type' => \Elementor\Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .hostiko-tabs-btn i' => 'color: {{VALUE}}',
					],
				]
				);
				$this->add_control(
				'icon_background_color',
				[
					'label' => esc_html__( 'Icon background', 'elementor' ),
					'type' => \Elementor\Controls_Manager::COLOR,
					'default' => '',
					'selectors' => [
						'{{WRAPPER}} .hostiko-tabs-btn i' => 'background-color: {{VALUE}};',
					],
				]
				);
				$this->add_responsive_control(
				'icon_padding',
				[
					'label' => esc_html__( 'Icon Padding', 'hostiko-toolkit' ),
					'type' => \Elementor\Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
					'selectors' => [
						'{{WRAPPER}} .hostiko-tabs-btn i' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
				);
				$this->add_responsive_control(
				'icon_spacing',
				[
					'label' => esc_html__( 'Icon Spacing', 'elementor' ),
					'type' => \Elementor\Controls_Manager::SLIDER,
					'selectors' => [
						'{{WRAPPER}} .hostiko-tabs-btn i' => 'margin-left: {{SIZE}}{{UNIT}};',
					],
					'range' => [
						'em' => [
							'min' => 0,
							'max' => 5,
						],
					],
				]
				);
				$this->add_responsive_control(
				'rotate',
				[
					'label' => esc_html__( 'Icon Rotate', 'elementor' ),
					'type' => \Elementor\Controls_Manager::SLIDER,
					'size_units' => [ 'deg', 'grad', 'rad', 'turn', 'custom' ],
					'default' => [
						'unit' => 'deg',
					],
					'tablet_default' => [
						'unit' => 'deg',
					],
					'mobile_default' => [
						'unit' => 'deg',
					],
					'selectors' => [
						'{{WRAPPER}} .hostiko-tabs-btn i, {{WRAPPER}} .elementor-icon svg' => 'transform: rotate({{SIZE}}{{UNIT}});',
					],
				]
				);
				$this->add_responsive_control(
				'icon_radius',
				[
					'label' => esc_html__( 'Icon Radius', 'elementor' ),
					'type' => \Elementor\Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
					'selectors' => [
						'{{WRAPPER}} .hostiko-tabs-btn i' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
				);
				$this->end_controls_tab();
				$this->start_controls_tab(
				'style_hover_tab',
				[
					'label' => esc_html__( 'Hover', 'hostiko-toolkit' ),
				]
				);
				$this->add_control(
				'button_text_hover',
				[
					'label' => esc_html__( 'Button Text', 'hostiko-toolkit' ),
					'type' => \Elementor\Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .hostiko-tabs-btn a:hover' => 'color: {{VALUE}}',
					],
				]
				);
				$this->add_control(
				'button_background_color_hover',
				[
					'label' => esc_html__( 'Button Background', 'elementor' ),
					'type' => \Elementor\Controls_Manager::COLOR,
					'default' => '',
					'selectors' => [
						'{{WRAPPER}} .hostiko-tabs-btn a:hover' => 'background-color: {{VALUE}};',
					],
				]
				);
				$this->add_control(
				'icon_color_hover',
				[
					'label' => esc_html__( 'Icon Color', 'hostiko-toolkit' ),
					'type' => \Elementor\Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .hostiko-tabs-btn a:hover i' => 'color: {{VALUE}}',
					],
				]
				);
				$this->add_control(
				'icon_background_color_hover',
				[
					'label' => esc_html__( 'Icon background', 'elementor' ),
					'type' => \Elementor\Controls_Manager::COLOR,
					'default' => '',
					'selectors' => [
						'{{WRAPPER}} .hostiko-tabs-btn a:hover i' => 'background-color: {{VALUE}};',
					],
				]
				);
				$this->end_controls_tab();
			$this->end_controls_section();
    }
 
    /**
     * Render widget output on the frontend.
     */
    protected function render() {
        $settings = $this->get_settings();
 
        if (empty($settings['tabs'])) {
            return;
        }
 
        // Output the HTML structure for the tabs and their content using the settings.
        ?>
	<div id="hostiko_custom_tabs" class="tab">
		<div class="row">
			<div class="col-md-5 mb-3">
				<ul class="nav nav-pills flex-column" id="myTab" role="tablist">
						<?php
							foreach ($settings['tabs'] as $index => $tab) {
								// echo '<pre>';
								// 	print_r($tab);
								
						?>
							<li class="nav-item">

								<a class="nav-link <?php if($index == 0){?>active<?php }?>" id="hostiko-tab-title-<?php echo $index; ?>" data-toggle="tab" href="#hostiko-tab-<?php echo $index; ?>" role="tab" aria-controls="<?php echo $tab['tab_title']; ?>" aria-selected="true">
									<div class="tab_tltle"><img alt="" src="<?php echo $tab['tab_title_image']['url']?>"><span><?php echo $tab['tab_title'];?></span></div> <div class="tab-title-icon"><i class="<?php echo $tab['hostiko_tab_icon']['value']; ?>"></i></div>
								</a>
							</li>
						<?php
							}
						?>
				</ul>
			</div>
			<div class="col-md-7">
				<div class="tab-content" id="myTabContent">
					<?php
					foreach ($settings['tabs'] as $index => $tab) {
					?>
						<div id="hostiko-tab-<?php echo $index; ?>" class="tab-pane fade <?php if($index == 0){?>show active<?php }?>" role="tabpanel" aria-labelledby="<?php echo $tab['tab_title']; ?>-tab">
							<h2 class="h-2"><?php echo esc_html($tab['tab_heading']); ?></h2><br>
							<?php echo '<p class="t-2">'.$tab['tab_content'].'</p>'; ?>
							<ul class="tabs-main-list">
								<div class= "tab-list1">
									<li><?php echo $tab['tab_li1'];?></li>
									<li><?php echo $tab['tab_li2'];?></li>
								</div>
								<div class= "tab-list2">
									<li><?php echo $tab['tab_li3'];?></li>
									<li><?php echo $tab['tab_li4'];?></li>
								</div>
							</ul>
					
									<!-- Output the additional content for the tabs. -->
							<div class="hostiko-tabs-btn">
								<a href="<?php echo $tab['hostiko_btn_link']; ?>">
									<?php echo $tab['hostiko_btn_text']; ?>
								</a>
							</div>
						</div>
					<?php
					}
					?>
				</div>
			</div>
		</div>
	</div>
	   <?php
	
    }
 
    // Rest of the widget code...
}
?>
