<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

/**
 * Elementor hostiko-shared-table-Widget.
 *
 * Elementor widget that uses the hostiko-shared-table control.
 *
 * @since 1.0.0
 */
class Elementor_Hostiko_Shared_Table_Widget extends \Elementor\Widget_Base {

	/**
	 * Get widget name.
	 *
	 * Retrieve hostiko-shared-table widget name.
	 *
	 * @since 1.0.0
	 * @access public
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'hostiko-shared-table';
	}

	/**
	 * Get widget title.
	 *
	 * Retrieve hostiko-shared-table widget title.
	 *
	 * @since 1.0.0
	 * @access public
	 * @return string Widget title.
	 */
	public function get_title() {
		return esc_html__( 'Hostiko Shared Table', 'hostiko-toolkit' );
	}

	/**
	 * Get widget icon.
	 *
	 * Retrieve hostiko-shared-table widget icon.
	 *
	 * @since 1.0.0
	 * @access public
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'eicon-carousel-loop';
	}

	/**
	 * Register hostiko-shared-table widget controls.
	 *
	 * Add input fields to allow the user to customize the widget settings.
	 *
	 * @since 1.0.0
	 * @access protected
	 */
	protected function register_controls() {

		$this->start_controls_section(
			'content_section',
			[
				'label' => esc_html__( 'Content', 'hostiko-toolkit' ),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);
        $this->add_control(
			'hostiko_tld_heading', [
				'label' => __( 'Shared Hosting Features', 'hostiko-toolkit' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => __( 'Shared Hosting Features' , 'hostiko-toolkit' ),
				'label_block' => true,
			]
		);
       
        $this->add_control(
			'hostiko_register_domain_heading', [
				'label' => __( 'Features Heading 1', 'hostiko-toolkit' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => __( 'Basic' , 'hostiko-toolkit' ),
				'label_block' => true,
			]
		);
        $this->add_control(
			'hostiko_transfer_domain_heading', [
				'label' => __( 'Features Heading 2', 'hostiko-toolkit' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => __( 'Premium' , 'hostiko-toolkit' ),
				'label_block' => true,
			]
		);
        $this->add_control(
			'hostiko_renew_domain_heading', [
				'label' => __( 'Features Heading 3', 'hostiko-toolkit' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => __( 'Business' , 'hostiko-toolkit' ),
				'label_block' => true,
			]
		);

		$repeater = new \Elementor\Repeater();

        $repeater->add_control(
			'hostiko_featured_icon', [
				'label' => esc_html__( 'Feature icon', 'elementor' ),
                'type' => \Elementor\Controls_Manager::ICONS,
                'fa4compatibility' => 'icon',
                'default' => [
                    'value' => 'fas fa-star',
                    'library' => 'fa-solid',
                ],
			]
		);
        $repeater->add_control(
			'hostiko_tld_name', [
				'label' => __( 'Feature Name', 'hostiko-toolkit' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => __( '.com' , 'hostiko-toolkit' ),
				'label_block' => true,
			]
		);
        $repeater->add_control(
			'hostiko_tld_currency', [
				'label' => esc_html__( 'Feature icon 1', 'elementor' ),
                'type' => \Elementor\Controls_Manager::ICONS,
                'fa4compatibility' => 'icon',
                'default' => [
                    'value' => 'fas fa-star',
                    'library' => 'fa-solid',
                ],
			]
		);
        $repeater->add_control(
			'hostiko_register_domain', [
				'label' => esc_html__( 'Feature icon 2', 'elementor' ),
                'type' => \Elementor\Controls_Manager::ICONS,
                'fa4compatibility' => 'icon',
                'default' => [
                    'value' => 'fas fa-star',
                    'library' => 'fa-solid',
                ],
			]
		);
        $repeater->add_control(
			'hostiko_transfer_domain', [
				'label' => esc_html__( 'Feature icon 3', 'elementor' ),
                'type' => \Elementor\Controls_Manager::ICONS,
                'fa4compatibility' => 'icon',
                'default' => [
                    'value' => 'fas fa-star',
                    'library' => 'fa-solid',
                ],
			]
		);
        
		$this->add_control(
			'list',
			[
				'label' => __( 'Repeater List', 'hostiko-toolkit' ),
				'type' => \Elementor\Controls_Manager::REPEATER,
				'fields' => $repeater->get_controls(),
				'default' => [
					[
						'hostiko_tld_name' => __( 'TLD Name', 'hostiko-toolkit' ),
						'hostiko_tld_currency' => __( 'Currency', 'hostiko-toolkit' ),
						'hostiko_no_years' => __( 'Years', 'hostiko-toolkit' ),
						'hostiko_register_domain' => __( 'Register', 'hostiko-toolkit' ),
						'hostiko_transfer_domain' => __( 'Transfer', 'hostiko-toolkit' ),
						'hostiko_renew_domain' => __( 'Renew', 'hostiko-toolkit' ),
                        'hostiko_featured_icon' => __( 'Featured icon', 'hostiko-toolkit' ),
					],
					[
						'hostiko_tld_name' => __( 'TLD Name', 'hostiko-toolkit' ),
						'hostiko_tld_currency' => __( 'Currency', 'hostiko-toolkit' ),
						'hostiko_no_years' => __( 'Years', 'hostiko-toolkit' ),
						'hostiko_register_domain' => __( 'Register', 'hostiko-toolkit' ),
						'hostiko_transfer_domain' => __( 'Transfer', 'hostiko-toolkit' ),
						'hostiko_renew_domain' => __( 'Renew', 'hostiko-toolkit' ),
                        'hostiko_featured_icon' => __( 'Featured icon', 'hostiko-toolkit' ),
					],
				],
				'heading_field' => '{{{ list_heading }}}',
			]
		);
		
        $this->end_controls_section();

		
		
		////////////////////////////////////////////////  Container Style Start /////////////////////////////////////////////////
		$this->start_controls_section(
			'conatiner_tld_style_section',
			[
				'label' => esc_html__( 'Container Style', 'hostiko-toolkit' ),
				'tab' => \Elementor\Controls_Manager::TAB_STYLE,
			]
		);
       
		
        $this->add_group_control(
            \Elementor\Group_Control_Background::get_type(),
            [
                'name' => 'conatiner_tld_background',
				'label' => __( 'Background', 'hostiko-toolkit' ),
                'types' => [ 'classic', 'gradient', 'video' ],
                'selector' => '{{WRAPPER}} .hostiko-tld-table-section .hostiko-tld-table',
            ]
        );  
		
		$this->add_responsive_control(
			'conatiner_tld_border_radius',
			[
				'label' => __( 'Conatiner Border Radius', 'hostiko-toolkit' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'selectors' => [
					'{{WRAPPER}} .hostiko-tld-table-section .hostiko-tld-table' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					
				],
				
			]
		);
		$this->add_group_control(
            \Elementor\Group_Control_Border::get_type(),
            [
                'name' => 'conatiner_tld_border',
                'label' => __( 'Border', 'hostiko-toolkit' ),
                'selector' => '{{WRAPPER}} .hostiko-tld-table-section .hostiko-tld-table',
            ]
        );
		$this->add_group_control(
			\Elementor\Group_Control_Box_Shadow::get_type(),
			[
				'name' => 'conatiner_tld_box_shadow',
				'selector' => '{{WRAPPER}} .hostiko-tld-table-section .hostiko-tld-table',
			]
		);

        $this->end_controls_section(); 
		////////////////////////////////////////////////  Conatiner Style Ends ///////////////////////////////////////////////
		////////////////////////////////////////////////  Header Style Start /////////////////////////////////////////////////
		$this->start_controls_section(
			'header_style_section',
			[
				'label' => esc_html__( 'Header Style', 'hostiko-toolkit' ),
				'tab' => \Elementor\Controls_Manager::TAB_STYLE,
			]
		);
        $this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name' => 'header_typography',
				'label' => __( 'Typography', 'hostiko-toolkit' ),
				'selector' => '{{WRAPPER}} .hostiko-tld-table tr th',
			]
		);
        $this->add_control(
            'header_color',
            [
                'label' => esc_html__('Color', 'hostiko-toolkit'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .hostiko-tld-table tr th' => 'color: {{VALUE}}',
                ],
            ]
        );
		$this->add_responsive_control(
			'header_padding',
			[
				'label' => __( 'Padding', 'hostiko-toolkit' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'selectors' => [
					'{{WRAPPER}} .hostiko-tld-table tr th' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		); 
		$this->add_control(
            'header_alignment',
            [
                'label' => esc_html__('Alignment', 'hostiko-toolkit'),
                'type' => \Elementor\Controls_Manager::CHOOSE,
                'options' => [
                    'left' => [
                        'title' => esc_html__('Left', 'hostiko-toolkit'),
                        'icon' => 'eicon-text-align-left',
                    ],
                    'center' => [
                        'title' => esc_html__('Center', 'hostiko-toolkit'),
                        'icon' => 'eicon-text-align-center',
                    ],
                    'right' => [
                        'title' => esc_html__('Right', 'hostiko-toolkit'),
                        'icon' => 'eicon-text-align-right',
                    ],
                ],
                'default' => 'left',
                'selectors' => [
                    '{{WRAPPER}} .hostiko-tld-table tr th' => 'text-align: {{VALUE}};',
                ],
            ]
        );
		$this->add_group_control(
            \Elementor\Group_Control_Border::get_type(),
            [
                'name' => 'header_border',
                'label' => __( 'Border', 'hostiko-toolkit' ),
                'selector' => '{{WRAPPER}} .hostiko-tld-table-section .hostiko-tld-table tr th',
            ]
        );
        
		$this->add_responsive_control(
			'header_borderbox_radius',
			[
				'label' => esc_html__( 'Border Radius', 'elementor' ),
				'type' => \Elementor\Controls_Manager::SLIDER,
				'size_units' => [ 'px', '%', 'em', 'rem', 'vw', 'custom' ],
				'default' => [
					'size' => 15,
				],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 100,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .hostiko-tld-table .hostiko-tld-header-row .tld_heading' => 'border-top-left-radius: {{SIZE}}{{UNIT}}',
					'{{WRAPPER}} .hostiko-tld-table .hostiko-tld-header-row th:first-child' => 'border-bottom-left-radius: {{SIZE}}{{UNIT}}',
					'{{WRAPPER}} .hostiko-tld-table .hostiko-tld-header-row .renew_domain_heading' => 'border-bottom-right-radius: {{SIZE}}{{UNIT}}',
					'{{WRAPPER}} .hostiko-tld-table .hostiko-tld-header-row th:last-child' => 'border-top-right-radius: {{SIZE}}{{UNIT}}',
				],
					
			]
		);
			
        $this->add_group_control(
            \Elementor\Group_Control_Background::get_type(),
            [
                'name' => 'header_background',
				'label' => __( 'Background', 'hostiko-toolkit' ),
                'types' => [ 'classic', 'gradient', 'video' ],
                'selector' => '{{WRAPPER}} .hostiko-tld-table tr th',
            ]
        );  
		
		$this->add_responsive_control(
			'tld_container_border_radius',
			[
				'label' => __( 'Conatiner Border Radius', 'hostiko-toolkit' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'selectors' => [
					'{{WRAPPER}} .hostiko-tld-table' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					
				],
				
			]
		);
        $this->end_controls_section(); 
		////////////////////////////////////////////////  Header Style Ends /////////////////////////////////////////////////
		////////////////////////////////////////////////  Content Style Ends ///////////////////////////////////////////////// 
        $this->start_controls_section(
			'content_style_section',
			[
				'label' => esc_html__( 'Content Style', 'hostiko-toolkit' ),
				'tab' => \Elementor\Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name' => 'content_typography',
				'label' => __( 'Typography', 'hostiko-toolkit' ),
				'selector' => '{{WRAPPER}} .hostiko-tld-table tr td',
			]
		);
        $this->add_control(
            'content_color',
            [
                'label' => esc_html__('Color', 'hostiko-toolkit'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .hostiko-tld-table tr td' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'content_icon_color',
            [
                'label' => esc_html__('Icon Color', 'hostiko-toolkit'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .hostiko-tld-table .feature-icon' => 'color: {{VALUE}}',
                ],
            ]
        );
        
		$this->add_responsive_control(
			'content_padding',
			[
				'label' => __( 'Padding', 'hostiko-toolkit' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'selectors' => [
					'{{WRAPPER}} .hostiko-tld-table tr td' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);
        $this->add_group_control(
            \Elementor\Group_Control_Background::get_type(),
            [
                'name' => 'content_background-even',
				'label' => __( 'Background Even', 'hostiko-toolkit' ),
                'types' => [ 'classic', 'gradient', 'video' ],
                'selector' => '{{WRAPPER}} .hostiko-tld-table tr:nth-child(even)',
            ]
        );  
        $this->add_group_control(
            \Elementor\Group_Control_Background::get_type(),
            [
                'name' => 'content_background-odd',
				'label' => __( 'Background Odd', 'hostiko-toolkit' ),
                'types' => [ 'classic', 'gradient', 'video' ],
                'selector' => '{{WRAPPER}} .hostiko-tld-table tr:nth-child(odd)',
            ]
        );  
		$this->add_control(
            'content_header_alignment',
            [
                'label' => esc_html__('Alignment', 'hostiko-toolkit'),
                'type' => \Elementor\Controls_Manager::CHOOSE,
                'options' => [
                    'left' => [
                        'title' => esc_html__('Left', 'hostiko-toolkit'),
                        'icon' => 'eicon-text-align-left',
                    ],
                    'center' => [
                        'title' => esc_html__('Center', 'hostiko-toolkit'),
                        'icon' => 'eicon-text-align-center',
                    ],
                    'right' => [
                        'title' => esc_html__('Right', 'hostiko-toolkit'),
                        'icon' => 'eicon-text-align-right',
                    ],
                ],
                'default' => 'left',
                'selectors' => [
                    '{{WRAPPER}} .hostiko-tld-table tr td' => 'text-align: {{VALUE}};',
                ],
            ]
        );
        $this->end_controls_section(); 

        //////////////////////////////////////////////////Icon style//////////////////////////////////////////////////

        $this->start_controls_section(
			'Icon_style_section',
			[
				'label' => esc_html__( 'Icon Style', 'hostiko-toolkit' ),
				'tab' => \Elementor\Controls_Manager::TAB_STYLE,
			]
		);
        $this->add_control(
            'icon_color1',
            [
                'label' => esc_html__('Icon 1', 'hostiko-toolkit'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .hostiko-tld-table .hostiko-tld-body-row .feature-icon-1' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'icon_color2',
            [
                'label' => esc_html__('Icon 2', 'hostiko-toolkit'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .hostiko-tld-table .hostiko-tld-body-row .feature-icon-2' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'icon_color3',
            [
                'label' => esc_html__('Icon 3', 'hostiko-toolkit'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .hostiko-tld-table .hostiko-tld-body-row .feature-icon-3' => 'color: {{VALUE}}',
                ],
            ]
        );
		$this->end_controls_section();
        /////////////////////////////////////////////////////////////////////////////////////////////////////////////////
        

	}


	/**
	 * Render hostiko-tld-table widget output on the frontend.
	 *
	 * Written in PHP and used to generate the final HTML.
	 *
	 * @since 1.0.0
	 * @access protected
	 */
	protected function render() {
		$settings = $this->get_settings_for_display();
		// echo 'settingss: <pre>' . print_r($settings, true) . '</pre>';
				?>
				<div class="hostiko-tld-table-section position-relative">
					<div class="position-relative" data-aos="fade-up">
                        <table class="hostiko-tld-table">
                            <thead class="hostiko-tld-header bg_gradient">
                                <tr class="hostiko-tld-header-row">
                                    <th class="tld_heading"><?php echo $settings['hostiko_tld_heading'] ?></th>
                                    <th class="register_domain_heading"><?php echo $settings['hostiko_register_domain_heading'] ?></th>
                                    <th class="transfer_domain_heading"><?php echo $settings['hostiko_transfer_domain_heading'] ?></th>
                                    <th class="renew_domain_heading"><?php echo $settings['hostiko_renew_domain_heading'] ?></th>
                                </tr>
                            </thead>
                            <tbody> 
                                <?php
                                    $count = 0;
                                    if ( $settings['list'] ) {
                                    foreach ( $settings['list'] as $item ) {	
                                ?>
                                    <tr class="hostiko-tld-body-row">
                                        <td data-label="<? echo $settings['hostiko_tld_heading'] ?>"><i class="feature-icon <?php echo $item['hostiko_featured_icon']['value']; ?>"></i><?php echo $item['hostiko_tld_name'] ?></td>
                                        <td data-label="<? echo $settings['hostiko_register_domain_heading'] ?>"><i class="feature-icon-1 <?php echo $item['hostiko_tld_currency']['value']; ?>"></i></td>
                                        <td data-label="<? echo $settings['hostiko_transfer_domain_heading'] ?>"><i class="feature-icon-2 <?php echo $item['hostiko_register_domain']['value']; ?>"></i></td>
                                        <td data-label="<? echo $settings['hostiko_renew_domain_heading'] ?>"><i class="feature-icon-3 <?php echo $item['hostiko_transfer_domain']['value']; ?>"></i></td>
                                    </tr>
                                    <?php
                                        $count++;
                                    }
                                    }
                                    ?>
                            </tbody>
                        </table>
                        
					</div>
				</div> 
				
				
			<?php
				
	}
	

}
