<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

/**
 * Elementor hostiko-pricing Widget.
 *
 * Elementor widget that uses the hostiko-pricing control.
 *
 * @since 1.0.0
 */
class Elementor_Hostiko_Pricing_Widget extends \Elementor\Widget_Base {

	/**
	 * Get widget name.
	 *
	 * Retrieve hostiko-pricing widget name.
	 *
	 * @since 1.0.0
	 * @access public
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'hostiko-pricing';
	}
	/**
	 * Get widget title.
	 *
	 * Retrieve hostiko-pricing widget title.
	 *
	 * @since 1.0.0
	 * @access public
	 * @return string Widget title.
	 */
	public function get_title() {
		return esc_html__( 'Hostiko Pricing', 'hostiko-toolkit' );
	}

	/**
	 * Get widget icon.
	 *
	 * Retrieve master-nav-menu widget icon.
	 *
	 * @since 1.0.0
	 * @access public
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'eicon-code';
	}

	/**
	 * Register hostiko-pricing widget controls.
	 *
	 * Add input fields to allow the user to customize the widget settings.
	 *
	 * @since 1.0.0
	 * @access protected
	 */
	protected function register_controls() {
        // Content Tab Controls Start
        $this->start_controls_section(
			'content_section',
			[
				'label' => esc_html__( 'Content', 'hostiko-toolkit' ),
				'type' => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);
		$this->add_control(
			'currency_text', [
				'label' => __( 'Currency', 'hostiko-toolkit' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => __( '$' , 'hostiko-toolkit' ),
				'label_block' => true,
			]
		);
        $this->add_control(
			'price_text', [
				'label' => __( 'Price', 'hostiko-toolkit' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => __( '12' , 'hostiko-toolkit' ),
				'label_block' => true,
			]
		);
        $this->add_control(
			'decimal_text', [
				'label' => __( 'Decimal', 'hostiko-toolkit' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => __( '.99' , 'hostiko-toolkit' ),
				'label_block' => true,
			]
		);
        $this->add_control(
			'duration_text', [
				'label' => __( 'Duration', 'hostiko-toolkit' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => __( '/month' , 'hostiko-toolkit' ),
				'label_block' => true,
			]
		);
        $this->end_controls_section();

		// Style Tab Controls Start
        // Price Widget Controls Start
        $this->start_controls_section(
            'Price_widget_setting',
            [
                'label' => esc_html__( 'Price Widget', 'hostiko-toolkit' ),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_responsive_control(
			'price_widget_padding',
			[
				'label' => esc_html__( 'Padding', 'hostiko-toolkit' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
				'selectors' => [
					'{{WRAPPER}} .hostiko-price-outer' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);
        $this->add_responsive_control(
            'price_widget_align',
            [
                'label' => esc_html__( 'Price Widget Alignment', 'hostiko-toolkit' ),
                'type' => \Elementor\Controls_Manager::CHOOSE,
                'options' => [
                    'left' => [
                        'title' => esc_html__( 'Left', 'hostiko-toolkit' ),
                        'icon' => 'eicon-text-align-left',
                    ],
                    'center' => [
                        'title' => esc_html__( 'Center', 'hostiko-toolkit' ),
                        'icon' => 'eicon-text-align-center',
                    ],
                    'right' => [
                        'title' => esc_html__( 'Right', 'hostiko-toolkit' ),
                        'icon' => 'eicon-text-align-right',
                    ],
                ],
                'default' => 'left',
                'toggle' => true,
                'selectors' => [
                    '{{WRAPPER}} .hostiko-price-outer'   => 'text-align: {{VALUE}};',
                ],
            ]
        );
        $this->end_controls_section();
		// Currency Controls Start
		$this->start_controls_section(
            'currency_setting',
            [
                'label' => esc_html__( 'Currency', 'hostiko-toolkit' ),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_control(
			'currency_space',
			[
				'label' => esc_html__( 'Space', 'hostiko-toolkit' ),
				'type' => \Elementor\Controls_Manager::SLIDER,
				'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
				'range' => [
					'px' => [
						'min' => -100,
						'max' => 100,
						'step' => 1,
					],
					'%' => [
						'min' => 0,
						'max' => 100,
					],
				],
				'default' => [
					'unit' => 'px',
				],
				'selectors' => [
					'{{WRAPPER}} .hostiko-price-outer .currency' => 'top: {{SIZE}}{{UNIT}};',
				],
			]
		);
		$this->add_control(
            'currency_color',
            [
                'label' => esc_html__( 'Currency Color', 'hostiko-toolkit' ),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .hostiko-price-outer .currency' => 'color: {{VALUE}}',
                ],
                'global' => [
                    'default' => \Elementor\Core\Kits\Documents\Tabs\Global_Colors::COLOR_PRIMARY,
                ],
            ]
        );
        $this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name' => 'currency_typography',
				'selector' => '{{WRAPPER}} .hostiko-price-outer .currency',
			]
		);
        $this->end_controls_section();
		// Currency Controls End
		
		// Price Controls Start
        $this->start_controls_section(
            'price_setting',
            [
                'label' => esc_html__( 'Price', 'hostiko-toolkit' ),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_responsive_control(
			'price_padding',
			[
				'label' => esc_html__( 'Padding', 'hostiko-toolkit' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
				'selectors' => [
					'{{WRAPPER}} .hostiko-price-outer .price' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);
		$this->add_control(
            'price_color',
            [
                'label' => esc_html__( 'Price Color', 'hostiko-toolkit' ),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .hostiko-price-outer .price' => 'color: {{VALUE}}',
                ],
                'global' => [
                    'default' => \Elementor\Core\Kits\Documents\Tabs\Global_Colors::COLOR_PRIMARY,
                ],
            ]
        );
        $this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name' => 'price_typography',
				'selector' => '{{WRAPPER}} .hostiko-price-outer .price',
			]
		);
        $this->end_controls_section();
		// Price Controls End

		// Decimal Controls Start
		$this->start_controls_section(
            'decimal_setting',
            [
                'label' => esc_html__( 'Decimal', 'hostiko-toolkit' ),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_responsive_control(
			'decimal_padding',
			[
				'label' => esc_html__( 'Padding', 'hostiko-toolkit' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
				'selectors' => [
					'{{WRAPPER}} .hostiko-price-outer .decimal-outer .decimal' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);
		$this->add_control(
            'decimal_color',
            [
                'label' => esc_html__( 'Decimal Color', 'hostiko-toolkit' ),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .hostiko-price-outer .decimal-outer .decimal' => 'color: {{VALUE}}',
                ],
                'global' => [
                    'default' => \Elementor\Core\Kits\Documents\Tabs\Global_Colors::COLOR_PRIMARY,
                ],
            ]
        );
        $this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name' => 'decimal_typography',
				'selector' => '{{WRAPPER}} .hostiko-price-outer .decimal-outer .decimal',
			]
		);
        $this->add_responsive_control(
            'decimal_position',
            [
                'label' => esc_html__( 'Decimal Position', 'hostiko-toolkit' ),
                'type' => \Elementor\Controls_Manager::CHOOSE,
                'options' => [
                    'inline-block' => [
                        'title' => esc_html__( 'Left', 'hostiko-toolkit' ),
                        'icon' => 'eicon-h-align-left',
                    ],
                    'block' => [
                        'title' => esc_html__( 'Top', 'hostiko-toolkit' ),
                        'icon' => 'eicon-v-align-top',
                    ],
                ],
                'default' => 'block',
                'toggle' => true,
                'selectors' => [
                    '{{WRAPPER}} .hostiko-price-outer .decimal-outer .decimal'   => 'display: {{VALUE}};',
                ],
            ]
        );
        $this->end_controls_section();
		// Decimal Controls End   

        // Duration Controls Start
		$this->start_controls_section(
            'duration_setting',
            [
                'label' => esc_html__( 'Duration', 'hostiko-toolkit' ),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_responsive_control(
			'duration_padding',
			[
				'label' => esc_html__( 'Padding', 'hostiko-toolkit' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
				'selectors' => [
					'{{WRAPPER}} .hostiko-price-outer .decimal-outer .duration' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);
		$this->add_control(
            'duration_color',
            [
                'label' => esc_html__( 'Duration Color', 'hostiko-toolkit' ),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .hostiko-price-outer .decimal-outer .duration' => 'color: {{VALUE}}',
                ],
                'global' => [
                    'default' => \Elementor\Core\Kits\Documents\Tabs\Global_Colors::COLOR_TEXT,
                ],
            ]
        );
        $this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name' => 'duration_typography',
				'selector' => '{{WRAPPER}} .hostiko-price-outer .decimal-outer .duration',
			]
		);
        $this->end_controls_section();
		// Duration Controls End
	}
	/**
	 * Render hostiko-pricing widget output on the frontend.
	 *
	 * Written in PHP and used to generate the final HTML.
	 *
	 * @since 1.0.0
	 * @access protected
	 */
	protected function render() {
		$settings = $this->get_settings_for_display();
		?>
        <div class="hostiko-price-outer">
            <span class="currency"><?php echo $settings['currency_text'] ?></span>
            <span class="price"><?php echo $settings['price_text'] ?></span>
            <div class="decimal-outer">
                <span class="decimal"><?php echo $settings['decimal_text'] ?></span>
                <span class="duration"><?php echo $settings['duration_text'] ?></span>
            </div>
        </div>
        <?php
	}
}
