<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

/**
 * Elementor hostiko-hosting-feature-Widget.
 *
 * Elementor widget that uses the hostiko-hosting-feature control.
 *
 * @since 1.0.0
 */
class Elementor_Hostiko_Hosting_Feature_Widget extends \Elementor\Widget_Base {

	/**
	 * Get widget name.
	 *
	 * Retrieve hostiko-hosting-feature widget name.
	 *
	 * @since 1.0.0
	 * @access public
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'hostiko-hosting-feature';
	}

	/**
	 * Get widget title.
	 *
	 * Retrieve hostiko-hosting-feature widget title.
	 *
	 * @since 1.0.0
	 * @access public
	 * @return string Widget title.
	 */
	public function get_title() {
		return esc_html__( 'Hostiko Comparision Table', 'hostiko-toolkit' );
	}

	/**
	 * Get widget icon.
	 *
	 * Retrieve hostiko-hosting-feature widget icon.
	 *
	 * @since 1.0.0
	 * @access public
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'eicon-carousel-loop';
	}

	/**
	 * Register hostiko-hosting-feature widget controls.
	 *
	 * Add input fields to allow the user to customize the widget settings.
	 *
	 * @since 1.0.0
	 * @access protected
	 */
	protected function register_controls() {
		$this->start_controls_section(
			'table_heading_section',
			[
				'label' => esc_html__( 'Table Heading', 'hostiko-toolkit' ),
				'type' => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);
		$this->add_control(
			'table_heading', [
				'label' => __( 'TLD Heading', 'hostiko-toolkit' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => __( 'TLDs' , 'hostiko-toolkit' ),
				'label_block' => true,
			]
		);
        $this->end_controls_section();
		$this->start_controls_section(
			'shared_section',
			[
				'label' => esc_html__( 'Plan 1', 'hostiko-toolkit' ),
				'type' => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);
		$this->add_control(
			'shared_heading', [
				'label' => __( 'Shared Heading', 'hostiko-toolkit' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => __( 'Shared' , 'hostiko-toolkit' ),
				'label_block' => true,
			]
		);
		$this->add_control(
			'currency_text', [
				'label' => __( 'Currency', 'hostiko-toolkit' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => __( '$' , 'hostiko-toolkit' ),
				'label_block' => true,
			]
		);
        $this->add_control(
			'price_text', [
				'label' => __( 'Price', 'hostiko-toolkit' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => __( '12' , 'hostiko-toolkit' ),
				'label_block' => true,
			]
		);
        $this->add_control(
			'decimal_text', [
				'label' => __( 'Decimal', 'hostiko-toolkit' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => __( '.99' , 'hostiko-toolkit' ),
				'label_block' => true,
			]
		);
        $this->add_control(
			'duration_text', [
				'label' => __( 'Duration', 'hostiko-toolkit' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => __( '/month' , 'hostiko-toolkit' ),
				'label_block' => true,
			]
		);
		$this->add_control(
			'plan1_button_text', [
				'label' => __( 'Button text', 'hostiko-toolkit' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => __( 'Order now' , 'hostiko-toolkit' ),
				'label_block' => true,
			]
		);
        $this->add_control(
			'plan1_button_link', [
				'label' => __( 'Button link', 'hostiko-toolkit' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => __( '#' , 'hostiko-toolkit' ),
				'label_block' => true,
			]
		);
        $this->end_controls_section();
		$this->start_controls_section(
			'reseller_section',
			[
				'label' => esc_html__( 'Plan 2', 'hostiko-toolkit' ),
				'type' => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);
		$this->add_control(
			'reseller_heading', [
				'label' => __( 'Reseller Heading', 'hostiko-toolkit' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => __( 'Reseller' , 'hostiko-toolkit' ),
				'label_block' => true,
			]
		);
		$this->add_control(
			'currency_text1', [
				'label' => __( 'Currency', 'hostiko-toolkit' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => __( '$' , 'hostiko-toolkit' ),
				'label_block' => true,
			]
		);
        $this->add_control(
			'price_text1', [
				'label' => __( 'Price', 'hostiko-toolkit' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => __( '12' , 'hostiko-toolkit' ),
				'label_block' => true,
			]
		);
        $this->add_control(
			'decimal_text1', [
				'label' => __( 'Decimal', 'hostiko-toolkit' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => __( '.99' , 'hostiko-toolkit' ),
				'label_block' => true,
			]
		);
        $this->add_control(
			'duration_text1', [
				'label' => __( 'Duration', 'hostiko-toolkit' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => __( '/month' , 'hostiko-toolkit' ),
				'label_block' => true,
			]
		);
		$this->add_control(
			'plan2_button_text', [
				'label' => __( 'Button text', 'hostiko-toolkit' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => __( 'Order now' , 'hostiko-toolkit' ),
				'label_block' => true,
			]
		);
        $this->add_control(
			'plan2_button_link', [
				'label' => __( 'Button link', 'hostiko-toolkit' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => __( '#' , 'hostiko-toolkit' ),
				'label_block' => true,
			]
		);
        $this->end_controls_section();
		$this->start_controls_section(
			'vps_section',
			[
				'label' => esc_html__( 'Plan 3', 'hostiko-toolkit' ),
				'type' => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);
		$this->add_control(
			'vps_heading', [
				'label' => __( 'VPS Heading', 'hostiko-toolkit' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => __( 'VPS' , 'hostiko-toolkit' ),
				'label_block' => true,
			]
		);
		$this->add_control(
			'currency_text2', [
				'label' => __( 'Currency', 'hostiko-toolkit' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => __( '$' , 'hostiko-toolkit' ),
				'label_block' => true,
			]
		);
        $this->add_control(
			'price_text2', [
				'label' => __( 'Price', 'hostiko-toolkit' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => __( '12' , 'hostiko-toolkit' ),
				'label_block' => true,
			]
		);
        $this->add_control(
			'decimal_text2', [
				'label' => __( 'Decimal', 'hostiko-toolkit' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => __( '.99' , 'hostiko-toolkit' ),
				'label_block' => true,
			]
		);
        $this->add_control(
			'duration_text2', [
				'label' => __( 'Duration', 'hostiko-toolkit' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => __( '/month' , 'hostiko-toolkit' ),
				'label_block' => true,
			]
		);
		$this->add_control(
			'plan3_button_text', [
				'label' => __( 'Button text', 'hostiko-toolkit' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => __( 'Order now' , 'hostiko-toolkit' ),
				'label_block' => true,
			]
		);
        $this->add_control(
			'plan3_button_link', [
				'label' => __( 'Button link', 'hostiko-toolkit' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => __( '#' , 'hostiko-toolkit' ),
				'label_block' => true,
			]
		);
        $this->end_controls_section();
		$this->start_controls_section(
			'dedicated_section',
			[
				'label' => esc_html__( 'Plan 4', 'hostiko-toolkit' ),
				'type' => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);
		$this->add_control(
			'dedicated_heading', [
				'label' => __( 'Dedicated Heading', 'hostiko-toolkit' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => __( 'Dedicated' , 'hostiko-toolkit' ),
				'label_block' => true,
			]
		);
		$this->add_control(
			'currency_text3', [
				'label' => __( 'Currency', 'hostiko-toolkit' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => __( '$' , 'hostiko-toolkit' ),
				'label_block' => true,
			]
		);
        $this->add_control(
			'price_text3', [
				'label' => __( 'Price', 'hostiko-toolkit' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => __( '12' , 'hostiko-toolkit' ),
				'label_block' => true,
			]
		);
        $this->add_control(
			'decimal_text3', [
				'label' => __( 'Decimal', 'hostiko-toolkit' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => __( '.99' , 'hostiko-toolkit' ),
				'label_block' => true,
			]
		);
        $this->add_control(
			'duration_text3', [
				'label' => __( 'Duration', 'hostiko-toolkit' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => __( '/month' , 'hostiko-toolkit' ),
				'label_block' => true,
			]
		);
		$this->add_control(
			'plan4_button_text', [
				'label' => __( 'Button text', 'hostiko-toolkit' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => __( 'Order now' , 'hostiko-toolkit' ),
				'label_block' => true,
			]
		);
        $this->add_control(
			'plan4_button_link', [
				'label' => __( 'Button link', 'hostiko-toolkit' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => __( '#' , 'hostiko-toolkit' ),
				'label_block' => true,
			]
		);
        $this->end_controls_section();
		$this->start_controls_section(
			'content_section',
			[
				'label' => esc_html__( 'Content', 'hostiko-toolkit' ),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);

		$repeater = new \Elementor\Repeater();
    
		$repeater->add_control(
			'hostiko_icon', [
				'label' => esc_html__( 'Icon', 'elementor' ),
                'type' => \Elementor\Controls_Manager::ICONS,
                'fa4compatibility' => 'icon',
                'default' => [
                    'value' => 'fas fa-star',
                    'library' => 'fa-solid',
                ],
			]
		);
        $repeater->add_control(
			'feature_heading', [
				'label' => __( 'Heading', 'hostiko-toolkit' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => __( 'feature' , 'hostiko-toolkit' ),
				'label_block' => true,
			]
		);
		$repeater->add_control(
			'hostiko_icon1', [
				'label' => esc_html__( 'Icon', 'elementor' ),
                'type' => \Elementor\Controls_Manager::ICONS,
                'fa4compatibility' => 'icon',
                'default' => [
                    'value' => 'fas fa-star',
                    'library' => 'fa-solid',
                ],
			]
		);
        $repeater->add_control(
			'feature_heading1', [
				'label' => __( 'Plan Heading', 'hostiko-toolkit' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => __( 'feature' , 'hostiko-toolkit' ),
				'label_block' => true,
			]
		);
		$repeater->add_control(
			'hostiko_icon2', [
				'label' => esc_html__( 'Icon', 'elementor' ),
                'type' => \Elementor\Controls_Manager::ICONS,
                'fa4compatibility' => 'icon',
                'default' => [
                    'value' => 'fas fa-star',
                    'library' => 'fa-solid',
                ],
			]
		);
        $repeater->add_control(
			'feature_heading2', [
				'label' => __( 'Plan Heading 2', 'hostiko-toolkit' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => __( 'feature' , 'hostiko-toolkit' ),
				'label_block' => true,
			]
		);
		$repeater->add_control(
			'hostiko_icon3', [
				'label' => esc_html__( 'Icon', 'elementor' ),
                'type' => \Elementor\Controls_Manager::ICONS,
                'fa4compatibility' => 'icon',
                'default' => [
                    'value' => 'fas fa-star',
                    'library' => 'fa-solid',
                ],
			]
		);
        $repeater->add_control(
			'feature_heading3', [
				'label' => __( 'Plan Heading 3', 'hostiko-toolkit' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => __( 'feature' , 'hostiko-toolkit' ),
				'label_block' => true,
			]
		);
		$repeater->add_control(
			'hostiko_icon4', [
				'label' => esc_html__( 'Icon', 'elementor' ),
                'type' => \Elementor\Controls_Manager::ICONS,
                'fa4compatibility' => 'icon',
                'default' => [
                    'value' => 'fas fa-star',
                    'library' => 'fa-solid',
                ],
			]
		);
        $repeater->add_control(
			'feature_heading4', [
				'label' => __( 'Plan Heading 4', 'hostiko-toolkit' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => __( 'feature' , 'hostiko-toolkit' ),
				'label_block' => true,
			]
		);
		
        
		$this->add_control(
			'list',
			[
				'label' => __( 'Repeater List', 'hostiko-toolkit' ),
				'type' => \Elementor\Controls_Manager::REPEATER,
				'fields' => $repeater->get_controls(),
				'default' => [
					[
						'hostiko_tld_name' => __( 'TLD Name', 'hostiko-toolkit' ),
						'hostiko_tld_currency' => __( 'Currency', 'hostiko-toolkit' ),
						'hostiko_no_years' => __( 'Years', 'hostiko-toolkit' ),
						'hostiko_register_domain' => __( 'Register', 'hostiko-toolkit' ),
						'hostiko_transfer_domain' => __( 'Transfer', 'hostiko-toolkit' ),
						'hostiko_renew_domain' => __( 'Renew', 'hostiko-toolkit' ),
					],
					[
						'hostiko_tld_name' => __( 'TLD Name', 'hostiko-toolkit' ),
						'hostiko_tld_currency' => __( 'Currency', 'hostiko-toolkit' ),
						'hostiko_no_years' => __( 'Years', 'hostiko-toolkit' ),
						'hostiko_register_domain' => __( 'Register', 'hostiko-toolkit' ),
						'hostiko_transfer_domain' => __( 'Transfer', 'hostiko-toolkit' ),
						'hostiko_renew_domain' => __( 'Renew', 'hostiko-toolkit' ),
					],
				],
				'heading_field' => '{{{ list_heading }}}',
			]
		);
		
        $this->end_controls_section();

////////////////////////////////////////////////  Container Style Start /////////////////////////////////////////////////
$this->start_controls_section(
	'conatiner_tld_style_section',
	[
		'label' => esc_html__( 'Container Style', 'hostiko-toolkit' ),
		'tab' => \Elementor\Controls_Manager::TAB_STYLE,
	]
);


$this->add_group_control(
	\Elementor\Group_Control_Background::get_type(),
	[
		'name' => 'conatiner_tld_background',
		'label' => __( 'Background', 'hostiko-toolkit' ),
		'types' => [ 'classic', 'gradient', 'video' ],
		'selector' => '{{WRAPPER}} .Comprison_pricingplan #button-table-top table tbody tr:first-child td:first-child',
	]
);  
$this->add_group_control(
	\Elementor\Group_Control_Typography::get_type(),
	[
		'name' => 'header_typography',
		'label' => __( 'Typography', 'hostiko-toolkit' ),
		'selector' => '{{WRAPPER}} .Comprison_pricingplan #button-table-top table tbody tr:first-child td:first-child',
	]
);
$this->add_control(
	'header_color',
	[
		'label' => esc_html__('Color', 'hostiko-toolkit'),
		'type' => \Elementor\Controls_Manager::COLOR,
		'selectors' => [
			'{{WRAPPER}} .Comprison_pricingplan #button-table-top table tbody tr:first-child td:first-child' => 'color: {{VALUE}}',
		],
	]
);
$this->add_control(
	'header_alignment',
	[
		'label' => esc_html__('Alignment', 'hostiko-toolkit'),
		'type' => \Elementor\Controls_Manager::CHOOSE,
		'options' => [
			'left' => [
				'title' => esc_html__('Left', 'hostiko-toolkit'),
				'icon' => 'eicon-text-align-left',
			],
			'center' => [
				'title' => esc_html__('Center', 'hostiko-toolkit'),
				'icon' => 'eicon-text-align-center',
			],
			'right' => [
				'title' => esc_html__('Right', 'hostiko-toolkit'),
				'icon' => 'eicon-text-align-right',
			],
		],
		'default' => 'left',
		'selectors' => [
			'{{WRAPPER}}  .Comprison_pricingplan #button-table-top table tbody tr:first-child td:first-child' => 'text-align: {{VALUE}};',
		],
	]
);
$this->add_responsive_control(
	'conatiner_tld_border_radius',
	[
		'label' => __( 'Conatiner Border Radius', 'hostiko-toolkit' ),
		'type' => \Elementor\Controls_Manager::DIMENSIONS,
		'size_units' => [ 'px', '%', 'em' ],
		'selectors' => [
			'{{WRAPPER}} .Comprison_pricingplan #button-table-top table' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
			
		],
		
	]
);
$this->add_group_control(
	\Elementor\Group_Control_Border::get_type(),
	[
		'name' => 'conatiner_tld_border',
		'label' => __( 'Border', 'hostiko-toolkit' ),
		'selector' => '{{WRAPPER}} .Comprison_pricingplan #button-table-top table',
	]
);
$this->add_group_control(
	\Elementor\Group_Control_Box_Shadow::get_type(),
	[
		'name' => 'conatiner_tld_box_shadow',
		'selector' => '{{WRAPPER}} .Comprison_pricingplan #button-table-top table',
	]
);

$this->end_controls_section(); 
////////////////////////////////////////////////  Conatiner Style Ends ///////////////////////////////////////////////

////////////////////////////////////////////////  Header Style Start /////////////////////////////////////////////////
$this->start_controls_section(
	'header_style_section',
	[
		'label' => esc_html__( 'Header Style', 'hostiko-toolkit' ),
		'tab' => \Elementor\Controls_Manager::TAB_STYLE,
	]
);
$this->add_group_control(
	\Elementor\Group_Control_Typography::get_type(),
	[
		'name' => 'header1_typography',
		'label' => __( 'Typography', 'hostiko-toolkit' ),
		'selector' => '{{WRAPPER}} .Comprison_pricingplan h3.heading1',
	]
);
$this->add_control(
	'header1_color',
	[
		'label' => esc_html__('Color', 'hostiko-toolkit'),
		'type' => \Elementor\Controls_Manager::COLOR,
		'selectors' => [
			'{{WRAPPER}} .Comprison_pricingplan h3.heading1' => 'color: {{VALUE}}',
		],
	]
);
$this->add_responsive_control(
	'header_padding',
	[
		'label' => __( 'Padding', 'hostiko-toolkit' ),
		'type' => \Elementor\Controls_Manager::DIMENSIONS,
		'size_units' => [ 'px', '%', 'em' ],
		'selectors' => [
			'{{WRAPPER}} .Comprison_pricingplan #button-table-top table tbody tr td' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
		],
	]
); 

$this->add_group_control(
	\Elementor\Group_Control_Border::get_type(),
	[
		'name' => 'header_border',
		'label' => __( 'Border', 'hostiko-toolkit' ),
		'selector' => '{{WRAPPER}} .Comprison_pricingplan #button-table-top table tbody .main-tld-heading',
	]
);


	
$this->add_group_control(
	\Elementor\Group_Control_Background::get_type(),
	[
		'name' => 'header_background',
		'label' => __( 'Background', 'hostiko-toolkit' ),
		'types' => [ 'classic', 'gradient', 'video' ],
		'selector' => '{{WRAPPER}} .Comprison_pricingplan #button-table-top table tbody  .main-tld-heading',
	]
);  

$this->end_controls_section(); 
////////////////////////////////////////////////  Header Style Ends /////////////////////////////////////////////////

		/////////////////// Price widget control///////////////////

		// Style Tab Controls Start
        // Price Widget Controls Start
        $this->start_controls_section(
            'Price_widget_setting',
            [
                'label' => esc_html__( 'Price Widget', 'hostiko-toolkit' ),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_responsive_control(
			'price_widget_padding',
			[
				'label' => esc_html__( 'Padding', 'hostiko-toolkit' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
				'selectors' => [
					'{{WRAPPER}} .hostiko-price-outer' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);
        $this->add_responsive_control(
            'price_widget_align',
            [
                'label' => esc_html__( 'Price Widget Alignment', 'hostiko-toolkit' ),
                'type' => \Elementor\Controls_Manager::CHOOSE,
                'options' => [
                    'left' => [
                        'title' => esc_html__( 'Left', 'hostiko-toolkit' ),
                        'icon' => 'eicon-text-align-left',
                    ],
                    'center' => [
                        'title' => esc_html__( 'Center', 'hostiko-toolkit' ),
                        'icon' => 'eicon-text-align-center',
                    ],
                    'right' => [
                        'title' => esc_html__( 'Right', 'hostiko-toolkit' ),
                        'icon' => 'eicon-text-align-right',
                    ],
                ],
                'default' => 'left',
                'toggle' => true,
                'selectors' => [
                    '{{WRAPPER}} .hostiko-price-outer'   => 'text-align: {{VALUE}};',
                ],
            ]
        );
        $this->end_controls_section();
		// Currency Controls Start
		$this->start_controls_section(
            'currency_setting',
            [
                'label' => esc_html__( 'Currency', 'hostiko-toolkit' ),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_control(
			'currency_space',
			[
				'label' => esc_html__( 'Space', 'hostiko-toolkit' ),
				'type' => \Elementor\Controls_Manager::SLIDER,
				'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
				'range' => [
					'px' => [
						'min' => -100,
						'max' => 100,
						'step' => 1,
					],
					'%' => [
						'min' => 0,
						'max' => 100,
					],
				],
				'default' => [
					'unit' => 'px',
				],
				'selectors' => [
					'{{WRAPPER}} .hostiko-price-outer .currency' => 'top: {{SIZE}}{{UNIT}};',
				],
			]
		);
		$this->add_control(
            'currency_color',
            [
                'label' => esc_html__( 'Currency Color', 'hostiko-toolkit' ),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .hostiko-price-outer .currency' => 'color: {{VALUE}}',
                ],
                'global' => [
                    'default' => \Elementor\Core\Kits\Documents\Tabs\Global_Colors::COLOR_PRIMARY,
                ],
            ]
        );
        $this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name' => 'currency_typography',
				'selector' => '{{WRAPPER}} .hostiko-price-outer .currency',
			]
		);
        $this->end_controls_section();
		// Currency Controls End
		
		// Price Controls Start
        $this->start_controls_section(
            'price_setting',
            [
                'label' => esc_html__( 'Price', 'hostiko-toolkit' ),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_responsive_control(
			'price_padding',
			[
				'label' => esc_html__( 'Padding', 'hostiko-toolkit' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
				'selectors' => [
					'{{WRAPPER}} .hostiko-price-outer .price' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);
		$this->add_control(
            'price_color',
            [
                'label' => esc_html__( 'Price Color', 'hostiko-toolkit' ),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .hostiko-price-outer .price' => 'color: {{VALUE}}',
                ],
                'global' => [
                    'default' => \Elementor\Core\Kits\Documents\Tabs\Global_Colors::COLOR_PRIMARY,
                ],
            ]
        );
        $this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name' => 'price_typography',
				'selector' => '{{WRAPPER}} .hostiko-price-outer .price',
			]
		);
        $this->end_controls_section();
		// Price Controls End

		// Decimal Controls Start
		$this->start_controls_section(
            'decimal_setting',
            [
                'label' => esc_html__( 'Decimal', 'hostiko-toolkit' ),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_responsive_control(
			'decimal_padding',
			[
				'label' => esc_html__( 'Padding', 'hostiko-toolkit' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
				'selectors' => [
					'{{WRAPPER}} .hostiko-price-outer .decimal-outer .decimal' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);
		$this->add_control(
            'decimal_color',
            [
                'label' => esc_html__( 'Decimal Color', 'hostiko-toolkit' ),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .hostiko-price-outer .decimal-outer .decimal' => 'color: {{VALUE}}',
                ],
                'global' => [
                    'default' => \Elementor\Core\Kits\Documents\Tabs\Global_Colors::COLOR_PRIMARY,
                ],
            ]
        );
        $this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name' => 'decimal_typography',
				'selector' => '{{WRAPPER}} .hostiko-price-outer .decimal-outer .decimal',
			]
		);
        $this->add_responsive_control(
            'decimal_position',
            [
                'label' => esc_html__( 'Decimal Position', 'hostiko-toolkit' ),
                'type' => \Elementor\Controls_Manager::CHOOSE,
                'options' => [
                    'inline-block' => [
                        'title' => esc_html__( 'Left', 'hostiko-toolkit' ),
                        'icon' => 'eicon-h-align-left',
                    ],
                    'block' => [
                        'title' => esc_html__( 'Top', 'hostiko-toolkit' ),
                        'icon' => 'eicon-v-align-top',
                    ],
                ],
                'default' => 'block',
                'toggle' => true,
                'selectors' => [
                    '{{WRAPPER}} .hostiko-price-outer .decimal-outer .decimal'   => 'display: {{VALUE}};',
                ],
            ]
        );
        $this->end_controls_section();
		// Decimal Controls End   

        // Duration Controls Start
		$this->start_controls_section(
            'duration_setting',
            [
                'label' => esc_html__( 'Duration', 'hostiko-toolkit' ),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_responsive_control(
			'duration_padding',
			[
				'label' => esc_html__( 'Padding', 'hostiko-toolkit' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
				'selectors' => [
					'{{WRAPPER}} .hostiko-price-outer .decimal-outer .duration' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);
		$this->add_control(
            'duration_color',
            [
                'label' => esc_html__( 'Duration Color', 'hostiko-toolkit' ),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .hostiko-price-outer .decimal-outer .duration' => 'color: {{VALUE}}',
                ],
                'global' => [
                    'default' => \Elementor\Core\Kits\Documents\Tabs\Global_Colors::COLOR_TEXT,
                ],
            ]
        );
        $this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name' => 'duration_typography',
				'selector' => '{{WRAPPER}} .hostiko-price-outer .decimal-outer .duration',
			]
		);
        $this->end_controls_section();
		
		
		////////////////////////////////////////////////  Content Style  ///////////////////////////////////////////////// 
        $this->start_controls_section(
			'content_style_section',
			[
				'label' => esc_html__( 'Content Style', 'hostiko-toolkit' ),
				'tab' => \Elementor\Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name' => 'content_typography',
				'label' => __( 'Typography', 'hostiko-toolkit' ),
				'selector' => '{{WRAPPER}} .Comprison_pricingplan #button-table-top .bg-main',
			]
		);
        $this->add_control(
            'content_color',
            [
                'label' => esc_html__('Label Color', 'hostiko-toolkit'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .Comprison_pricingplan #button-table-top .bg-main' => 'color: {{VALUE}}',
                ],
            ]
        );
		$this->add_control(
	'header1_alignment',
	[
		'label' => esc_html__('Alignment', 'hostiko-toolkit'),
		'type' => \Elementor\Controls_Manager::CHOOSE,
		'options' => [
			'left' => [
				'title' => esc_html__('Left', 'hostiko-toolkit'),
				'icon' => 'eicon-text-align-left',
			],
			'center' => [
				'title' => esc_html__('Center', 'hostiko-toolkit'),
				'icon' => 'eicon-text-align-center',
			],
			'right' => [
				'title' => esc_html__('Right', 'hostiko-toolkit'),
				'icon' => 'eicon-text-align-right',
			],
		],
		'default' => 'left',
		'selectors' => [
			'{{WRAPPER}}  .Comprison_pricingplan #button-table-top .bg-main' => 'text-align: {{VALUE}};',
		],
	]
);
        
        $this->add_group_control(
            \Elementor\Group_Control_Background::get_type(),
            [
                'name' => 'content_background-even',
				'label' => __( 'Background Even', 'hostiko-toolkit' ),
                'types' => [ 'classic', 'gradient', 'video' ],
                'selector' => '{{WRAPPER}} .Comprison_pricingplan #button-table-top .bg-main',
            ]
        );
		$this->add_group_control(
            \Elementor\Group_Control_Border::get_type(),
            [
                'name' => 'content_border',
                'label' => __( 'Border', 'hostiko-toolkit' ),
                'selector' => '{{WRAPPER}} .Comprison_pricingplan #button-table-top table tbody .bg-main',
            ]
        );
        $this->add_responsive_control(
			'content_border_radius',
			[
				'label' => __( 'Border Radius', 'hostiko-toolkit' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'selectors' => [
					'{{WRAPPER}} .Comprison_pricingplan #button-table-top table tbody .bg-main' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					
				],
				
			]
		);
		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name' => 'content2_typography',
				'label' => __( 'Typography', 'hostiko-toolkit' ),
				'selector' => '{{WRAPPER}} .Comprison_pricingplan .t-2',
			]
		);
        $this->add_control(
            'content2_color',
            [
                'label' => esc_html__('Color', 'hostiko-toolkit'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .Comprison_pricingplan .t-2' => 'color: {{VALUE}}',
                ],
            ]
        );  
        $this->add_group_control(
            \Elementor\Group_Control_Background::get_type(),
            [
                'name' => 'content_background-odd',
				'label' => __( 'Background Odd', 'hostiko-toolkit' ),
                'types' => [ 'classic', 'gradient', 'video' ],
                'selector' => '{{WRAPPER}} .Comprison_pricingplan #button-table-top .bg-color-1',
            ]
        ); 
		$this->add_group_control(
            \Elementor\Group_Control_Border::get_type(),
            [
                'name' => 'content1_border',
                'label' => __( 'Border', 'hostiko-toolkit' ),
                'selector' => '{{WRAPPER}} .Comprison_pricingplan #button-table-top table tbody .bg-color-1',
            ]
        );
        $this->add_responsive_control(
			'content1_border_radius',
			[
				'label' => __( 'Border Radius', 'hostiko-toolkit' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'selectors' => [
					'{{WRAPPER}} .Comprison_pricingplan #button-table-top table tbody .bg-main1' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					
				],
				
			]
		);   
		$this->end_controls_section();
		/////////////////////////////////////////////BUTTON STYLE////////////////////////////////////////////
		$this->start_controls_section(
			'button_style_section',
			[
				'label' => esc_html__( 'Button Style', 'hostiko-toolkit' ),
				'tab' => \Elementor\Controls_Manager::TAB_STYLE,
			]
		);
        $this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name' => 'button_typography',
				'label' => __( 'Typography', 'hostiko-toolkit' ),
				'selector' => '{{WRAPPER}} .Comprison_pricingplan #button-table-top table tbody tr:last-child td a',
			]
		);
        $this->start_controls_tabs(
			'style_tabs'
		);

		$this->start_controls_tab(
			'style_normal_tab',
			[
				'label' => esc_html__( 'Normal', 'hostiko-toolkit' ),
			]
		);
        $this->add_control(
            'button__text_color',
            [
                'label' => esc_html__('Color', 'hostiko-toolkit'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .Comprison_pricingplan #button-table-top table tbody tr:last-child td a' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
			\Elementor\Group_Control_Background::get_type(),
			[
				'name' => 'background',
				'types' => [ 'classic', 'gradient', ],
				'selector' => '{{WRAPPER}} .Comprison_pricingplan #button-table-top table tbody tr:last-child td a',
			]
		);
        $this->add_group_control(
            \Elementor\Group_Control_Border::get_type(),
            [
                'name' => 'button_border',
                'label' => __( 'Border', 'hostiko-toolkit' ),
                'selector' => '{{WRAPPER}} .Comprison_pricingplan #button-table-top table tbody tr:last-child td a',
            ]
        );
        $this->add_responsive_control(
			'button_border_radius',
			[
				'label' => __( 'Border Radius', 'hostiko-toolkit' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'selectors' => [
					'{{WRAPPER}} .Comprison_pricingplan #button-table-top table tbody tr:last-child td a' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					
				],
				
			]
		);
		$this->add_group_control(
			\Elementor\Group_Control_Box_Shadow::get_type(),
			[
				'name' => 'button_box_shadow',
				'selector' => '{{WRAPPER}} .Comprison_pricingplan #button-table-top table tbody tr:last-child td a',
			]
		);
        $this->add_responsive_control(
			'button_padding',
			[
				'label' => __( 'Padding', 'hostiko-toolkit' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'selectors' => [
					'{{WRAPPER}}  .Comprison_pricingplan #button-table-top table tbody tr:last-child td a' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		); 
		$this->add_control(
            'button_alignment',
            [
                'label' => esc_html__('Alignment', 'hostiko-toolkit'),
                'type' => \Elementor\Controls_Manager::CHOOSE,
                'options' => [
                    'left' => [
                        'title' => esc_html__('Left', 'hostiko-toolkit'),
                        'icon' => 'eicon-text-align-left',
                    ],
                    'center' => [
                        'title' => esc_html__('Center', 'hostiko-toolkit'),
                        'icon' => 'eicon-text-align-center',
                    ],
                    'right' => [
                        'title' => esc_html__('Right', 'hostiko-toolkit'),
                        'icon' => 'eicon-text-align-right',
                    ],
                ],
                'default' => 'left',
                'selectors' => [
                    '{{WRAPPER}}  .Comprison_pricingplan #button-table-top table tbody tr:last-child td a' => 'text-align: {{VALUE}};',
                ],
            ]
        );
		$this->end_controls_tab();
		
		$this->start_controls_tab(
			'style_hover_tab',
			[
				'label' => esc_html__( 'Hover', 'hostiko-toolkit' ),
			]
		);
        $this->add_control(
            'button__text_hover_color',
            [
                'label' => esc_html__('Color', 'hostiko-toolkit'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .Comprison_pricingplan #button-table-top table tbody tr:last-child td a:hover' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
			\Elementor\Group_Control_Background::get_type(),
			[
				'name' => 'Hover background',
				'types' => [ 'classic', 'gradient', ],
				'selector' => '{{WRAPPER}} .Comprison_pricingplan #button-table-top table tbody tr:last-child td a:hover',
			]
		);
        $this->add_group_control(
            \Elementor\Group_Control_Border::get_type(),
            [
                'name' => 'button_border_hover',
                'label' => __( 'Border', 'hostiko-toolkit' ),
                'selector' => '{{WRAPPER}} .Comprison_pricingplan #button-table-top table tbody tr:last-child td a:hover',
            ]
        );
        $this->add_responsive_control(
			'button_border_radius_hover',
			[
				'label' => __( 'Border Radius Hover', 'hostiko-toolkit' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'selectors' => [
					'{{WRAPPER}} .Comprison_pricingplan #button-table-top table tbody tr:last-child td a:hover' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					
				],
				
			]
		);
		$this->add_group_control(
			\Elementor\Group_Control_Box_Shadow::get_type(),
			[
				'name' => 'button_box_shadow_hover',
				'selector' => '{{WRAPPER}} .Comprison_pricingplan #button-table-top table tbody tr:last-child td a:hover',
			]
		);
       
        $this->end_controls_tab();
		$this->end_controls_tabs();
		$this->end_controls_section();
		////////////////////////////////////////////////////////////////tabs style////////////////////////////////////////////////////
		$this->start_controls_section(
			'tabs_style_section',
			[
				'label' => esc_html__( 'Tabs Style', 'hostiko-toolkit' ),
				'tab' => \Elementor\Controls_Manager::TAB_STYLE,
			]
		);
        $this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name' => 'tabs_typography',
				'label' => __( 'Typography', 'hostiko-toolkit' ),
				'selector' => '{{WRAPPER}} .Comprison_pricingplan #button-table-top li',
			]
		);
		$this->start_controls_tabs(
			'style1_tabs'
		);
		$this->start_controls_tab(
			'style1_normal_tab',
			[
				'label' => esc_html__( 'Normal', 'hostiko-toolkit' ),
			]
		);
        $this->add_control(
            'tabs__text_color',
            [
                'label' => esc_html__('Color', 'hostiko-toolkit'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .Comprison_pricingplan #button-table-top li' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
			\Elementor\Group_Control_Background::get_type(),
			[
				'name' => 'background1',
				'types' => [ 'classic', 'gradient', ],
				'selector' => '{{WRAPPER}} .Comprison_pricingplan #button-table-top li',
			]
		);
        $this->add_group_control(
            \Elementor\Group_Control_Border::get_type(),
            [
                'name' => 'tabs_border',
                'label' => __( 'Border', 'hostiko-toolkit' ),
                'selector' => '{{WRAPPER}} .Comprison_pricingplan #button-table-top li',
            ]
        );
        $this->add_responsive_control(
			'tabs_border_radius',
			[
				'label' => __( 'Border Radius', 'hostiko-toolkit' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'selectors' => [
					'{{WRAPPER}} .Comprison_pricingplan #button-table-top li' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					
				],
				
			]
		);
		$this->add_group_control(
			\Elementor\Group_Control_Box_Shadow::get_type(),
			[
				'name' => 'tabs_box_shadow',
				'selector' => '{{WRAPPER}} .Comprison_pricingplan #button-table-top li',
			]
		);
        $this->add_responsive_control(
			'tabs_padding',
			[
				'label' => __( 'Padding', 'hostiko-toolkit' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'selectors' => [
					'{{WRAPPER}}  .Comprison_pricingplan #button-table-top li' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		); 
		$this->end_controls_tab();

		$this->start_controls_tab(
			'style1_hover_tab',
			[
				'label' => esc_html__( 'Hover', 'hostiko-toolkit' ),
			]
		);
        $this->add_control(
            'tabs__text_hover_color',
            [
                'label' => esc_html__('Color', 'hostiko-toolkit'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .Comprison_pricingplan #button-table-top li:hover' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
			\Elementor\Group_Control_Background::get_type(),
			[
				'name' => 'Hover background1',
				'types' => [ 'classic', 'gradient', ],
				'selector' => '{{WRAPPER}} .Comprison_pricingplan #button-table-top li:hover',
			]
		);
        $this->add_group_control(
            \Elementor\Group_Control_Border::get_type(),
            [
                'name' => 'tabs_border_hover',
                'label' => __( 'Border', 'hostiko-toolkit' ),
                'selector' => '{{WRAPPER}} .Comprison_pricingplan #button-table-top li:hover',
            ]
        );
        $this->add_responsive_control(
			'tabs_border_radius_hover',
			[
				'label' => __( ' Border Radius', 'hostiko-toolkit' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'selectors' => [
					'{{WRAPPER}} .Comprison_pricingplan #button-table-top li:hover' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					
				],
				
			]
		);
		$this->add_group_control(
			\Elementor\Group_Control_Box_Shadow::get_type(),
			[
				'name' => 'tabs_box_shadow_hover',
				'selector' => '{{WRAPPER}} .Comprison_pricingplan #button-table-top li:hover',
			]
		);
       
        $this->end_controls_tab();

		$this->start_controls_tab(
			'style1_active_tab',
			[
				'label' => esc_html__( 'Active', 'hostiko-toolkit' ),
			]
		);
        $this->add_control(
            'tabs__text_active_color',
            [
                'label' => esc_html__('Color', 'hostiko-toolkit'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .Comprison_pricingplan #button-table-top li.active' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
			\Elementor\Group_Control_Background::get_type(),
			[
				'name' => 'Active background1',
				'types' => [ 'classic', 'gradient', ],
				'selector' => '{{WRAPPER}} .Comprison_pricingplan #button-table-top li.active',
			]
		);
        $this->add_group_control(
            \Elementor\Group_Control_Border::get_type(),
            [
                'name' => 'tabs_border_active',
                'label' => __( 'Border', 'hostiko-toolkit' ),
                'selector' => '{{WRAPPER}} .Comprison_pricingplan #button-table-top li.active',
            ]
        );
        $this->add_responsive_control(
			'tabs_border_radius_active',
			[
				'label' => __( ' Border Radius', 'hostiko-toolkit' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'selectors' => [
					'{{WRAPPER}} .Comprison_pricingplan #button-table-top li.active' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					
				],
				
			]
		);
		$this->add_group_control(
			\Elementor\Group_Control_Box_Shadow::get_type(),
			[
				'name' => 'tabs_box_shadow_active',
				'selector' => '{{WRAPPER}} .Comprison_pricingplan #button-table-top li.active',
			]
		);
       
        $this->end_controls_tab();
		$this->end_controls_section();
        /////////////////////////////////////////////////////////////////////////////////////////////////////////////////
        

	}


	/**
	 * Render hostiko-tld-table widget output on the frontend.
	 *
	 * Written in PHP and used to generate the final HTML.
	 *
	 * @since 1.0.0
	 * @access protected
	 */
	protected function render() {
		$settings = $this->get_settings_for_display();
				?>
				<div class="Comprison_pricingplan">
				<article id="button-table-top">

					<ul id="button-table-top">
						<li class="default active tabs-list"><?php echo $settings['shared_heading'] ?></li>
						<li class="tabs-list"><?php echo $settings['reseller_heading'] ?></li>
						<li class="tabs-list"><?php echo $settings['vps_heading'] ?></li>
						<li class="tabs-list"><?php echo $settings['dedicated_heading'] ?></li>
					</ul>
					<table class="hosting-feature-table">
						<thead>
							<tr>
							<th class="hide2">
							</th>
								<th class="default active"><div class="pricing-box"></div></th>
								<th><div class="pricing-box premium-box"></div></th>
								<th><div class="pricing-box premium-box"></div></th>
								<th><div class="pricing-box premium-box"></div></th>
							</tr>
						</thead>
						<tbody>
							<tr class="tbl_content tbl_body_content">
								<td class="bg-color "><?php echo $settings['table_heading'] ?> </td>
								<td class="main-tld-heading" style="display: table-cell;">
									<h3 class="heading1"><?php echo $settings['shared_heading'] ?></h3><span class="price-t left-t">
										<div class="hostiko-price-outer">
												<span class="currency"><?php echo $settings['currency_text'] ?></span>
												<span class="price"><?php echo $settings['price_text'] ?></span>
												<div class="decimal-outer">
													<span class="decimal"><?php echo $settings['decimal_text'] ?></span>
													<span class="duration"><?php echo $settings['duration_text'] ?></span>
												</div>
											</div>
										</span>
								</td>
								<td class="main-tld-heading" style="display: none;">
									<h3 class="heading1"><?php echo $settings['reseller_heading'] ?></h3><span class="price-t">
									<div class="hostiko-price-outer">
												<span class="currency"><?php echo $settings['currency_text1'] ?></span>
												<span class="price"><?php echo $settings['price_text1'] ?></span>
												<div class="decimal-outer">
													<span class="decimal"><?php echo $settings['decimal_text1'] ?></span>
													<span class="duration"><?php echo $settings['duration_text1'] ?></span>
												</div>
											</div>
									</span>
								</td>
								<td class="main-tld-heading" style="display: none;">
									<h3 class="heading1"><?php echo $settings['vps_heading'] ?></h3>
									<span class="price-t">
									<div class="hostiko-price-outer">
												<span class="currency"><?php echo $settings['currency_text2'] ?></span>
												<span class="price"><?php echo $settings['price_text2'] ?></span>
												<div class="decimal-outer">
													<span class="decimal"><?php echo $settings['decimal_text2'] ?></span>
													<span class="duration"><?php echo $settings['duration_text2'] ?></span>
												</div>
											</div>
									</span>
								</td>
								<td class="main-tld-heading" style="display: none;">
									<h3 class="heading1"><?php echo $settings['dedicated_heading'] ?></h3>
									<span class="price-t">
									<div class="hostiko-price-outer">
												<span class="currency"><?php echo $settings['currency_text3'] ?></span>
												<span class="price"><?php echo $settings['price_text3'] ?></span>
												<div class="decimal-outer">
													<span class="decimal"><?php echo $settings['decimal_text3'] ?></span>
													<span class="duration"><?php echo $settings['duration_text3'] ?></span>
												</div>
											</div>
									</span>
								</td>

							</tr>
								<?php
									$count = 0;
									if ( $settings['list'] ) {
									foreach ( $settings['list'] as $item ) {	
								?>
								<tr class="tbl_content tbl_body_content">
								<td class="bg-main"><i class="hostiko_icon <?php echo $item['hostiko_icon']['value']; ?>"></i><?php echo $item['feature_heading'] ?></td>
								<td class="default bg-color-1"><span class="t-2"><i class="hostiko_icon1 <?php echo $item['hostiko_icon1']['value']; ?>"></i><?php echo $item['feature_heading1'] ?></span></td>
								<td class="bg-color-1"><span class="t-2"><i class="hostiko_icon2 <?php echo $item['hostiko_icon2']['value']; ?>"></i><?php echo $item['feature_heading2'] ?></span></td>
								<td class="bg-color-1"><span class="t-2"><i class="hostiko_icon3 <?php echo $item['hostiko_icon3']['value']; ?>"></i><?php echo $item['feature_heading3'] ?></span></td>
								<td class="bg-color-1"><span class="t-2"><i class="hostiko_icon4 <?php echo $item['hostiko_icon4']['value']; ?>"></i><?php echo $item['feature_heading4'] ?></span></td>
							</tr>
							<?php
								$count++;
							}
							}
							?>
							<tr class="tbl_content tbl_body_content">
								<td></td>
								<td class="bg-color-1"><a
									href="<?php echo $settings['plan1_button_link'] ?>"
									class="button1"><?php echo $settings['plan1_button_text'] ?></a></td>
								<td class="bg-color-1"><a
									href="<?php echo $settings['plan2_button_link'] ?>"
									class="button1"><?php echo $settings['plan2_button_text'] ?></a></td>
								<td class="bg-color-1"><a
									href="<?php echo $settings['plan3_button_link'] ?>"
									class="button1"><?php echo $settings['plan3_button_text'] ?></a></td>
								<td class="bg-color-1"><a
									href="<?php echo $settings['plan4_button_link'] ?>"
									class="button1"><?php echo $settings['plan4_button_text'] ?></a></td>
							</tr>
						</tbody>
					</table>
					</article>
					
				</div>
				
				
			<?php
				
	}
	

}
?>
