<?php
use Elementor\Widget_Base;
use Elementor\Controls_Manager;
 
class Elementor_Hostiko_Data_Centers_Widget extends Widget_Base {
    /**
     * Get widget name.
     *
     * @return string
     */
    public function get_name() {
        return 'hostiko-data-centers';
    }
 
    /**
     * Get widget title.
     *
     * @return string
     */
    public function get_title() {
       return esc_html__( 'Hostiko Data Centers', 'hostiko-toolkit' );
    }
 
    /**
     * Get widget icon.
     *
     * @return string
     */
    public function get_icon() {
        return 'eicon-tabs';
    }
 
    /**
     * Get widget categories.
     *
     * @return array
     */
    public function get_categories() {
        return ['general'];
    }
 
    /**
     * Register controls and settings.
     */
    protected function _register_controls() {
        // Define your controls for the widget settings here.
        // You'll need to define controls for tab titles and content.
        // You can use repeater controls to allow multiple tabs.
 
        $this->start_controls_section(
            'section_tabs',
            [
                'label' => esc_html__( 'Tabs', 'hostiko-toolkit' ),
            ]
        );
 
        $repeater = new \Elementor\Repeater();
 
        // Existing controls for the outer repeater
        $repeater->add_control(
            'tab_title',
            [
                'label' => esc_html__( 'Tab Title', 'hostiko-toolkit' ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => esc_html__( 'Tab Title', 'hostiko-toolkit' ),
                'label_block' => true,
            ]
        );
 
        $repeater->add_control(
            'hostiko_tab_icon',
            [
                'label' => esc_html__( 'Icon', 'elementor' ),
                'type' => \Elementor\Controls_Manager::ICONS,
                'fa4compatibility' => 'icon',
                'default' => [
                    'value' => 'fas fa-star',
                    'library' => 'fa-solid',
                ],
            ]
        );
 
        $repeater->add_control(
            'data_center_image',
            [
                'label' => esc_html__( 'Choose Data Center Image', 'hostiko-toolkit' ),
                'type' => \Elementor\Controls_Manager::MEDIA,
                'default' => [
                    'url' => \Elementor\Utils::get_placeholder_image_src(),
                ],
            ]
        );
 
        $repeater->add_control(
            'tab_content',
            [
                'label' => esc_html__( 'Content', 'hostiko-toolkit' ),
                'type' => Controls_Manager::WYSIWYG,
                'default' => 'Nam libero tempore, cum soluta nobis est eligendi optio cumque nihil impedit
                quod maxime placeat facere possimus, omnis voluptas assumenda est, omnis
                Temporibus autem quibusdam et aut officiis debitis aut rerum necessitatibus
                voluptates repudiandae sint et molestiae non recusandae. ',
            ]
        );
        $this->add_control(
            'tabs',
            [
                'label' => esc_html__( 'Tabs', 'hostiko-toolkit' ),
                'type' => \Elementor\Controls_Manager::REPEATER,
                'fields' => $repeater->get_controls(),
                'default' => [
                    [
                        'tab_title' => esc_html__( 'Tab 1', 'hostiko-toolkit' ),
                        'tab_heading' => 'Tab Heading 1',
                        'data_center_image' => 'Data Center Image',
                        'icon_list' => [
                            [
                                'icon' => 'fas fa-star',
                                'label' => 'Star',
                            ],
                            // Add more icons as needed
                        ],
                    ],
                    [
                        'tab_title' => esc_html__( 'Tab 2', 'hostiko-toolkit' ),
                        'tab_heading' => 'Tab Heading 2',
                        'data_center_image' => 'Data Center Image',
                        'icon_list' => [
                            [
                                'icon' => 'fas fa-heart',
                                'label' => 'Heart',
                            ],
                            // Add more icons as needed
                        ],
                    ],
                ],
                'title_field' => '{{{ tab_title }}}',
            ]
        );
 
 
        $this->end_controls_section();
        $this->start_controls_section(
            'tabs_style',
            [
                'label' => esc_html__( 'Tabs Style', 'hostiko-toolkit' ),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_control(
            'text_color',
            [
                'label' => esc_html__( 'Text Color', 'hostiko-toolkit' ),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} #hostiko_custom_tabs #myTab' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'text_active_color',
            [
                'label' => esc_html__( 'Active Color', 'hostiko-toolkit' ),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} #hostiko_custom_tabs .nav-pills .nav-link.active' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            \Elementor\Group_Control_Background::get_type(),
            [
                'name' => 'tabs_active_background',
                'types' => [ 'classic', 'gradient', 'video' ],
                'selector' => '{{WRAPPER}} #hostiko_custom_tabs .nav-pills .nav-link.active',
            ]
        );
        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'name' => 'tabs_typography',
                'label' => __( 'Typography', 'hostiko-toolkit' ),
                'selector' => '{{WRAPPER}} #hostiko_custom_tabs #myTab',
            ]
        );
        $this->add_responsive_control(
            'tabs_padding_outter',
            [
                'label' => __( 'Padding', 'hostiko-toolkit' ),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%', 'em' ],
                'selectors' => [
                    '{{WRAPPER}} #hostiko_custom_tabs #data-center-tabs' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->start_controls_tabs(
            'style_order_tabs'
        );
            $this->start_controls_tab(
                'style_order_normal_tab',
                    [
                        'label' => esc_html__( 'Normal', 'hostiko-toolkit' ),
                    ]
                );
 
                $this->add_group_control(
                    \Elementor\Group_Control_Background::get_type(),
                    [
                        'name' => 'tabs_background',
                        'types' => [ 'classic', 'gradient', 'video' ],
                        'selector' => '{{WRAPPER}} #hostiko_custom_tabs .nav-item',
                    ]
                );
 
               
                $this->add_group_control(
                    \Elementor\Group_Control_Border::get_type(),
                    [
                        'name' => 'tabs_border',
                        'selector' => '{{WRAPPER}} #hostiko_custom_tabs .nav-pills .nav-link',
                    ]
                );
 
 
                $this->add_responsive_control(
                    'tabs_border_radius',
                    [
                        'label' => esc_html__( 'Border Radius', 'elementor' ),
                        'type' => \Elementor\Controls_Manager::DIMENSIONS,
                        'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
                        'selectors' => [
                            '{{WRAPPER}} #hostiko_custom_tabs .nav-item' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                        ],
                    ]
                );
            $this->end_controls_tab();
 
            $this->start_controls_tab(
                'style_order_hover_tab',
                [
                    'label' => esc_html__( 'Hover', 'hostiko-toolkit' ),
                ]
            );
           
            $this->add_control(
                'text_hover1_color',
                [
                    'label' => esc_html__( 'Text Color', 'hostiko-toolkit' ),
                    'type' => \Elementor\Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} #hostiko_custom_tabs .nav-pills .nav-link:hover span' => 'color: {{VALUE}}',
                    ],
                ]
            );
            $this->add_group_control(
                \Elementor\Group_Control_Background::get_type(),
                [
                    'name' => 'tabs_hover_background',
                    'types' => [ 'classic', 'gradient', 'video'],
                    'selector' => '{{WRAPPER}} #hostiko_custom_tabs .nav-item:hover',
                ]
            );
 
            $this->add_group_control(
                \Elementor\Group_Control_Border::get_type(),
                [
                    'name' => 'tabs_hover_border',
                    'selector' => '{{WRAPPER}} #hostiko_custom_tabs .nav-pills .nav-link.active',
                ]
            );
 
 
            $this->add_responsive_control(
                'tabs_hover_border_radius',
                [
                    'label' => esc_html__( 'Border Radius', 'elementor' ),
                    'type' => \Elementor\Controls_Manager::DIMENSIONS,
                    'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
                    'selectors' => [
                        '{{WRAPPER}} #hostiko_custom_tabs .nav-item:hover' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    ],
                ]
            );
            $this->end_controls_tab();
        $this->end_controls_tabs();
        $this->add_responsive_control(
            'tabs_padding',
            [
                'label' => __( 'Padding', 'hostiko-toolkit' ),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%', 'em' ],
                'selectors' => [
                    '{{WRAPPER}} #hostiko_custom_tabs .nav-pills .nav-link' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'tabs_margin',
            [
                'label' => __( 'Margin', 'hostiko-toolkit' ),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%', 'em' ],
                'selectors' => [
                    '{{WRAPPER}} #hostiko_custom_tabs .nav-pills .nav-item' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_control(
            'width',
            [
                'label' => esc_html__( 'Image Width', 'hostiko-toolkit' ),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 1000,
                        'step' => 5,
                    ],
                    '%' => [
                        'min' => 0,
                        'max' => 100,
                    ],
                ],
                'default' => [
                    'unit' => '%',
                    'size' => 50,
                ],
                'selectors' => [
                    '{{WRAPPER}} #hostiko_custom_tabs ul .nav-item .nav-link .tab_tltle img' => 'width: {{SIZE}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'image_margin',
            [
                'label' => __( 'Margin', 'hostiko-toolkit' ),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%', 'em' ],
                'selectors' => [
                    '{{WRAPPER}} #hostiko_custom_tabs ul .nav-item .nav-link .tab_tltle img' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_group_control(
            \Elementor\Group_Control_Css_Filter::get_type(),
            [
                'name' => 'custom_css_filters',
                'selector' => '{{WRAPPER}} #hostiko_custom_tabs ul .nav-item .nav-link .tab_tltle img',
            ]
        );
        $this->add_control(
            'size_control',
            [
                'label' => __('Icon Size', 'hostiko-toolkit'),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'selectors' => [
                    '{{WRAPPER}} #hostiko_custom_tabs ul .nav-item .nav-link .tab-title-icon' => 'font-size: {{SIZE}}px !important;',
                ],
            ]
        );
        $this->add_control(
            'icon_color',
            [
                'label' => esc_html__( 'Icon Color', 'hostiko-toolkit' ),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} #hostiko_custom_tabs ul .nav-item .nav-link .tab-title-icon' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'active_icon_color',
            [
                'label' => esc_html__( 'Active Color', 'hostiko-toolkit' ),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} #hostiko_custom_tabs .nav-pills .nav-link.active .tab-title-icon' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'hover_icon_color',
            [
                'label' => esc_html__( 'Hover Color', 'hostiko-toolkit' ),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} #hostiko_custom_tabs .nav-pills .nav-link:hover .tab-title-icon' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->end_controls_section();
        $this->start_controls_section(
            'heading_style',
            [
                'label' => esc_html__( 'Heading Style', 'hostiko-toolkit' ),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_control(
            'heading_color',
            [
                'label' => esc_html__( 'Heading Color', 'hostiko-toolkit' ),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}}  .tab-content h2' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'name' => 'heading_typography',
                'label' => __( 'Typography', 'hostiko-toolkit' ),
                'selector' => '{{WRAPPER}} .tab-content h2',
            ]
        );
        $this->add_responsive_control(
            'heading_padding',
            [
                'label' => __( 'Padding', 'hostiko-toolkit' ),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%', 'em' ],
                'selectors' => [
                    '{{WRAPPER}} .tab-content h2' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'heading_margin',
            [
                'label' => __( 'Margin', 'hostiko-toolkit' ),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%', 'em' ],
                'selectors' => [
                    '{{WRAPPER}}  .tab-content h2' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'heading_align',
 
            [
                'label' => esc_html__( 'Alignment', 'hostiko-toolkit' ),
                'type' => \Elementor\Controls_Manager::CHOOSE,
                'options' => [
                    'left' => [
                        'title' => esc_html__( 'Left', 'hostiko-toolkit' ),
                        'icon' => 'eicon-text-align-left',
                    ],
                    'center' => [
                    'title' => esc_html__( 'Center', 'hostiko-toolkit' ),
                        'icon' => 'eicon-text-align-center',
                    ],
                    'right' => [
                        'title' => esc_html__( 'Right', 'hostiko-toolkit' ),
                        'icon' => 'eicon-text-align-right',
                    ],
                ],
                'default' => 'left',
                'toggle' => true,
                'selectors' => [
                '{{WRAPPER}} .tab-content h2'   => 'text-align: {{VALUE}};',
                ],
            ]
        );
        $this->end_controls_section();
        $this->start_controls_section(
            'content_style',
            [
                'label' => esc_html__( 'Content Style', 'hostiko-toolkit' ),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_control(
            'content_color',
            [
                'label' => esc_html__( 'Content Color', 'hostiko-toolkit' ),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}}  .right-content p' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'name' => 'content_typography',
                'label' => __( 'Typography', 'hostiko-toolkit' ),
                'selector' => '{{WRAPPER}} .content-bg p',
            ]
        );
        $this->add_responsive_control(
            'content_padding',
            [
                'label' => __( 'Padding', 'hostiko-toolkit' ),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%', 'em' ],
                'selectors' => [
                    '{{WRAPPER}} .content-bg' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'content_margin',
            [
                'label' => __( 'Margin', 'hostiko-toolkit' ),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%', 'em' ],
                'selectors' => [
                    '{{WRAPPER}}  .content-bg' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'content_align',
 
            [
                'label' => esc_html__( 'Alignment', 'hostiko-toolkit' ),
                'type' => \Elementor\Controls_Manager::CHOOSE,
                'options' => [
                    'left' => [
                        'title' => esc_html__( 'Left', 'hostiko-toolkit' ),
                        'icon' => 'eicon-text-align-left',
                    ],
                    'center' => [
                    'title' => esc_html__( 'Center', 'hostiko-toolkit' ),
                        'icon' => 'eicon-text-align-center',
                    ],
                    'right' => [
                        'title' => esc_html__( 'Right', 'hostiko-toolkit' ),
                        'icon' => 'eicon-text-align-right',
                    ],
                ],
                'default' => 'left',
                'toggle' => true,
                'selectors' => [
                '{{WRAPPER}} .content-bg'   => 'text-align: {{VALUE}};',
                ],
            ]
        );
        $this->add_group_control(
            \Elementor\Group_Control_Background::get_type(),
            [
                'name' => 'content_background',
                'types' => [ 'classic', 'gradient', 'video'],
                'selector' => '{{WRAPPER}} .content-bg',
            ]
        );
        $this->add_responsive_control(
            'content_border_radius',
            [
                'label' => esc_html__( 'Content Border Radius', 'hostiko-toolkit' ),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
                'selectors' => [
                    '{{WRAPPER}} .content-bg' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'image_align',
 
            [
                'label' => esc_html__( 'Image Alignment', 'hostiko-toolkit' ),
                'type' => \Elementor\Controls_Manager::CHOOSE,
                'options' => [
                    'left' => [
                        'title' => esc_html__( 'Left', 'hostiko-toolkit' ),
                        'icon' => 'eicon-text-align-left',
                    ],
                    'center' => [
                    'title' => esc_html__( 'Center', 'hostiko-toolkit' ),
                        'icon' => 'eicon-text-align-center',
                    ],
                    'right' => [
                        'title' => esc_html__( 'Right', 'hostiko-toolkit' ),
                        'icon' => 'eicon-text-align-right',
                    ],
                ],
                'default' => 'center',
                'toggle' => true,
                'selectors' => [
                '{{WRAPPER}} .image-align'   => 'text-align: {{VALUE}};',
                ],
            ]
        );
        $this->end_controls_section();
        $this->start_controls_section(
            'section_style',
            [
                'label' => esc_html__( 'Scrollbar Style', 'hostiko-toolkit' ),
                'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );
 
        $this->add_control(
            'max_height',
            [
                'label'      => esc_html__( 'Max Height', 'hostiko-toolkit' ),
                'type'       => \Elementor\Controls_Manager::NUMBER,
                'default'    => 250,
                'selectors'  => [
                    '{{WRAPPER}} .content-scroll' => 'max-height: {{VALUE}}px;',
                ],
            ]
        );
 
        $this->add_control(
            'track_color',
            [
                'label'      => esc_html__( 'Track Color', 'hostiko-toolkit' ),
                'type'       => \Elementor\Controls_Manager::COLOR,
                'default'    => '#f5f6f9',
                'selectors'  => [
                    '{{WRAPPER}} .content-scroll::-webkit-scrollbar' => 'background-color: {{VALUE}};',
                ],
            ]
        );
 
        $this->add_control(
            'handle_color',
            [
                'label'      => esc_html__( 'Handle Color', 'hostiko-toolkit' ),
                'type'       => \Elementor\Controls_Manager::COLOR,
                'default'    => '#4383eb',
                'selectors'  => [
                    '{{WRAPPER}} .content-scroll::-webkit-scrollbar-thumb' => 'background-color: {{VALUE}};',
                ],
            ]
        );
 
        $this->add_control(
            'handle_radius',
            [
                'label'      => esc_html__( 'Handle Radius', 'hostiko-toolkit' ),
                'type'       => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%' ],
                'selectors'  => [
                    '{{WRAPPER}} .content-scroll::-webkit-scrollbar-thumb' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_control(
            'scrollbar_width',
            [
                'label'      => esc_html__( 'Scrollbar Width', 'hostiko-toolkit' ),
                'type'       => \Elementor\Controls_Manager::NUMBER,
                'default'    => 3,
                'selectors'  => [
                    '{{WRAPPER}} .content-scroll::-webkit-scrollbar' => 'width: {{VALUE}}px;',
                ],
            ]
        );
        $this->add_control(
            'hover_track_color',
            [
                'label'      => esc_html__( 'Hover Track Color', 'hostiko-toolkit' ),
                'type'       => \Elementor\Controls_Manager::COLOR,
                'default'    => '#f5f6f9',
                'selectors'  => [
                    '{{WRAPPER}} .content-scroll::-webkit-scrollbar-track:hover' => 'background-color: {{VALUE}};',
                ],
            ]
        );
 
        $this->end_controls_section();
       
    }
 
    /**
     * Render widget output on the frontend.
     */
    protected function render() {
        $settings = $this->get_settings();
   
        if (empty($settings['tabs'])) {
            return;
        }
   
        // Output the HTML structure for the tabs and their content using the settings.
        ?>
        <div id="hostiko_custom_tabs" class="tab">
            <div class="row">
                <div class="col-md-3 mb-0" id="data-center-tabs">
                    <ul class="nav nav-pills flex-column" id="myTab" role="tablist">
                        <?php
                        foreach ($settings['tabs'] as $index => $tab) {
                            ?>
                            <li class="nav-item">
                                <a class="nav-link <?php if ($index == 0) { ?>active<?php } ?>" id="hostiko-tab-title-<?php echo $index; ?>" data-toggle="tab" href="#hostiko-tab-<?php echo $index; ?>" role="tab" aria-controls="<?php echo $tab['tab_title']; ?>" aria-selected="true">
                                    <div class="tab_tltle"><span><?php echo $tab['tab_title']; ?></span></div>
                                    <div class="tab-title-icon"><i class="<?php echo $tab['hostiko_tab_icon']['value']; ?>"></i></div>
                                </a>
                            </li>
                            <?php
                        }
                        ?>
                    </ul>
                </div>
   
                <div class="col-md-9 content-bg">
                    <div class="tab-content" id="myTabContent">
                        <?php
                        foreach ($settings['tabs'] as $index => $tab) {
                            ?>
                            <div id="hostiko-tab-<?php echo $index; ?>" class="tab-pane fade <?php if ($index == 0) { ?>show active<?php } ?>" role="tabpanel" aria-labelledby="<?php echo $tab['tab_title']; ?>-tab">
                                <div class="row right-content">
                                    <div class="col-lg-8 col-md-6 col-sm-12 image-align">
                                        <img alt="" src="<?php echo $tab['data_center_image']['url'] ?>">
                                    </div>
                                    <div class="col-lg-4 col-md-6 col-sm-12">
                                        <div class="content-scroll">
                                            <?php echo '<p class="t-2">' . $tab['tab_content'] . '</p>'; ?>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <?php
                        }
                        ?>
                    </div>
                </div>
            </div>
        </div>
        <?php
    }
   
 
    // Rest of the widget code...
}
 