<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

/**
 * Elementor hostiko-blog-post Widget.
 *
 * Elementor widget that uses the hostiko-blog-post control.
 *
 * @since 1.0.0
 */
class Elementor_Hostiko_Blog_Post_Widget extends \Elementor\Widget_Base {
	/**
	 * Get widget name.
	 *
	 * Retrieve hostiko-blog-post widget name.
	 *
	 * @since 1.0.0
	 * @access public
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'hostiko-blog-post';
	}
	/**
	 * Get widget title.
	 *
	 * Retrieve hostiko-blog-post widget title.
	 *
	 * @since 1.0.0
	 * @access public
	 * @return string Widget title.
	 */
	public function get_title() {
		return esc_html__( 'Hostiko Blog Posts', 'hostiko-toolkit' );
	}

	/**
	 * Get widget icon.
	 *
	 * Retrieve hostiko-blog-post widget icon.
	 *
	 * @since 1.0.0
	 * @access public
	 * @return string Widget icon.
	 */
	// public function get_icon() {
	// 	return 'eicon-carousel-loop';
	// }

	/**
	 * Register hostiko-blog-post widget controls.
	 *
	 * Add input fields to allow the user to customize the widget settings.
	 *
	 * @since 1.0.0
	 * @access protected
	 */
	protected function register_controls() {
        
        $this->start_controls_section(
			'content_section',
			[
				'label' => esc_html__( 'Content', 'hostiko-toolkit' ),
				'type' => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);
		$this->add_control(
			'number_of_post_blogs',
			[
				'label' => __( 'Number of Posts', 'hostiko-toolkit' ),
				'type' => \Elementor\Controls_Manager::NUMBER,
				'default' => 3, // Set a default value
				'min' => 1,
				'max' => 21,
				'step' => 1,
			]
			);
		$this->add_control(
			'resturant_post_blog_category',
			[
				'label' => esc_html__( 'Select Post Category', 'hostiko-toolkit' ),
				'type' => \Elementor\Controls_Manager::SELECT2,
				'multiple' => true,
				'options' => $this->get_post_blog_categories(),
				'default' => 'post',
			]
		);
        $this->end_controls_section();
		$this->start_controls_section(
			'post_order_section',
			[
				'label' => esc_html__('Post Order', 'hostiko-toolkit'),
				'tab'   => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);
		
		$this->add_control(
			'post_order',
			[
				'label'   => esc_html__('Post Order', 'hostiko-toolkit'),
				'type'    => \Elementor\Controls_Manager::CHOOSE,
				'options' => [
					'asc'  => [
						'title' => esc_html__('Ascending', 'hostiko-toolkit'),
						'icon'  => 'fa fa-sort-amount-asc',
					],
					'desc' => [
						'title' => esc_html__('Descending', 'hostiko-toolkit'),
						'icon'  => 'fa fa-sort-amount-desc',
					],
				],
				'default' => 'asc',
			]
		);
		
		$this->add_control(
			'post_order_by',
			[
				'label'   => esc_html__('Sort Order', 'hostiko-toolkit'),
				'type'    => \Elementor\Controls_Manager::CHOOSE,
				'options' => [
					'date'  => [
						'title' => esc_html__('Latest Posts', 'hostiko-toolkit'),
						'icon'  => 'fa fa-calendar',
					],
					'title' => [
						'title' => esc_html__('Alphabetical Order', 'hostiko-toolkit'),
						'icon'  => 'fa fa-sort-alpha-asc',
					],
				],
				'default' => 'date',
			]
		);
		
		$this->end_controls_section();
		$this->start_controls_section(
			'image_section',
			[
				'label' => esc_html__( 'Image Controls', 'hostiko-toolkit' ),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);
		
		$this->add_responsive_control(
			'image_size',
			[
				'label' => esc_html__( 'Image Size', 'hostiko-toolkit' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'default' => 'medium', // Set your default image size
				'options' => [
					'thumbnail' => 'Thumbnail',
					'medium' => 'Medium',
					'large' => 'Large',
					'full' => 'Full',
				],
			]
		);
		
		$this->end_controls_section();
		$this->start_controls_section(
			'date_comments_section',
			[
				'label' => esc_html__( 'Date & Comments', 'hostiko-toolkit' ),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);
		
		$this->add_control(
			'show_date_comments',
			[
				'label' => esc_html__( 'Show Date & Comments', 'hostiko-toolkit' ),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'default' => 'yes', // Set your default value
				'label_on' => 'Show',
				'label_off' => 'Hide',
			]
		);
		
		$this->end_controls_section();
		$this->start_controls_section(
			'image_control_section',
			[
				'label' => esc_html__( 'Image Dimensions', 'hostiko-toolkit' ),
				'tab' => \Elementor\Controls_Manager::TAB_STYLE,
			]
		);
		
		$this->add_responsive_control(
			'image_width',
			[
				'label' => esc_html__( 'Image Width', 'hostiko-toolkit' ),
				'type' => \Elementor\Controls_Manager::SLIDER,
				'size_units' => [ 'px', '%' ],
				'selectors' => [
					'{{WRAPPER}} img' => 'width: {{SIZE}}{{UNIT}};',
				],
			]);
		
		$this->add_responsive_control(
			'image_height',
			[
				'label' => esc_html__( 'image Height', 'hostiko-toolkit' ),
				'type' => \Elementor\Controls_Manager::SLIDER,
				'size_units' => [ 'px', '%' ],
				'selectors' => [
					'{{WRAPPER}} img' => 'height: {{SIZE}}{{UNIT}};',
				],
			]
		);
		$this->add_responsive_control(
			'object-fit',
			[
				'label' => esc_html__( 'Object Fit', 'elementor-services-post-control' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'condition' => [
					'image_height[size]!' => '',
				],
				'options' => [
					'' => esc_html__( 'Default', 'elementor-services-post-control' ),
					'fill' => esc_html__( 'Fill', 'elementor-services-post-control' ),
					'cover' => esc_html__( 'Cover', 'elementor-services-post-control' ),
					'contain' => esc_html__( 'Contain', 'elementor-services-post-control' ),
				],
				'default' => '',
				'selectors' => [
					'{{WRAPPER}} img' => 'object-fit: {{VALUE}};',
				],
			]
		);

		$this->add_responsive_control(
			'object-position',
			[
				'label' => esc_html__( 'Object Position', 'elementor-services-post-control' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'options' => [
					'center center' => esc_html__( 'Center Center', 'elementor-services-post-control' ),
					'center left' => esc_html__( 'Center Left', 'elementor-services-post-control' ),
					'center right' => esc_html__( 'Center Right', 'elementor-services-post-control' ),
					'top center' => esc_html__( 'Top Center', 'elementor-services-post-control' ),
					'top left' => esc_html__( 'Top Left', 'elementor-services-post-control' ),
					'top right' => esc_html__( 'Top Right', 'elementor-services-post-control' ),
					'bottom center' => esc_html__( 'Bottom Center', 'elementor-services-post-control' ),
					'bottom left' => esc_html__( 'Bottom Left', 'elementor-services-post-control' ),
					'bottom right' => esc_html__( 'Bottom Right', 'elementor-services-post-control' ),
				],
				'default' => 'center center',
				'selectors' => [
					'{{WRAPPER}} img' => 'object-position: {{VALUE}};',
				],
				'condition' => [
					'object-fit' => 'cover',
				],
			]
		);
		
		$this->end_controls_section();			
		$this->start_controls_section(
			'heading_style_section',
			[
				'label' => esc_html__( ' Heading Style', 'hostiko-toolkit' ),
				'tab' => \Elementor\Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_control(
			'heading_color',
			[
				'label' => __( ' Heading Color', 'hostiko-toolkit' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .news_articles_section h5' => 'color: {{VALUE}};',
				],
			]
		);
        $this->add_control(
			'heading1_color',
			[
				'label' => __( ' Heading Hover Color', 'hostiko-toolkit' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .news_articles_section .news_articles_box:hover h5' => 'color: {{VALUE}};',
				],
			]
		);
		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name' => 'heading_typography',
				'label' => __( ' Heading Typography', 'hostiko-toolkit' ),
				'selector' => '{{WRAPPER}} .news_articles_section h5',
			]
		);
		$this->add_responsive_control(
			'heading_margin',
			[
				'label' => __( ' Heading Margin', 'hostiko-toolkit' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'selectors' => [
					'{{WRAPPER}} .news_articles_section h5' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);
	
		$this->add_responsive_control(
			'heading_padding',
			[
				'label' => __( 'Heading Padding', 'hostiko-toolkit' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'selectors' => [
					'{{WRAPPER}} .news_articles_section h5' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);
		$this->end_controls_section();
		$this->start_controls_section(
			'text_style_section',
			[
				'label' => esc_html__( ' Text Style', 'hostiko-toolkit' ),
				'tab' => \Elementor\Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_control(
			'text_color',
			[
				'label' => __( ' Text Color', 'hostiko-toolkit' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .news_articles_section p' => 'color: {{VALUE}};',
				],
			]
		);
		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name' => 'Text_typography',
				'label' => __( ' Text Typography', 'hostiko-toolkit' ),
				'selector' => '{{WRAPPER}} .news_articles_section p',
			]
		);
		$this->add_responsive_control(
			'text_margin',
			[
				'label' => __( ' Text Margin', 'hostiko-toolkit' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'selectors' => [
					'{{WRAPPER}} .news_articles_section p' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);
	
		$this->add_responsive_control(
			'text_padding',
			[
				'label' => __( 'Text Padding', 'hostiko-toolkit' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'selectors' => [
					'{{WRAPPER}} .news_articles_section p' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);
		$this->end_controls_section();
		$this->start_controls_section(
			'date_style_section',
			[
				'label' => esc_html__( ' Date Style', 'hostiko-toolkit' ),
				'tab' => \Elementor\Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_control(
			'date_color',
			[
				'label' => __( ' Date Color', 'hostiko-toolkit' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .news_articles_section .span_wrapper' => 'color: {{VALUE}};',
				],
			]
		);
		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name' => 'date_typography',
				'label' => __( ' Date Typography', 'hostiko-toolkit' ),
				'selector' => '{{WRAPPER}} .news_articles_section .span_wrapper',
			]
		);
		$this->add_responsive_control(
			'date_margin',
			[
				'label' => __( ' Date Margin', 'hostiko-toolkit' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'selectors' => [
					'{{WRAPPER}} .news_articles_section .span_wrapper' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);
	
		$this->add_responsive_control(
			'date_padding',
			[
				'label' => __( 'Date Padding', 'hostiko-toolkit' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'selectors' => [
					'{{WRAPPER}} .news_articles_section .span_wrapper' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);
		$this->end_controls_section();
		$this->start_controls_section(
			'icon_style_section',
			[
				'label' => esc_html__( ' Icon Style', 'hostiko-toolkit' ),
				'tab' => \Elementor\Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_control(
			'icon_color',
			[
				'label' => __( ' Icon Color', 'hostiko-toolkit' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .news_articles_section i' => 'color: {{VALUE}};',
				],
			]
		);
		$this->end_controls_section();
		$this->start_controls_section(
			'content_style_section',
			[
				'label' => esc_html__( 'Box  Style', 'hostiko-toolkit' ),
				'tab' => \Elementor\Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_responsive_control(
			'contentmain_margin',
			[
				'label' => __( ' Content Margin', 'hostiko-toolkit' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'selectors' => [
					'{{WRAPPER}} .news_articles_box' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);
		$this->add_responsive_control(
			'border_radius1',
			[
				'label' => esc_html__( 'Box Border Radius', 'elementor' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
				'selectors' => [
					'{{WRAPPER}} .news_articles_box' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);
		$this->add_control(
			'box_background_color',
			[
				'label' => esc_html__( 'Box background', 'elementor' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'default' => '',
				'selectors' => [
					'{{WRAPPER}} .news_articles_box' => 'background-color: {{VALUE}};',
				],
			]
		);
        $this->add_group_control(
            \Elementor\Group_Control_Box_Shadow::get_type(),
            [
                'name' => 'content_box_shadow',
                'exclude' => [
                    'box_shadow_position',
                ],
                'selector' => '{{WRAPPER}} .news_articles_box',
            ]
        );
		$this->add_responsive_control(
			'contentmain_padding',
			[
				'label' => __( 'Content Padding', 'hostiko-toolkit' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'selectors' => [
					'{{WRAPPER}} .news_articles_section .news_articles_box_content' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);
		$this->add_responsive_control(
			'border_radius',
			[
				'label' => esc_html__( 'Image Border Radius', 'elementor' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
				'selectors' => [
					'{{WRAPPER}} .news_articles_section img' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);
		$this->add_responsive_control(
            'content_align',
            [
                'label' => esc_html__( 'Alignment', 'hostiko-toolkit' ),
                'type' => \Elementor\Controls_Manager::CHOOSE,
                'options' => [
                    'left' => [
                        'title' => esc_html__( 'Left', 'hostiko-toolkit' ),
                        'icon' => 'eicon-text-align-left',
                    ],
                    'center' => [
                        'title' => esc_html__( 'Center', 'hostiko-toolkit' ),
                        'icon' => 'eicon-text-align-center',
                    ],
                    'right' => [
                        'title' => esc_html__( 'Right', 'hostiko-toolkit' ),
                        'icon' => 'eicon-text-align-right',
                    ],
                ],
                'default' => 'left',
                'toggle' => true,
                'selectors' => [
                    '{{WRAPPER}} .news_articles_section .news_articles_box_content'   => 'text-align: {{VALUE}};',
                ],
            ]
        );
		$this->end_controls_section();

        $this->start_controls_section(
            'style_section',
            [
                'label' => esc_html__('Style Settings', 'hostiko-toolkit'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );
        
        $this->add_control(
            'overflow',
            [
                'label' => esc_html__('Overflow', 'hostiko-toolkit'),
                'type' => \Elementor\Controls_Manager::SELECT,
                'options' => [
                    'visible' => esc_html__('Visible', 'hostiko-toolkit'),
                    'hidden' => esc_html__('Hidden', 'hostiko-toolkit'),
                    'scroll' => esc_html__('Scroll', 'hostiko-toolkit'),
                    'auto' => esc_html__('Auto', 'hostiko-toolkit'),
                ],
                'default' => 'visible', // Default value is visible
                'selectors' => [
                    '{{WRAPPER}} .news_articles_box'   => 'overflow: {{VALUE}};',
                ],
            ]
        );
        
        $this->end_controls_section();
	}
		/**
	 * Get hostiko-blog-post categories.
	 *
	 * Retrieve the hostiko-blog-post categories to populate the category control.
	 *
	 * @since 1.0.0
	 * @access protected
	 * @return array hostiko-blog-post categories.
	 */
	protected function get_post_blog_categories() {
		$categories = get_categories( array( 'taxonomy' => 'category' ) );
		$options = array();

		foreach ( $categories as $category ) {
			$options[ $category->term_id ] = $category->name;
		}
		return $options;
	}
	/**
	 * Render hostiko-blog-post widget output on the frontend.
	 *
	 * Written in PHP and used to generate the final HTML.
	 *
	 * @since 1.0.0
	 * @access protected
	 */
	protected function render() {
		$settings = $this->get_settings_for_display();
		$number_of_post_blogs = $settings['number_of_post_blogs'];
		$category = $settings['resturant_post_blog_category'];
		$image_size = $settings['image_size']; // Get the selected image size
		// Get user-selected post order (ascending or descending)
		$post_order = ($settings['post_order'] === 'asc') ? 'ASC' : 'DESC';
		$show_date_comments = $settings['show_date_comments']; // Get the user's selection
		// Get user-selected sorting order (latest posts or alphabetical)
		$post_order_by = ($settings['post_order_by'] === 'date') ? 'date' : 'title';
		
		$args = array(
			'post_type'      => 'post',
			'posts_per_page' => $number_of_post_blogs,
			'tax_query'      => array(
				array(
					'taxonomy' => 'category',
					'field'    => 'Name',
					'terms'    => $category,
				),
			),
			'order'          => $post_order,    // Use user-selected post order
			'orderby'        => $post_order_by, // Use user-selected sorting order
		);
		
		$result = new WP_Query($args);
		
		echo '<div class="news_articles_section position-relative">';
		if ($result->have_posts()) {
			echo '<div class="row" data-aos="fade-up">';
			$count = 0;
			while ($result->have_posts()) {
				$result->the_post();
				$post_id = get_the_ID();
				$meta = get_the_post_thumbnail(get_the_ID(), 'large');
				$comment_count = get_comments_number($post_id);
				?>
				<div class="col-lg-4 col-md-6 col-sm-12 col-12">
					<div class="news_articles_box">
						<a href="<?php echo the_permalink(); ?><?php isset($_GET['view'])?'view='.$_GET['view']:'' ?>">
							<figure class="mb-0">
								<?php echo get_the_post_thumbnail($post_id, $image_size); ?>
							</figure>
						</a>
						<div class="news_articles_box_content">
							<?php if ($show_date_comments === 'yes') {
								?>
							<div class="span_wrapper">
								<span><?php echo get_the_date(__('M d, Y')) ?></span>
								<span class="dash">-</span>
								<span><?php echo $comment_count; ?> Comments</span>
							</div>
							<?php } ?>
							<a href="<?php echo get_post_permalink(); ?>">
								<h5 class="heading-txt"><?php the_title(); ?></h5>
							</a>
							<p class="hostiko-blog-post-contents"><?php echo wp_trim_words(get_the_content(), 9) ?></p>
						</div>
					</div>
				</div>
				<?php
			}
		}
		echo '</div>';
		?>
		<?php
	}
	
	

}
