<?php
/**
 * Elementor hostiko-testimonial control.
 *
 * A control for displaying a select field with the ability to choose currencies.
 *
 * @since 1.0.0
 */
class Elementor_Hostiko_Testimonial_Control extends \Elementor\Base_Data_Control {

	/**
	 * Get hostiko-testimonial control type.
	 *
	 * Retrieve the control type, in this case `hostiko-testimonial`.
	 *
	 * @since 1.0.0
	 * @access public
	 * @return string Control type.
	 */
	public function get_type() {
		return 'hostiko-testimonial';
	}


	/**
	 * Render hostiko-testimonial control output in the editor.
	 *
	 * Used to generate the control HTML in the editor using Underscore JS
	 * template. The variables for the class are available using `data` JS
	 * object.
	 *
	 * @since 1.0.0
	 * @access public
	 */
	
	public function content_template() {
		$control_uid = $this->get_control_uid();
	}

}