<?php

/**
 * The plugin bootstrap file
 *
 * This file is read by WordPress to generate the plugin information in the plugin
 * admin area. This file also includes all of the dependencies used by the plugin,
 * registers the activation and deactivation functions, and defines a function
 * that starts the plugin.
 *
 * @link              https://designingmedia.com/
 * @since             1.0.0
 * @package           Akd_Framework
 *
 * @wordpress-plugin
 * Plugin Name:       AKD Demo Importer
 * Plugin URI:        https://designingmedia.com/
 * Description:       This plugin will help you to import theme's demo content.
 * Version:           1.0.2
 * Author:            Designingmedia
 * Author URI:        https://designingmedia.com//
 * License:           GPL-2.0+
 * License URI:       http://www.gnu.org/licenses/gpl-2.0.txt
 * Text Domain:       akd-demo-importer
 * Domain Path:       /languages
 */

// If this file is called directly, abort.
if ( ! defined( 'WPINC' ) ) {
	die;
}

/**
 * Currently plugin version.
 * Start at version 1.0.0 and use SemVer - https://semver.org
 * Rename this for your plugin and update it as you release new versions.
 */
define( 'AKD_FRAMEWORK_VERSION', '1.0.0' );

/**
 * The code that runs during plugin activation.
 * This action is documented in includes/class-akd-framework-activator.php
 */
function activate_akd_framework() {
	require_once plugin_dir_path( __FILE__ ) . 'includes/class-akd-framework-activator.php';
	Akd_Framework_Activator::activate();
}
function akd_importer_language() {
	load_plugin_textdomain( 'akd-demo-importer', false, dirname( plugin_basename( __FILE__ ) ) . '/languages' );

}
add_action( 'plugins_loaded', 'akd_importer_language' );
/**
 * The code that runs during plugin deactivation.
 * This action is documented in includes/class-akd-framework-deactivator.php
 */
function deactivate_akd_framework() {
	require_once plugin_dir_path( __FILE__ ) . 'includes/class-akd-framework-deactivator.php';
	Akd_Framework_Deactivator::deactivate();
}

register_activation_hook( __FILE__, 'activate_akd_framework' );
register_deactivation_hook( __FILE__, 'deactivate_akd_framework' );

/**
 * The core plugin class that is used to define internationalization,
 * admin-specific hooks, and public-facing site hooks.
 */
require plugin_dir_path( __FILE__ ) . 'includes/class-akd-framework.php';

/**
 * Codestar Framework include
 */
require_once plugin_dir_path( __FILE__ ) . 'includes/codestar-framework/classes/setup.class.php';

/**
 * Begins execution of the plugin.
 *
 * Since everything within the plugin is registered via hooks,
 * then kicking off the plugin from this point in the file does
 * not affect the page life cycle.
 *
 * @since    1.0.0
 */
function run_akd_framework() {

	/**
	 * Apply parent and child theme validation
	 */
	if(wp_get_theme()->get('Name') == 'Hostiko' || wp_get_theme()->get('Name') == 'Hostiko Child'){
		$plugin = new Akd_Framework();
		$plugin->run();
	}

}
run_akd_framework();