<?php

/**
 * Abstract Class for creating meta boxes using CodeStart Framework
 *
 * @since      0.9.0
 * @package    Akd_Framework
 * @subpackage Akd_Framework/includes
 */
abstract class Akd_Framework_Meta {
	private $prefix;
	protected $post_type;
	private $mem_prefix;

	public function __construct( $plugin_name ) {
		$this->prefix = $plugin_name;
		$this->init_meta();
		$this->introduce_tabs();
		$this->admin_init();

	}

	private function pre($data){
		echo '<pre>'; print_r($data);
	}

	/**
	 * Method to create admin options
	 *
	 * @return void
	 */
	private function admin_init(  ){
		$activated_theme = wp_get_theme();
		
		// Create options
		CSF::createOptions(
			'akd-framework-admin-page',
			array(
				'menu_title'         => __( $activated_theme->get('Name') .' Settings', 'akd-demo-importer' ),
				'menu_slug'          => 'akd-framework',
				'framework_title'    => __( $activated_theme->get('Name') .' Options', 'akd-demo-importer' ),
				'menu_position'      => 15,
				'show_search'        => false,
				'show_reset_all'     => false,
				'show_reset_section' => false,
				'ajax_save'          => false,
			)
		);

		//theme activation
		CSF::createSection(
			'akd-framework-admin-page',
			array(
				'title'  => __( 'Theme Dashboard', 'akd-demo-importer' ),
				'fields' => array(

					array(
						'id'            => 'akd-theme-dashboard',
						'type'          => 'tabbed',
						'class' 		=> 'akd-framework-tabbed',
						'tabs'          => array(
							array(
								'title'     => 'General',
								'icon'      => 'fa fa-cube',
								'fields'    => array(
									array(
										'id'      => 'akd-act-name',
										'type'    => 'text',
										'title'   => __('Full Name *', 'akd-demo-importer'),
										'placeholder' => __('Your name.', 'akd-demo-importer'),
										'class' => 'akd-full-name',
										'required' => true
									),
				
									array(
										'id'      => 'akd-act-email',
										'type'    => 'text',
										'title'   => __('Email *', 'akd-demo-importer'),
										'placeholder' => __('Your email.', 'akd-demo-importer'),
										'class' => 'akd-email',
										'required' => true
									),
				
									array(
										'id'         => 'akd-act-options',
										'type'       => 'radio',
										'title'      => __('Activation Method', 'akd-demo-importer'),
										'options'    => array(
											'purchase-code' 	  => __('Already have a purchase code', 'akd-demo-importer'),
											'get-purchase-code' => __('Downloaded Hostiko from Envato Elements', 'akd-demo-importer'),
										),
										'default'    => 'purchase-code',
										'class' => 'akd-act-option'
									),
								)
							),
							array(
								'title'     => __('Plugins', 'akd-demo-importer'),
								'icon'      => 'fa fa-plug',
								'fields'    => array(
									array(
										'type'     => 'callback',
										'function' => array($this, 'akd_required_plugins_callback'),
									),
								)
							),
							array(
								'title'     => __('Demo Data', 'akd-demo-importer'),
								'icon'      => 'fa fa-desktop',
								'fields'    => array(
									array(
										'type'     => 'callback',
										'function' => array($this, 'akd_theme_demo_importer_callback'),
									),
								)
							),

							array(
								'title'     => __('Install Demo', 'akd-demo-importer'),
								'icon'      => 'fa fa-download',
								'fields'    => array(
									array(
										'type'     => 'callback',
										'function' => array($this, 'akd_install_demo_data_callback'),
									),
								)
							),

							$this->akd_get_elementor_theme_settings(),
							
						)
					),
				),
			)
		);

		//whmcs
		CSF::createSection(
			'akd-framework-admin-page',
			array(
				'title'  => __( 'WHMCS API Integrations', 'akd-demo-importer' ),
				'fields' => array(
					array(
						'id'      => 'akd-whmcs-api',
						'type'    => 'text',
						'title'   => esc_html__('Please enter your WHMCS API', 'akd-demo-importer'),
					),

					array(
						'id'      => 'akd-whmcs-api-identifier',
						'type'    => 'text',
						'title'   => esc_html__('Please enter your API Indentifier', 'akd-demo-importer'),
					),

					array(
						'id'      => 'akd-whmcs-api-secret',
						'type'    => 'text',
						'title'   => esc_html__('Please enter your API Secret', 'akd-demo-importer'),
					),
				),
			)
		);
	}

	/**
	 * Method to load all required plugins by the theme
	 */
	public function akd_required_plugins_callback() {

		$merlin = new Merlin;
		$merlin->plugins();

	}
	
	/**
	 * Method to load theme's demo data
	 */
	public function akd_theme_demo_importer_callback(){
		$content = '';
		$base_url = get_option('_akd_download_url').'Hostiko/';
		$json_url = $base_url . 'akd-importer-data-listing.json';

		$json_content = file_get_contents($json_url);

		// Check if the content was fetched successfully
		if ($json_content === FALSE) {
			$content .= __('Failed to retrieve the content.', 'akd-demo-importer');
		} else {
			// Optionally, decode the JSON content into an associative array
			$data = json_decode($json_content, true);

			// Check if the JSON decoding was successful
			if ($data === NULL) {
				$content .= '<span class="akd-demos">'.__('No demos available.', 'akd-demo-importer').'</span>';
			} else {

				$content .= '
					<div class="akd-required-plugins-section">
						<p class="akd-required-plugin-info-box-notice">'.__('Select your desired demo, and then click "Install" to initiate the installation of the demo data.', 'akd-demo-importer').'</p>	
					</div>

					<div class="akd-manual-import">
						<h5 class="akd-manual-import-title">
							'.__('Installing Demo Content Manually', 'akd-demo-importer').'
						</h5>
						<p>'.__('If you encounter any issues importing demo data, you always have the option to upload it manually:', 'akd-demo-importer').'</p>
						
						<label for="layout_select">Select your layout to download: </label>
						<select name="layout_select" id="layout_select">';

							foreach($data as $akd_demo_key => $demo_data){
								$content .= '<option value="' . $demo_data['scr'] . '">' . $demo_data['title'] . '</option>';
							}
							
						$content .= '</select>';
						
						$content .= '<ol>
							<li> '.__('Click to download ', 'akd-demo-importer').' <a href="layout-65" class="akd-download-manual-files" target="_blank">'.__('this zip file.', 'akd-demo-importer').'</a></li>
							<li> '.__('Upload the downloaded zip file to "demo" folder within the akd-demo-importer plugin, e.g. /wp-content/plugins/akd-demo-importer/admin/demo', 'akd-demo-importer').' </li>
							<li> '.__('Revisit this page, refresh it, and then proceed with another attempt to import the demo.', 'akd-demo-importer').' </li>
						</ol>
					</div>
				';


				// Output the JSON data (or handle it as needed)
				$content .= '<div class="demo-container">';
					foreach($data as $akd_demo_key => $demo_data){
						$class = '';
						if(get_option('_akd_imported_layout') && get_option('_akd_imported_layout') == explode(' ', $demo_data['title'])[1]){
							$class = 'import-layout';
						} else if(get_option('_akd_imported_layout') && get_option('_akd_imported_layout') != explode(' ', $demo_data['title'])[1]){
							$class = 'not-imported-layout';
						} else {
							$class = '';
						}
						$content .= '
							<div class="demo-item '.$class.'">
								<div class="screenshot-container">
									<img class="screenshot" src="' . get_option( '_akd_download_url' ) .'Hostiko/'. $demo_data['scr'].'.png' . '" alt="' . $demo_data['title'] . '">
									<div class="overlay"></div>
									<div class="button-container">
										<a class="preview-button" href="https://hostiko.com/layout' . explode(' ', $demo_data['title'])[1] . '" target="_blank">'.__('Preview', 'akd-demo-importer').'</a>
										<a class="proceed-button akd-trigger-import" data-layout="'.explode(' ', $demo_data['title'])[1].'" href="#" >'.__('Install', 'akd-demo-importer').'</a>
									</div>
								</div>
								<div class="layout-name">' . $demo_data['title'] . '</div>
							</div>
						';
					}
				$content .= '</div>'; 

				if(get_option('_akd_demo_import')){
					$content .= '<a href="" class="akd-content-next"> '.__('Next', 'akd-demo-importer').' </a>';
				}
			}
		}

		echo $content;
	}

	/**
	 * Method to show merlin import layout
	 */
	public function akd_install_demo_data_callback(){
		
		$merlin = new Merlin;
		$merlin->content();

		$content = '';
		$content .= '<div class="akd-demo-import-content">

		</div>';
	}

	/**
	 * Method to get and present the elementor color settings within theme settings tabs
	 */
	private function akd_get_elementor_theme_settings(){
		if (in_array('elementor/elementor.php', apply_filters('active_plugins', get_option('active_plugins')))) {

			// Path to the JSON file
			$font_file_path = plugin_dir_path(__FILE__) . 'class-akd-framework-google-font-list.json';
			// Read the JSON file content
			$json_content = file_get_contents($font_file_path);
			// Decode the JSON string into a PHP array
			$fonts_array = json_decode($json_content, true);

			$active_kit_id = get_option('elementor_active_kit');
			$elementor_global_settings = get_option('_akd_elementor_global');

			if ($active_kit_id) {
				// $elementor_data = json_decode($elementor_global_settings, true);
				$elementor_data = get_post_meta($active_kit_id, '_elementor_page_settings', true);
				
				if($elementor_data){
					$dropdowns_arr = [];
					foreach ($elementor_data['system_typography'] as $key => $typography) {
						$dropdowns_arr[] = array(
							'id'          => 'akd-'.$typography['_id'].'-typography',
							'type'        => 'select',
							'title'       => __($typography['title'], 'wp-whmcs-sync'),
							'chosen'      => true,
							'ajax'        => true,
							'placeholder' => __('Select an option', 'wp-whmcs-sync'),
							'options' 	  => $fonts_array,
							'default' => $typography['typography_font_family']
						);
					}
	
					$font_weight_arr = [];
					foreach ($elementor_data['system_typography'] as $key => $typography) {
						$font_weight_arr[] = array(
							'id'    => 'akd-'.$typography['_id'].'-font-weight',
							'type'  => 'number',
							'title' => __($typography['title'] . ' font weight', 'akd-demo-importer'),
							'default' => isset($typography['typography_font_weight']) ? $typography['typography_font_weight'] : '',
						);
					}
	
					$custom_colors_options = array();
					$custom_colors_default = array();
					$options = array();
					$default_colors = array();
	
					foreach ($elementor_data['system_colors'] as $color_data) {
						$color_id = $color_data['_id'];
						$color_title = ucfirst($color_data['title']); // Capitalize the first letter of the title
						$color_key = str_replace('-', '_', $color_id); // Convert hyphens to underscores for the option key
						
						// Add color options for regular and hovered states
						$options[$color_key] = $color_title;
						// $options[$color_key . '_hovered_state'] = $color_title . ' (hovered state)';
						
						// Add default colors
						$default_colors[$color_key] = $color_data['color'];
						// $default_colors[$color_key . '_hovered_state'] = $color_data['color'];
					}
	
					if (isset($elementor_data['custom_colors'])) {
						foreach ($elementor_data['custom_colors'] as $color_data) {
							$color_id = $color_data['_id'];
							$color_title = ucfirst($color_data['title']); // Capitalize the first letter of the title
							$color_key = 'custom-color-' . $color_id; // Construct the option key based on the color id
							$color = $color_data['color'];
	
							// Add color options for regular and hovered states
							$custom_colors_options[$color_key] = $color_title;
							// $custom_colors_options[$color_key . '-hovered-state'] = $color_title . ' (hovered state)';
	
							// Add default colors
							$custom_colors_default[$color_key] = $color;
							// $custom_colors_default[$color_key . '-hovered-state'] = $color;
						}
					}
	
					$theme_settings = array(
						'title'  => __( 'Theme Settings', 'akd-demo-importer' ),
						'fields' => array(
							array(
								'type'    => 'subheading',
								'content' => __('Global Colors', 'akd-demo-importer'),
							),
							array(
								'id' => 'akd-theme-colors',
								'type' => 'color_group',
								'title' => __('Theme Colors', 'akd-demo-importer'),
								'options' => $options,
								'default' => $default_colors
							),
							// Custom colors
							array(
								'id' => 'akd-custom-colors',
								'type' => 'color_group',
								'title' => __('Custom Colors', 'akd-demo-importer'),
								'options' => $custom_colors_options,
								'default' => $custom_colors_default
							),
							array(
								'type'    => 'subheading',
								'content' => __('Typography', 'akd-demo-importer'),
							),
							$dropdowns_arr[0],
							$font_weight_arr[0],
							$dropdowns_arr[1],
							$font_weight_arr[1],
							$dropdowns_arr[2],
							$font_weight_arr[2],
						),
					);
				} else {
					$theme_settings = array(
						'title'  => __( 'Theme Settings', 'akd-demo-importer' ),
						'fields' => array(
							array(
								'type'    => 'notice',
								'style'   => 'error',
								'content' => __('Please import demo content to make the theme settings enable.', 'akd-demo-importer'),
							),
						),
					);
				}
			} else {
				$theme_settings = array(
					'title'  => __( 'Theme Settings', 'akd-demo-importer' ),
					'fields' => array(
						array(
							'type'    => 'notice',
							'style'   => 'error',
							'content' => __('Please import demo content to make the theme settings enable.', 'akd-demo-importer'),
						),
					),
				);
			}

		} else {
			$theme_settings = array(
				'title'  => __( 'Theme Settings', 'akd-demo-importer' ),
				'fields' => array(
					array(
						'type'    => 'subheading',
						'content' => __('Global Colors', 'akd-demo-importer'),
					),
					array(
						'type'    => 'subheading',
						'content' => __('Typography', 'akd-demo-importer'),
					),
				),
			);
		}

		return $theme_settings;

	}

	/**
	 * Method to create metabox
	 *
	 * @return void
	 */
	private function init_meta() {
		CSF::createMetabox(
			$this->prefix,
			array(
				'title'     => __( $this->meta_title, 'akd-demo-importer' ),
				'post_type' => $this->post_type,
			)
		);
	}

	/**
	 * Method to populate the metabox
	 *
	 * @return void
	 */
	private function introduce_tabs() {
		$tabs = $this->get_fields();
		foreach ( $tabs as $tab ) {
			CSF::createSection( $this->prefix, $tab );
		}
	}
}


//extra
// array(
// 	'title'     => __('Plugins', 'akd-demo-importer'),
// 	'icon'      => 'fa fa-plug',
// 	'fields'    => array(
// 		array(
// 			'id'        => 'plugin_data',
// 			'type'      => 'text',
// 			'title'     => __('Plugin Data', 'akd-demo-importer'),
// 			'desc'      => __('Enter plugin data here.', 'akd-demo-importer'),
// 			'default'   => '',
// 			'dependency'=> array( 'show_plugin_data', '==', 'true' ),
// 		),
// 		array(
// 			'id'        => 'show_plugin_data',
// 			'type'      => 'checkbox',
// 			'title'     => __('Show Plugin Data', 'akd-demo-importer'),
// 			'desc'      => __('Check to show plugin data field.', 'akd-demo-importer'),
// 			'default'   => false,
// 		),
// 	),
// 	'callbacks' => array(
// 		'fields' => array(
// 			'show_plugin_data' => function( $args, $value ) {
// 				echo '<pre>'; print_r($value); exit;
// 				// Here you can define your callback logic
// 				if ( $value ) {
// 					return true; // Show the plugin data field
// 				}
// 				return false; // Hide the plugin data field
// 			},
// 		),
// 	),
// ),