<?php

/**
 * The admin-specific functionality of the plugin.
 *
 * @link       https://http://designingmedia.com/
 * @since      1.0.0
 *
 * @package    Akd_Framework
 * @subpackage Akd_Framework/admin
 */

/**
 * The admin-specific functionality of the plugin.
 *
 * Defines the plugin name, version, and two examples hooks for how to
 * enqueue the admin-specific stylesheet and JavaScript.
 *
 * @package    Akd_Framework
 * @subpackage Akd_Framework/admin
 * @author     Ammar Nasir <info@domain.com>
 */
trait Akd_Theme_Activation {

	/**
	 * Method to validate envato purchase code
	 */
	public function validate_purchase_code_handler(){
		if(isset($_POST['action']) && $_POST['action'] === 'validate_purchase_code' && isset($_POST['purchaseCode']) && isset($_POST['email']) && isset($_POST['name'])){
			if(!empty($_POST['purchaseCode']) && !empty($_POST['name']) && !empty($_POST['email'])){
				
				$envato_validation = get_option( '_purchase_code_validate' );
				if($envato_validation != true){

					//generate and get access token for the APIs
					$akd_validation_token = $this->akd_request_validation_token($_SERVER['HTTP_HOST']);
					
					if($akd_validation_token){
						//get envato personal token
						$response = $this->akd_trigger_api(''.get_option('_akd_api_server_url').'wp-json/akd/v1/envato-personal-token?domain='.$_SERVER['HTTP_HOST'].'&personal-token=true', 'GET', '', $akd_validation_token);
						if($response){
							$response = json_decode( $response, true );
							//if personal token is available then proceed
							if(isset($response['success']) && $response['success'] == true){
								$personal_token = $response['token'];

								//hit envato api to get item record and validity
								$exec = $this->akd_validate_envato_purchase($personal_token, $_POST['purchaseCode']);

								if (isset($exec["error"])) {
									wp_send_json_error( [
										'message' => __($exec["error"], 'akd-demo-importer')
									] );
								} else {
									if(is_array($exec['item'])){
										if($exec['item']['id'] == '20786821'){
											
											//validate purchase code and domain from the akd server
											$akd_purchase_code_response = $this->akd_request_to_validate_domain_and_purchase_code($_POST, $_SERVER['HTTP_HOST'], $exec['item'], $akd_validation_token);
											
											if(json_decode($akd_purchase_code_response, true)['message'] === 'New purchase code and domain added successfully.'){
												update_option( '_purchase_code_validate', true );
												$encryption_key = $this->akd_generate_encryption_key();
												update_option( '_encryption_key', $encryption_key );
												update_option( '_pruchase_code', $this->akd_encrypt_data($_POST['purchaseCode'], $encryption_key) );
												update_option( '_akd_designingmedia_validate', true );
				
												wp_send_json_success( [
													'message' => __('Congratulations! Your purchase code is validated. Please save your settings.', 'akd-demo-importer')
												] );
											} else {
												
												//validate purchase code and domain from the akd server
												$akd_purchase_code_response = $this->akd_request_purchase_code_status($_POST, $_SERVER['HTTP_HOST'], $akd_validation_token);
												if( json_decode( $akd_purchase_code_response, true )['status'] === 'active'){
													update_option( '_purchase_code_validate', true );
													$encryption_key = $this->akd_generate_encryption_key();
													update_option( '_encryption_key', $encryption_key );
													update_option( '_pruchase_code', $this->akd_encrypt_data($_POST['purchaseCode'], $encryption_key) );
													update_option( '_akd_designingmedia_validate', true );

													wp_send_json_success( [
														'message' => __('Congratulations! Your purchase code is validated. Please save your settings.', 'akd-demo-importer')
													] );
												} else {
													wp_send_json_error( [
														'message' => __(json_decode($akd_purchase_code_response, true)['message'], 'akd-demo-importer')
													] );
												}
											}
										} else {
											update_option( '_purchase_code_validate', false );
											wp_send_json_error( [
												'message' => __('Your purchase code is not validated! Please enter valid purchase code.', 'akd-demo-importer')
											] );
										}
									}
								}
							} else {
								wp_send_json_error( [
									'message' => __('Oops! Something went wrong.', 'akd-demo-importer')
								] );
							}
						}
					} else {
						$personal_token = $this->akd_decrypt_data(get_option('_personal_token'), get_option( '_encryption_key' ));

						//hit envato api to get item record and validity
						$exec = $this->akd_validate_envato_purchase($personal_token, $_POST['purchaseCode']);

						if (isset($exec["error"])) {
							wp_send_json_error( [
								'message' => __($exec["error"], 'akd-demo-importer')
							] );
						} else {
							if(is_array($exec['item'])){
								if($exec['item']['id'] == '20786821'){
									update_option( '_purchase_code_validate', true );
									$encryption_key = $this->akd_generate_encryption_key();
									update_option( '_encryption_key', $encryption_key );
									update_option( '_pruchase_code', $this->akd_encrypt_data($_POST['purchaseCode'], $encryption_key) );
									update_option( '_akd_designingmedia_validate', false );

									wp_send_json_success( [
										'message' => __('Congratulations! Your purchase code is validated. Please save your settings.', 'akd-demo-importer')
									] );
								} else {
									update_option( '_purchase_code_validate', false );
									wp_send_json_error( [
										'message' => __('Your purchase code is not validated! Please enter valid purchase code.', 'akd-demo-importer')
									] );
								}
							}
						}
					}

				} else if($envato_validation == true){
					//generate and get access token for the APIs
					$akd_validation_token = $this->akd_request_validation_token($_SERVER['HTTP_HOST']);

					if($akd_validation_token){
						//get envato personal token
						$response = $this->akd_trigger_api(''.get_option('_akd_api_server_url').'wp-json/akd/v1/envato-personal-token?domain='.$_SERVER['HTTP_HOST'].'&personal-token=true', 'GET', '', $akd_validation_token);
						if($response){
							$response = json_decode( $response, true );
							//if personal token is available then proceed
							if(isset($response['success']) && $response['success'] == true){
								$personal_token = $response['token'];

								//hit envato api to get item record and validity
								$exec = $this->akd_validate_envato_purchase($personal_token, $_POST['purchaseCode']);

								if (isset($exec["error"])) {
									wp_send_json_error( [
										'message' => __($exec["error"], 'akd-demo-importer')
									] );
								} else {
									if(is_array($exec['item'])){
										if($exec['item']['id'] == '20786821'){

											//validate purchase code and domain from the akd server
											$akd_purchase_code_response = $this->akd_request_purchase_code_status($_POST, $_SERVER['HTTP_HOST'], $akd_validation_token);

											if( json_decode( $akd_purchase_code_response, true )['status'] === 'active'){
												update_option( '_purchase_code_validate', true );
												$encryption_key = $this->akd_generate_encryption_key();
												update_option( '_encryption_key', $encryption_key );
												update_option( '_pruchase_code', $this->akd_encrypt_data($_POST['purchaseCode'], $encryption_key) );
												update_option( '_akd_designingmedia_validate', true );

												wp_send_json_success( [
													'message' => __('Congratulations! Your purchase code is validated. Please save your settings.', 'akd-demo-importer')
												] );
											} else {
												wp_send_json_error( [
													'message' => __('Your purchase code is already registered against the domain.', 'akd-demo-importer')
												] );
											}
										} else {
											update_option( '_purchase_code_validate', false );
											wp_send_json_error( [
												'message' => __('Your purchase code is not validated! Please enter valid purchase code.', 'akd-demo-importer')
											] );
										}
									}
								}
							} else {
								wp_send_json_error( [
									'message' => __('Oops! Something went wrong.', 'akd-demo-importer')
								] );
							}
						}
					}
				}
			} else {
				wp_send_json_error( [
					'message' => __('Please fill all required fields!', 'akd-demo-importer')
				] );
			}
		} else {
			wp_send_json_error( [
				'message' => __('Something Went Wrong!', 'akd-demo-importer')
			] );
		}
	}
	
	/**
	 * Method to get status of purchase code
	 */
	private function akd_request_purchase_code_status($posted_data, $domain, $akd_validation_token){
		$response = $this->akd_trigger_api(''.get_option('_akd_api_server_url').'/wp-json/akd/v1/get-purchase-code-status?domain='.$domain.'&purchase_code='.$posted_data['purchaseCode'].'', 'GET', '', $akd_validation_token);
		if($response){
			return $response;
		}
	}

	/**
	 * Method to get envato response
	 */
	private function akd_validate_envato_purchase($personal_token, $purchase_code){
		$url = "https://api.envato.com/v3/market/author/sale?code=" . $purchase_code;
		$request_headers = array();
		$request_headers[] = 'Authorization: Bearer ' . $personal_token;
		$request_headers[] = 'Accept: application/json';
		
		$curl = curl_init($url);
		curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
		curl_setopt($curl, CURLOPT_SSL_VERIFYPEER, FALSE);
		curl_setopt($curl, CURLOPT_SSL_VERIFYHOST, FALSE);
		curl_setopt($curl, CURLOPT_HTTPHEADER, $request_headers);
		curl_setopt($curl, CURLOPT_POST, 0);

		return json_decode(curl_exec($curl), true);
	}

	/**
	 * Method to encrypt data
	 */
	private function akd_encrypt_data($data, $key) {
		$cipher = "aes-256-cbc";
		$ivLength = openssl_cipher_iv_length($cipher);
		$iv = openssl_random_pseudo_bytes($ivLength);
		$encryptedData = openssl_encrypt($data, $cipher, $key, OPENSSL_RAW_DATA, $iv);
		$encryptedData = base64_encode($iv . $encryptedData);
		return $encryptedData;
	}

	/**
	 * Method to decrypt data
	 */
	private function akd_decrypt_data($data, $key) {
		$cipher = "aes-256-cbc";
		$ivLength = openssl_cipher_iv_length($cipher);
		$data = base64_decode($data);
		$iv = substr($data, 0, $ivLength);
		$encryptedData = substr($data, $ivLength);
		$decryptedData = openssl_decrypt($encryptedData, $cipher, $key, OPENSSL_RAW_DATA, $iv);
		return $decryptedData;
	}

	/**
	 * Method to generate a random encryption key
	 */
	private function akd_generate_encryption_key($length = 32) {
		return bin2hex(random_bytes($length));
	}

	/**
	 * Method to trigger API events
	 */
	private function akd_trigger_api($api_url, $method, $body, $token){
		$curl = curl_init();

		curl_setopt_array($curl, array(
			CURLOPT_URL => $api_url,
			CURLOPT_RETURNTRANSFER => true,
			CURLOPT_ENCODING => '',
			CURLOPT_MAXREDIRS => 10,
			CURLOPT_TIMEOUT => 30,
			CURLOPT_FOLLOWLOCATION => true,
			CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
			CURLOPT_CUSTOMREQUEST => $method,
			CURLOPT_POSTFIELDS => $body,
			CURLOPT_HTTPHEADER => [
				'Authorization: Bearer ' . $token
			],
		));

		$response = curl_exec($curl);
		curl_close($curl);
		return $response;

		// Check if there was a timeout
		// if (curl_errno($curl) == CURLE_OPERATION_TIMEOUTED) {
		// 	return 'API request timed out';
		// } else {
			
		// }

	}

	/**
	 * Method to request validation token
	 */
	private function akd_request_validation_token($domain){
		$response = $this->akd_trigger_api(''.get_option('_akd_api_server_url').'/wp-json/akd/v1/request-token?domain='.$domain.'', 'GET', '', '');
		if($response){
			if(json_decode($response, true)){
				return json_decode($response, true)['token'];
			}
		}
	}

	/**
	 * Method to check purchase code validation against domain
	 */
	private function akd_request_to_validate_domain_and_purchase_code($posted_data, $domain, $item, $akd_validation_token){
		$body = [
			'purchase_code'    => $posted_data['purchaseCode'],
			'domain' 		   => $domain,
			'envato_item_id'   => $item['id'],
			'envato_item_name' => $item['name'],
			'envato_item_url'  => $item['url'],
			'name' 			   => $posted_data['name'],
			'email' 		   => $posted_data['email']
		];

		$response = $this->akd_trigger_api(''.get_option('_akd_api_server_url').'/wp-json/akd/v1/submit-data', 'POST', $body, $akd_validation_token);
		if($response){
			return $response;
		}
	}

	/**
	 * Method to disconnect the domain
	 */
	public function disconnect_domain_handler(){
		if(isset($_POST['action']) && $_POST['action'] === 'disconnect_domain' && isset($_POST['purchaseCode'])){
			if(!empty($_POST['purchaseCode'])){
				$akd_validation_token = $this->akd_request_validation_token($_SERVER['HTTP_HOST']);
				if($akd_validation_token){
					$body = [
						'domain'    	=> $_SERVER['HTTP_HOST'],
						'purchase_code' => $_POST['purchaseCode'],
					];
			
					$response = $this->akd_trigger_api(''.get_option('_akd_api_server_url').'/wp-json/akd/v1/disconnect-domain', 'POST', $body, $akd_validation_token);
					if($response){
						if(json_decode( $response, true )['message'] === 'Domain status has been changed to inactive.' || json_decode( $response, true )['message'] === 'Record not found.'){

							//remove envato purchase code data from the site DB as well
							delete_option( '_purchase_code_validate' );
							delete_option( '_encryption_key' );
							delete_option( '_pruchase_code' );
							
							wp_send_json_success( ['message' => 'Domain has been disconnected.'] );
						}
					}
				}
			}
		}
	}


	/**
	 * Method to install child theme
	 */
	public function install_child_theme_handler(){
		if(isset($_POST['action']) && $_POST['action'] === 'install_child_theme' && isset($_POST['install'])){

			$activated_theme = wp_get_theme();
			$theme_name = $activated_theme->get('Name');
			$child_theme_name = $theme_name . ' Child';
			$child_theme_slug = sanitize_title($child_theme_name);
			$child_theme_path = get_theme_root() . '/' . $child_theme_slug;

			if (!file_exists($child_theme_path)) {
				// Ensure WP_Filesystem is loaded
				WP_Filesystem();
		
				global $wp_filesystem;
		
				// Create child theme directory and required files
				$wp_filesystem->mkdir($child_theme_path);
				$wp_filesystem->put_contents($child_theme_path . '/style.css', $this->generate_child_style_css(get_template(), $theme_name, $activated_theme->get('Author'), $activated_theme->get('Version')));
				$wp_filesystem->put_contents($child_theme_path . '/functions.php', $this->generate_child_functions_php($child_theme_slug));
		
				// Optionally, generate and save a screenshot for the child theme
				$this->generate_child_screenshot($child_theme_path);
		
				// Update allowed themes option
				$allowed_themes = get_option('allowedthemes');
				$allowed_themes[$child_theme_slug] = true;
				update_option('allowedthemes', $allowed_themes);
		
				// Activate child theme
				switch_theme($child_theme_slug);
		
				wp_send_json_success([
					'done' => 1,
					'message' => sprintf(__('The child theme "%s" has been successfully installed and activated.', 'your-text-domain'), $child_theme_name)
				]);
			} else {
				// Child theme already exists, activate it if it's not currently active
				if (get_stylesheet() !== $child_theme_slug) {
					switch_theme($child_theme_slug);
				}
		
				wp_send_json_success([
					'done' => 1,
					'message' => sprintf(__('The child theme "%s" is already installed and activated.', 'your-text-domain'), $child_theme_name)
				]);
			}
		}
	}

	/**
	 * Method to generate child theme css
	 */
	private function generate_child_style_css($slug, $parent, $author, $version) {
		$output = "
			/**
			* Theme Name: {$parent} Child
			* Description: This is a child theme of {$parent}, generated by AKD Demo Importer.
			* Author: {$author}
			* Template: {$slug}
			* Version: {$version}
			*/\n
		";

		// Let's remove the tabs so that it displays nicely.
		$output = trim( preg_replace( '/\t+/', '', $output ) );

		return apply_filters( 'merlin_generate_child_style_css', $output, $slug, $parent, $version );
	}

	/**
	 * Method to generate child theme function.php file
	 */
	private function generate_child_functions_php($slug) {
		$slug_no_hyphens = strtolower( preg_replace( '#[^a-zA-Z]#', '', $slug ) );

		$output = "
			<?php
			/**
			 * Theme functions and definitions.
			 * This child theme was generated by AKD Demo Importer.
			 *
			 * @link https://developer.wordpress.org/themes/basics/theme-functions/
			 */

			/*
			 * If your child theme has more than one .css file (eg. ie.css, style.css, main.css) then
			 * you will have to make sure to maintain all of the parent theme dependencies.
			 *
			 * Make sure you're using the correct handle for loading the parent theme's styles.
			 * Failure to use the proper tag will result in a CSS file needlessly being loaded twice.
			 * This will usually not affect the site appearance, but it's inefficient and extends your page's loading time.
			 *
			 * @link https://codex.wordpress.org/Child_Themes
			 */
			function {$slug_no_hyphens}_child_enqueue_styles() {
				wp_enqueue_style( '{$slug}-style' , get_template_directory_uri() . '/style.css' );
				wp_enqueue_style( '{$slug}-child-style',
					get_stylesheet_directory_uri() . '/style.css',
					array( '{$slug}-style' ),
					wp_get_theme()->get('Version')
				);
			}

			add_action(  'wp_enqueue_scripts', '{$slug_no_hyphens}_child_enqueue_styles' );\n
		";

		// Let's remove the tabs so that it displays nicely.
		$output = trim( preg_replace( '/\t+/', '', $output ) );

		// Filterable return.
		return apply_filters( 'merlin_generate_child_functions_php', $output, $slug );
	}

	/**
	 * Method to generate child theme screenshot
	 */
	private function generate_child_screenshot($path) {
		$screenshot = apply_filters( 'merlin_generate_child_screenshot', '' );

		if ( ! empty( $screenshot ) ) {
			// Get custom screenshot file extension
			if ( '.png' === substr( $screenshot, -4 ) ) {
				$screenshot_ext = 'png';
			} else {
				$screenshot_ext = 'jpg';
			}
		} else {
			if ( file_exists( get_template_directory() . '/screenshot.png' ) ) {
				$screenshot     = get_template_directory() . '/screenshot.png';
				$screenshot_ext = 'png';
			} elseif ( file_exists( get_template_directory() . '/screenshot.jpg' ) ) {
				$screenshot     = get_template_directory() . '/screenshot.jpg';
				$screenshot_ext = 'jpg';
			}
		}

		if ( ! empty( $screenshot ) && file_exists( $screenshot ) ) {
			$copied = copy( $screenshot, $path . '/screenshot.' . $screenshot_ext );
		}
	}

	/**
	 * Method to download theme files
	 */
	public function download_theme_files_handler(){
		if(isset($_POST['action']) && $_POST['action'] == 'download_theme_files' && isset($_POST['layout'])){
			if(!empty($_POST['layout'])){
				$akd_designingmedia = get_option( '_akd_designingmedia_validate' );
				// if($akd_designingmedia){
					$akd_validation_token = $this->akd_request_validation_token($_SERVER['HTTP_HOST']);
					$activated_theme = wp_get_theme();
					if(count(explode(' ', $activated_theme)) >= 2){
						$theme_name = explode(' ', $activated_theme)[0];
					} else {
						$theme_name = $activated_theme->get('Name');
					}
					if($akd_validation_token){
						// $demo_url = $this->akd_decrypt_data(get_option('_demo_url'), get_option( '_demo_manual_encryption_key' ));
						// $response = $this->akd_trigger_api(''.get_option('_akd_api_server_url').'wp-json/akd/v1/download-files?domain='.$_SERVER['HTTP_HOST'].'&layout='.$layout_number.'&theme='.$activated_theme->get('Name').'&return_url='.$demo_url.'/&manual=true', 'GET', '', $akd_validation_token);

						$response = $this->akd_trigger_api(''.get_option('_akd_api_server_url').'wp-json/akd/v1/download-files?domain='.$_SERVER['HTTP_HOST'].'&layout='.$_POST['layout'].'&theme='.$theme_name.'&return_url='.get_option('_akd_download_url').'&manual=true', 'GET', '', $akd_validation_token);
						if($response){
							$response = json_decode( $response, true );
							if($response['message'] === 'Zip file not found.'){
								wp_send_json_error( ['message' => $response['message']] );							
							} else if($response['message'] === 'Zip file found.') {
								wp_send_json_success( $response['url'] );
							} else {
								wp_send_json_error( ['message' => $response['message']] );
							}
						}
					}
				
			} else {
				wp_send_json_error( ['message' => 'Oops! Something went wrong.'] );	
			}
		}
	}

	/**
	 * Method to download import files
	 */
	public function download_import_files_handler(){
		if(isset($_POST['action']) && $_POST['action'] == 'download_import_files' && isset($_POST['layout'])){
			if(!empty($_POST['layout'])){

				$upload_dir = wp_upload_dir();
				$destination = $upload_dir['path'] . '/layout-'.$_POST['layout'].'';
				if (is_dir($destination)) {
					update_option('_akd_layout_going_to_import', $_POST['layout']);
					wp_send_json_success( 'true' );
				} else {
					$extracted_file = $this->download_akd_file($_POST['layout']);
					if($extracted_file){
						update_option('_akd_layout_going_to_import', $_POST['layout']);
						wp_send_json_success( 'true' );
					} else {
						wp_send_json_error( ['message' => __('Oops! Something went wrong.')] );
					}
				}
			}
		}
	}

	/**
	 * Method to save downloaded files into uploads
	 */
	private function download_akd_file($layout_number){
		$akd_validation_token = $this->akd_request_validation_token($_SERVER['HTTP_HOST']);
		$activated_theme = wp_get_theme();
		
		if(count(explode(' ', $activated_theme)) >= 2){
			$theme_name = explode(' ', $activated_theme)[0];
		} else {
			$theme_name = $activated_theme->get('Name');
		}

		if($akd_validation_token){
			
			$response = $this->akd_trigger_api(''.get_option('_akd_api_server_url').'wp-json/akd/v1/download-files?domain='.$_SERVER['HTTP_HOST'].'&layout='.$layout_number.'&theme='.$theme_name.'&return_url='.get_option('_akd_download_url').'', 'GET', '', $akd_validation_token);
			if($response){
				$response = json_decode( $response, true );
				if($response['message'] === 'Zip file found.') {
					// Define the path to the WordPress uploads directory
					$uploads_dir = wp_upload_dir()['path'];
					$zip_file_path = $uploads_dir . '/layout-'.get_option('_akd_imported_layout').'.zip';

					// Download the ZIP file
					$zip_file_content = file_get_contents($response['url']);
					if ($zip_file_content === false) {
						return false;
						// die('Failed to download the ZIP file.');
					}

					// Save the ZIP file to the uploads directory
					if (file_put_contents($zip_file_path, $zip_file_content) === false) {
						return false;
						// die('Failed to save the ZIP file.');
					}

					// Unzip the ZIP file in the uploads directory
					$zip = new ZipArchive;
					if ($zip->open($zip_file_path) === true) {
						$zip->extractTo($uploads_dir);
						$zip->close();
						
						// Optionally, you may want to delete the ZIP file after extraction
						unlink($zip_file_path);
						
						sleep(3);
						return true;
					} else {
						return false;
					}
					
				}
			}
		}
	}

}
